/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.commands;

import forestry.core.commands.CommandHelpers;
import forestry.core.commands.ICommandModeHelper;
import forestry.core.commands.SubCommand;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public final class CommandModeSet
extends SubCommand {
    private final String[] modeStringArr;
    private final ICommandModeHelper modeSetter;

    public CommandModeSet(ICommandModeHelper modeSetter) {
        super("set");
        this.setPermLevel(SubCommand.PermLevel.ADMIN);
        this.modeSetter = modeSetter;
        this.modeStringArr = modeSetter.getModeNames();
    }

    @Override
    public void executeSubCommand(MinecraftServer server, ICommandSender sender, String[] args) throws WrongUsageException {
        String modeName;
        if (args.length == 0 || args.length > 2) {
            this.printHelp(sender);
            return;
        }
        World world = sender.func_130014_f_();
        if (this.modeSetter.setMode(world, modeName = args[args.length - 1])) {
            CommandHelpers.sendLocalizedChatMessage(sender, "for.chat.command.forestry.mode.set.success", modeName);
        } else {
            CommandHelpers.sendLocalizedChatMessage(sender, "for.chat.command.forestry.mode.set.error", modeName);
            this.printHelp(sender);
        }
    }

    @Override
    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        return CommandHelpers.getListOfStringsMatchingLastWord(args, this.modeStringArr);
    }
}

