/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.climate;

import forestry.api.climate.ClimateStateType;
import forestry.api.climate.IClimateState;
import forestry.api.climate.IClimateStates;
import forestry.core.climate.AbsentClimateState;
import forestry.core.climate.ClimateState;
import net.minecraft.nbt.NBTTagCompound;

public final class ClimateStates
implements IClimateStates {
    public static final ClimateStates INSTANCE = new ClimateStates();
    public static final IClimateState ZERO = ClimateStates.of(0.0f, 0.0f);

    private ClimateStates() {
    }

    public static IClimateState of(float temperature, float humidity, ClimateStateType type) {
        return INSTANCE.create(temperature, humidity, type);
    }

    public static IClimateState of(float temperature, float humidity) {
        return INSTANCE.create(temperature, humidity, ClimateStateType.DEFAULT);
    }

    public static IClimateState extendedOf(float temperature, float humidity) {
        return INSTANCE.create(temperature, humidity, ClimateStateType.EXTENDED);
    }

    public static IClimateState extendedZero() {
        return INSTANCE.create(ZERO, ClimateStateType.EXTENDED);
    }

    public static boolean isNearTarget(IClimateState state, IClimateState target) {
        return target.getHumidity() - 0.01f < state.getHumidity() && target.getHumidity() + 0.01f > state.getHumidity() && target.getTemperature() - 0.01f < state.getTemperature() && target.getTemperature() + 0.01f > state.getTemperature();
    }

    public static boolean isZero(IClimateState state) {
        return state.getHumidity() == ZERO.getHumidity() && state.getTemperature() == ZERO.getTemperature();
    }

    public static boolean isNearZero(IClimateState state) {
        return ClimateStates.isNearTarget(state, ZERO);
    }

    @Override
    public IClimateState create(IClimateState climateState, ClimateStateType type) {
        ClimateState state = new ClimateState(climateState, type);
        if (!state.isPresent()) {
            return this.absent();
        }
        return state;
    }

    @Override
    public IClimateState create(float temperature, float humidity, ClimateStateType type) {
        ClimateState state = new ClimateState(temperature, humidity, type);
        if (!state.isPresent()) {
            return this.absent();
        }
        return state;
    }

    @Override
    public IClimateState create(NBTTagCompound compound, ClimateStateType type) {
        if (compound.func_74767_n("ABSENT")) {
            return AbsentClimateState.INSTANCE;
        }
        return new ClimateState(compound, type);
    }

    @Override
    public IClimateState create(NBTTagCompound compound) {
        if (compound.func_74767_n("ABSENT")) {
            return AbsentClimateState.INSTANCE;
        }
        return new ClimateState(compound);
    }

    @Override
    public IClimateState absent() {
        return AbsentClimateState.INSTANCE;
    }

    @Override
    public IClimateState min() {
        return ClimateState.MIN;
    }

    @Override
    public IClimateState max() {
        return ClimateState.MAX;
    }
}

