/*
 * Decompiled with CFR 0.152.
 */
package forestry.core;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import forestry.api.circuits.ChipsetManager;
import forestry.api.core.ForestryAPI;
import forestry.api.genetics.AlleleManager;
import forestry.api.modules.ForestryModule;
import forestry.api.multiblock.MultiblockManager;
import forestry.api.recipes.RecipeManagers;
import forestry.api.storage.ICrateRegistry;
import forestry.api.storage.StorageManager;
import forestry.core.IPickupHandler;
import forestry.core.ISaveEventHandler;
import forestry.core.ModuleFluids;
import forestry.core.PickupHandlerCore;
import forestry.core.SaveEventHandlerCore;
import forestry.core.blocks.BlockBogEarth;
import forestry.core.blocks.BlockRegistryCore;
import forestry.core.blocks.EnumResourceType;
import forestry.core.circuits.CircuitRegistry;
import forestry.core.circuits.SolderManager;
import forestry.core.climate.ClimateManager;
import forestry.core.commands.CommandModules;
import forestry.core.commands.RootCommand;
import forestry.core.config.Config;
import forestry.core.fluids.Fluids;
import forestry.core.genetics.alleles.AlleleFactory;
import forestry.core.genetics.alleles.AlleleHelper;
import forestry.core.genetics.alleles.AlleleRegistry;
import forestry.core.items.EnumContainerType;
import forestry.core.items.ItemRegistryCore;
import forestry.core.items.ItemRegistryFluids;
import forestry.core.loot.SetSpeciesNBT;
import forestry.core.models.ModelManager;
import forestry.core.multiblock.MultiblockLogicFactory;
import forestry.core.network.IPacketRegistry;
import forestry.core.network.PacketRegistryCore;
import forestry.core.owner.GameProfileDataSerializer;
import forestry.core.proxy.Proxies;
import forestry.core.recipes.RecipeUtil;
import forestry.core.render.TextureManagerForestry;
import forestry.core.utils.ClimateUtil;
import forestry.core.utils.ForestryModEnvWarningCallable;
import forestry.core.utils.World2ObjectMap;
import forestry.modules.BlankForestryModule;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

@ForestryModule(containerID="forestry", moduleID="core", name="Core", author="SirSengir", url="http://forestry.sengir.net/", unlocalizedDescription="for.module.core.description", coreModule=true)
public class ModuleCore
extends BlankForestryModule {
    public static final RootCommand rootCommand = new RootCommand();
    @Nullable
    public static ItemRegistryCore items;
    @Nullable
    private static BlockRegistryCore blocks;

    public static ItemRegistryCore getItems() {
        Preconditions.checkState((items != null ? 1 : 0) != 0);
        return items;
    }

    public static BlockRegistryCore getBlocks() {
        Preconditions.checkState((blocks != null ? 1 : 0) != 0);
        return blocks;
    }

    @Override
    public boolean canBeDisabled() {
        return false;
    }

    @Override
    public Set<ResourceLocation> getDependencyUids() {
        return Collections.emptySet();
    }

    @Override
    public void setupAPI() {
        ChipsetManager.solderManager = new SolderManager();
        ChipsetManager.circuitRegistry = new CircuitRegistry();
        AlleleRegistry alleleRegistry = new AlleleRegistry();
        AlleleManager.alleleRegistry = alleleRegistry;
        AlleleManager.climateHelper = new ClimateUtil();
        AlleleManager.alleleFactory = new AlleleFactory();
        alleleRegistry.initialize();
        LootFunctionManager.func_186582_a((LootFunction.Serializer)new SetSpeciesNBT.Serializer());
        MultiblockManager.logicFactory = new MultiblockLogicFactory();
        ForestryAPI.climateManager = ClimateManager.getInstance();
    }

    @Override
    public void registerItemsAndBlocks() {
        items = new ItemRegistryCore();
        blocks = new BlockRegistryCore();
    }

    @Override
    public void preInit() {
        GameProfileDataSerializer.register();
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register(World2ObjectMap.class);
        rootCommand.addChildCommand(new CommandModules());
    }

    @Override
    public void doInit() {
        AlleleHelper alleleHelper = AlleleHelper.getInstance();
        BlockRegistryCore blocks = ModuleCore.getBlocks();
        blocks.analyzer.init();
        blocks.escritoire.init();
        ForestryModEnvWarningCallable.register();
        alleleHelper.init();
        Proxies.render.initRendering();
    }

    @Override
    public ISaveEventHandler getSaveEventHandler() {
        return new SaveEventHandlerCore();
    }

    @Override
    public void registerCrates() {
        ICrateRegistry crateRegistry = StorageManager.crateRegistry;
        ItemRegistryCore items = ModuleCore.getItems();
        crateRegistry.registerCrate(items.peat);
        crateRegistry.registerCrate(items.apatite);
        crateRegistry.registerCrate(items.fertilizerCompound);
        crateRegistry.registerCrate(items.mulch);
        crateRegistry.registerCrate(items.phosphor);
        crateRegistry.registerCrate(items.ash);
        crateRegistry.registerCrate("ingotTin");
        crateRegistry.registerCrate("ingotCopper");
        crateRegistry.registerCrate("ingotBronze");
        BlockRegistryCore blocks = ModuleCore.getBlocks();
        crateRegistry.registerCrate(blocks.humus);
        crateRegistry.registerCrate(blocks.bogEarth.get(BlockBogEarth.SoilType.BOG_EARTH, 1));
        crateRegistry.registerCrate("cropWheat");
        crateRegistry.registerCrate(Items.field_151106_aX);
        crateRegistry.registerCrate("dustRedstone");
        crateRegistry.registerCrate(new ItemStack(Items.field_151100_aR, 1, 4));
        crateRegistry.registerCrate("sugarcane");
        crateRegistry.registerCrate(Items.field_151119_aD);
        crateRegistry.registerCrate("dustGlowstone");
        crateRegistry.registerCrate(Items.field_151034_e);
        crateRegistry.registerCrate(new ItemStack(Items.field_151075_bm));
        crateRegistry.registerCrate(new ItemStack(Items.field_151044_h, 1, 1));
        crateRegistry.registerCrate(new ItemStack(Items.field_151044_h, 1, 0));
        crateRegistry.registerCrate(Items.field_151014_N);
        crateRegistry.registerCrate("cropPotato");
        crateRegistry.registerCrate("cropCarrot");
        crateRegistry.registerCrate(new ItemStack(Blocks.field_150364_r, 1, 0));
        crateRegistry.registerCrate(new ItemStack(Blocks.field_150364_r, 1, 1));
        crateRegistry.registerCrate(new ItemStack(Blocks.field_150364_r, 1, 2));
        crateRegistry.registerCrate(new ItemStack(Blocks.field_150364_r, 1, 3));
        crateRegistry.registerCrate(new ItemStack(Blocks.field_150363_s, 1, 0));
        crateRegistry.registerCrate(new ItemStack(Blocks.field_150363_s, 1, 1));
        crateRegistry.registerCrate("cobblestone");
        crateRegistry.registerCrate("dirt");
        crateRegistry.registerCrate(new ItemStack(Blocks.field_150346_d, 1, 2));
        crateRegistry.registerCrate("stone");
        crateRegistry.registerCrate("stoneGranite");
        crateRegistry.registerCrate("stoneDiorite");
        crateRegistry.registerCrate("stoneAndesite");
        crateRegistry.registerCrate("blockPrismarine");
        crateRegistry.registerCrate("blockPrismarineBrick");
        crateRegistry.registerCrate("blockPrismarineDark");
        crateRegistry.registerCrate(Blocks.field_150336_V);
        crateRegistry.registerCrate("blockCactus");
        crateRegistry.registerCrate(new ItemStack((Block)Blocks.field_150354_m, 1, 0));
        crateRegistry.registerCrate(new ItemStack((Block)Blocks.field_150354_m, 1, 1));
        crateRegistry.registerCrate("obsidian");
        crateRegistry.registerCrate("netherrack");
        crateRegistry.registerCrate(Blocks.field_150425_aM);
        crateRegistry.registerCrate(Blocks.field_150322_A);
        crateRegistry.registerCrate(Blocks.field_150385_bj);
        crateRegistry.registerCrate((Block)Blocks.field_150391_bh);
        crateRegistry.registerCrate("gravel");
        crateRegistry.registerCrate(new ItemStack(Blocks.field_150345_g, 1, 0));
        crateRegistry.registerCrate(new ItemStack(Blocks.field_150345_g, 1, 1));
        crateRegistry.registerCrate(new ItemStack(Blocks.field_150345_g, 1, 2));
        crateRegistry.registerCrate(new ItemStack(Blocks.field_150345_g, 1, 3));
        crateRegistry.registerCrate(new ItemStack(Blocks.field_150345_g, 1, 4));
        crateRegistry.registerCrate(new ItemStack(Blocks.field_150345_g, 1, 5));
    }

    @Override
    public void registerRecipes() {
        int bogEarthOutputCan;
        int bogEarthOutputBucket;
        int humusFertilizerAmount;
        int humusCompostAmount;
        int fertilizerAshAmount;
        int fertilizerApatiteAmount;
        int compostAshAmount;
        BlockRegistryCore blocks = ModuleCore.getBlocks();
        ItemRegistryCore items = ModuleCore.getItems();
        ItemRegistryFluids fluidItems = ModuleFluids.getItems();
        RecipeUtil.addSmelting(blocks.resources.get(EnumResourceType.APATITE, 1), items.apatite, 0.5f);
        RecipeUtil.addSmelting(blocks.resources.get(EnumResourceType.COPPER, 1), items.ingotCopper, 0.5f);
        RecipeUtil.addSmelting(blocks.resources.get(EnumResourceType.TIN, 1), items.ingotTin, 0.5f);
        RecipeUtil.addSmelting(new ItemStack((Item)items.peat), items.ash, 0.0f);
        if (Config.isCraftingBronzeEnabled()) {
            ItemStack ingotBronze = items.ingotBronze.func_77946_l();
            ingotBronze.func_190920_e(4);
            RecipeUtil.addShapelessRecipe("bronze_ingot", ingotBronze, "ingotTin", "ingotCopper", "ingotCopper", "ingotCopper");
        }
        RecipeUtil.addRecipe("sturdy_casing", items.sturdyCasing, "###", "# #", "###", Character.valueOf('#'), "ingotBronze");
        int canAmount = ForestryAPI.activeMode.getIntegerSetting("recipe.output.can");
        ItemStack canOutput = fluidItems.canEmpty.getItemStack(canAmount);
        RecipeUtil.addRecipe("tin_can", canOutput, " # ", "# #", Character.valueOf('#'), "ingotTin");
        NonNullList stoneGear = OreDictionary.getOres((String)"gearStone");
        String gearCenter = !stoneGear.isEmpty() ? "gearStone" : "ingotCopper";
        RecipeUtil.addRecipe("gear_bronze", items.gearBronze, " # ", "#X#", " # ", Character.valueOf('#'), "ingotBronze", Character.valueOf('X'), gearCenter);
        RecipeUtil.addRecipe("gear_copper", items.gearCopper, " # ", "#X#", " # ", Character.valueOf('#'), "ingotCopper", Character.valueOf('X'), gearCenter);
        RecipeUtil.addRecipe("gear_tin", items.gearTin, " # ", "#X#", " # ", Character.valueOf('#'), "ingotTin", Character.valueOf('X'), gearCenter);
        RecipeUtil.addRecipe("bronze_pickaxe", items.bronzePickaxe, " X ", " X ", "###", Character.valueOf('#'), "ingotBronze", Character.valueOf('X'), "stickWood");
        RecipeUtil.addRecipe("bronze_shovel", items.bronzeShovel, " X ", " X ", " # ", Character.valueOf('#'), "ingotBronze", Character.valueOf('X'), "stickWood");
        RecipeUtil.addShapelessRecipe("pickaxe_kit", items.kitPickaxe, items.bronzePickaxe, items.carton);
        RecipeUtil.addShapelessRecipe("shovel_kit", items.kitShovel, items.bronzeShovel, items.carton);
        RecipeUtil.addRecipe("spectacles", (Item)items.spectacles, " X ", "Y Y", Character.valueOf('X'), "ingotBronze", Character.valueOf('Y'), "paneGlass");
        RecipeUtil.addRecipe("wrench", items.wrench, "# #", " # ", " # ", Character.valueOf('#'), "ingotBronze");
        RecipeUtil.addRecipe("silk_wisp_to_web", new ItemStack(Blocks.field_150321_G, 4), "# #", " # ", "# #", Character.valueOf('#'), items.craftingMaterial.getSilkWisp());
        if (ForestryAPI.enabledModules.contains(new ResourceLocation("forestry", "factory"))) {
            RecipeManagers.carpenterManager.addRecipe(100, new FluidStack(FluidRegistry.WATER, 2000), ItemStack.field_190927_a, items.portableAlyzer.getItemStack(), "X#X", "X#X", "RDR", Character.valueOf('#'), "paneGlass", Character.valueOf('X'), "ingotTin", Character.valueOf('R'), "dustRedstone", Character.valueOf('D'), "gemDiamond");
            RecipeManagers.carpenterManager.addRecipe(50, Fluids.BIOMASS.getFluid(500), ItemStack.field_190927_a, items.craftingMaterial.getCamouflagedPaneling(8), "Y#R", "BPB", "R#Y", Character.valueOf('#'), "plankWood", Character.valueOf('R'), "dustRedstone", Character.valueOf('P'), "pulpWood", Character.valueOf('R'), "dyeRed", Character.valueOf('B'), "dyeBlue", Character.valueOf('Y'), "dyeYellow");
        } else {
            RecipeUtil.addRecipe("portable_alyzer", items.portableAlyzer.getItemStack(), "X#X", "X#X", "RDR", Character.valueOf('#'), "paneGlass", Character.valueOf('X'), "ingotTin", Character.valueOf('R'), "dustRedstone", Character.valueOf('D'), "gemDiamond");
            RecipeUtil.addRecipe("camoflaged_paneling", items.craftingMaterial.getCamouflagedPaneling(8), "WWW", "YBR", "WWW", Character.valueOf('W'), "plankWood", Character.valueOf('Y'), "dyeYellow", Character.valueOf('B'), "dyeBlue", Character.valueOf('R'), "dyeRed");
        }
        RecipeUtil.addRecipe("alyzer", blocks.analyzer, "XTX", " Y ", "X X", Character.valueOf('Y'), items.sturdyCasing, Character.valueOf('T'), items.portableAlyzer, Character.valueOf('X'), "ingotBronze");
        int compostWheatAmount = ForestryAPI.activeMode.getIntegerSetting("recipe.output.compost.wheat");
        if (compostWheatAmount > 0) {
            ItemStack compost = items.compost.getItemStack(compostWheatAmount);
            RecipeUtil.addRecipe("wheat_to_compost", compost, " X ", "X#X", " X ", Character.valueOf('#'), Blocks.field_150346_d, Character.valueOf('X'), "cropWheat");
        }
        if ((compostAshAmount = ForestryAPI.activeMode.getIntegerSetting("recipe.output.compost.ash")) > 0) {
            ItemStack compost = items.compost.getItemStack(compostAshAmount);
            RecipeUtil.addRecipe("ash_to_compost", compost, " X ", "X#X", " X ", Character.valueOf('#'), Blocks.field_150346_d, Character.valueOf('X'), "dustAsh");
        }
        if ((fertilizerApatiteAmount = ForestryAPI.activeMode.getIntegerSetting("recipe.output.fertilizer.apatite")) > 0) {
            ItemStack fertilizer = items.fertilizerCompound.getItemStack(fertilizerApatiteAmount);
            RecipeUtil.addRecipe("sand_to_fertilizer", fertilizer, " # ", " X ", " # ", Character.valueOf('#'), "sand", Character.valueOf('X'), "gemApatite");
        }
        if ((fertilizerAshAmount = ForestryAPI.activeMode.getIntegerSetting("recipe.output.fertilizer.ash")) > 0) {
            ItemStack fertilizer = items.fertilizerCompound.getItemStack(fertilizerAshAmount);
            RecipeUtil.addRecipe("ash_to_fertilizer", fertilizer, "###", "#X#", "###", Character.valueOf('#'), "dustAsh", Character.valueOf('X'), "gemApatite");
        }
        if ((humusCompostAmount = ForestryAPI.activeMode.getIntegerSetting("recipe.output.humus.compost")) > 0) {
            ItemStack humus = new ItemStack((Block)blocks.humus, humusCompostAmount);
            RecipeUtil.addRecipe("compost_humus", humus, "###", "#X#", "###", Character.valueOf('#'), Blocks.field_150346_d, Character.valueOf('X'), items.compost);
        }
        if ((humusFertilizerAmount = ForestryAPI.activeMode.getIntegerSetting("recipe.output.humus.fertilizer")) > 0) {
            ItemStack humus = new ItemStack((Block)blocks.humus, humusFertilizerAmount);
            RecipeUtil.addRecipe("fertilizer_humus", humus, "###", "#X#", "###", Character.valueOf('#'), Blocks.field_150346_d, Character.valueOf('X'), items.fertilizerCompound);
        }
        if ((bogEarthOutputBucket = ForestryAPI.activeMode.getIntegerSetting("recipe.output.bogearth.bucket")) > 0) {
            ItemStack bogEarth = blocks.bogEarth.get(BlockBogEarth.SoilType.BOG_EARTH, bogEarthOutputBucket);
            RecipeUtil.addRecipe("bucket_bog_earth", bogEarth, "#Y#", "YXY", "#Y#", Character.valueOf('#'), Blocks.field_150346_d, Character.valueOf('X'), Items.field_151131_as, Character.valueOf('Y'), "sand");
        }
        if ((bogEarthOutputCan = ForestryAPI.activeMode.getIntegerSetting("recipe.output.bogearth.can")) > 0) {
            ItemStack bogEarth = blocks.bogEarth.get(BlockBogEarth.SoilType.BOG_EARTH, bogEarthOutputCan);
            ItemStack canWater = fluidItems.getContainer(EnumContainerType.CAN, FluidRegistry.WATER);
            ItemStack waxCapsuleWater = fluidItems.getContainer(EnumContainerType.CAPSULE, FluidRegistry.WATER);
            ItemStack refractoryWater = fluidItems.getContainer(EnumContainerType.REFRACTORY, FluidRegistry.WATER);
            RecipeUtil.addRecipe("can_bog_earth", bogEarth, "#Y#", "YXY", "#Y#", Character.valueOf('#'), Blocks.field_150346_d, Character.valueOf('X'), canWater, Character.valueOf('Y'), "sand");
            RecipeUtil.addRecipe("capsule_bog_earth", bogEarth, "#Y#", "YXY", "#Y#", Character.valueOf('#'), Blocks.field_150346_d, Character.valueOf('X'), waxCapsuleWater, Character.valueOf('Y'), "sand");
            RecipeUtil.addRecipe("refractory_capsule_bog_earth", bogEarth, "#Y#", "YXY", "#Y#", Character.valueOf('#'), Blocks.field_150346_d, Character.valueOf('X'), refractoryWater, Character.valueOf('Y'), "sand");
        }
        RecipeUtil.addRecipe("silk_to_string", new ItemStack(Items.field_151007_F), "#", "#", "#", Character.valueOf('#'), items.craftingMaterial.getSilkWisp());
        RecipeUtil.addRecipe("pipette", items.pipette, "  #", " X ", "X  ", Character.valueOf('X'), "paneGlass", Character.valueOf('#'), new ItemStack(Blocks.field_150325_L, 1, Short.MAX_VALUE));
        RecipeUtil.addRecipe("apatite_block", blocks.resourceStorageApatite, "###", "###", "###", Character.valueOf('#'), "gemApatite");
        RecipeUtil.addShapelessRecipe("block_to_apatite", new ItemStack((Item)items.apatite, 9), "blockApatite");
        RecipeUtil.addRecipe("copper_block", blocks.resourceStorageCopper, "###", "###", "###", Character.valueOf('#'), "ingotCopper");
        ItemStack ingotCopper = items.ingotCopper.func_77946_l();
        ingotCopper.func_190920_e(9);
        RecipeUtil.addShapelessRecipe("block_to_copper", ingotCopper, "blockCopper");
        RecipeUtil.addRecipe("tin_block", blocks.resourceStorageTin, "###", "###", "###", Character.valueOf('#'), "ingotTin");
        ItemStack ingotTin = items.ingotTin.func_77946_l();
        ingotTin.func_190920_e(9);
        RecipeUtil.addShapelessRecipe("block_to_tin", ingotTin, "blockTin");
        RecipeUtil.addRecipe("bronze_block", blocks.resourceStorageBronze, "###", "###", "###", Character.valueOf('#'), "ingotBronze");
        ItemStack ingotBronze = items.ingotBronze.func_77946_l();
        ingotBronze.func_190920_e(9);
        RecipeUtil.addShapelessRecipe("block_to_bronze", ingotBronze, "blockBronze");
        if (!ForestryAPI.enabledModules.contains(new ResourceLocation("forestry", "arboriculture"))) {
            RecipeUtil.addSmelting(new ItemStack((Item)items.ash, 2), new ItemStack(Items.field_151044_h, 1, 1), 0.15f);
        }
        RecipeUtil.addRecipe("ash_brick", blocks.ashBrick, "A#A", "# #", "A#A", Character.valueOf('#'), Items.field_151118_aC, Character.valueOf('A'), "dustAsh");
        RecipeUtil.addRecipe("ash_stairs", (Block)blocks.ashStairs, true, "#  ", "## ", "###", Character.valueOf('#'), Items.field_151118_aC);
        if (!ForestryAPI.enabledModules.contains(new ResourceLocation("forestry", "apiculture"))) {
            RecipeManagers.centrifugeManager.addRecipe(5, new ItemStack(Items.field_151007_F), (Map<ItemStack, Float>)ImmutableMap.of((Object)items.craftingMaterial.getSilkWisp(), (Object)Float.valueOf(0.15f)));
        }
    }

    @Override
    public IPacketRegistry getPacketRegistry() {
        return new PacketRegistryCore();
    }

    @Override
    public boolean processIMCMessage(FMLInterModComms.IMCMessage message) {
        if (message.key.equals("blacklist-ores-dimension")) {
            int[] dims;
            for (int dim : dims = message.getNBTValue().func_74759_k("dimensions")) {
                Config.blacklistOreDim(dim);
            }
            return true;
        }
        return false;
    }

    @Override
    public IPickupHandler getPickupHandler() {
        return new PickupHandlerCore();
    }

    @Override
    public ICommand[] getConsoleCommands() {
        return new ICommand[]{rootCommand};
    }

    @Override
    public void getHiddenItems(List<ItemStack> hiddenItems) {
        hiddenItems.add(new ItemStack((Item)ModuleCore.getItems().researchNote));
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onBakeModels(ModelBakeEvent event) {
        ModelManager.getInstance().onBakeModels(event);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void registerSprites(TextureStitchEvent.Pre event) {
        TextureManagerForestry.getInstance().registerSprites();
    }
}

