/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.genetics;

import forestry.api.arboriculture.ITreeGenome;
import forestry.api.arboriculture.ITreekeepingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;

public class TreekeepingMode
implements ITreekeepingMode {
    public static final ITreekeepingMode easy = new TreekeepingMode("EASY", 1.4f, 1.3f, 1.2f, 1.2f);
    public static final ITreekeepingMode normal = new TreekeepingMode("NORMAL", 1.0f, 1.0f, 1.0f, 1.0f);
    public static final ITreekeepingMode hard = new TreekeepingMode("HARD", 0.9f, 0.9f, 0.9f, 0.9f);
    public static final ITreekeepingMode hardcore = new TreekeepingMode("HARDCORE", 0.7f, 0.7f, 0.5f, 0.5f);
    public static final ITreekeepingMode insane = new TreekeepingMode("INSANE", 0.5f, 0.5f, 0.2f, 0.1f);
    private final String name;
    private final float yieldModifier;
    private final float sappinessModifier;
    private final float maturationModifier;
    private final float mutationModifier;

    public TreekeepingMode(String name, float yieldModifier, float sappinessModifier, float maturationModifier, float mutationModifier) {
        this.name = name;
        this.yieldModifier = yieldModifier;
        this.sappinessModifier = sappinessModifier;
        this.maturationModifier = maturationModifier;
        this.mutationModifier = mutationModifier;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> getDescription() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add("treemode." + this.name.toLowerCase(Locale.ENGLISH) + ".desc");
        return ret;
    }

    @Override
    public float getHeightModifier(ITreeGenome genome, float currentModifier) {
        return 1.0f;
    }

    @Override
    public float getYieldModifier(@Nullable ITreeGenome genome, float currentModifier) {
        return this.yieldModifier;
    }

    @Override
    public float getSappinessModifier(ITreeGenome genome, float currentModifier) {
        return this.sappinessModifier;
    }

    @Override
    public float getMaturationModifier(ITreeGenome genome, float currentModifier) {
        return this.maturationModifier;
    }

    @Override
    public float getMutationModifier(ITreeGenome genome, ITreeGenome mate, float currentModifier) {
        return this.mutationModifier;
    }
}

