/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.network.packets;

import forestry.apiculture.tiles.TileCandle;
import forestry.core.network.ForestryPacket;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.IForestryPacketHandlerClient;
import forestry.core.network.PacketBufferForestry;
import forestry.core.network.PacketIdClient;
import forestry.core.tiles.TileUtil;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketCandleUpdate
extends ForestryPacket
implements IForestryPacketClient {
    private final BlockPos pos;
    private final int colour;
    private final boolean lit;

    public PacketCandleUpdate(TileCandle tileCandle) {
        this.pos = tileCandle.func_174877_v();
        this.colour = tileCandle.getColour();
        this.lit = tileCandle.isLit();
    }

    @Override
    public PacketIdClient getPacketId() {
        return PacketIdClient.CANDLE_UPDATE;
    }

    @Override
    protected void writeData(PacketBufferForestry data) throws IOException {
        data.func_179255_a(this.pos);
        data.writeInt(this.colour);
        data.writeBoolean(this.lit);
    }

    @SideOnly(value=Side.CLIENT)
    public static class Handler
    implements IForestryPacketHandlerClient {
        @Override
        public void onPacketData(PacketBufferForestry data, EntityPlayer player) throws IOException {
            BlockPos pos = data.func_179259_c();
            int colour = data.readInt();
            boolean lit = data.readBoolean();
            TileUtil.actOnTile((IBlockAccess)player.field_70170_p, pos, TileCandle.class, tile -> tile.onPacketUpdate(colour, lit));
        }
    }
}

