/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.client;

import blusunrize.immersiveengineering.api.ManualHelper;
import blusunrize.immersiveengineering.api.ManualPageMultiblock;
import blusunrize.immersiveengineering.api.MultiblockHandler;
import blusunrize.immersiveengineering.client.IECustomStateMapper;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.lib.manual.IManualPage;
import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.ManualPages;
import flaxbeard.immersivepetroleum.api.crafting.DistillationRecipe;
import flaxbeard.immersivepetroleum.api.crafting.PumpjackHandler;
import flaxbeard.immersivepetroleum.client.ShaderUtil;
import flaxbeard.immersivepetroleum.client.model.ModelCoresampleExtended;
import flaxbeard.immersivepetroleum.client.page.ManualPageBigMultiblock;
import flaxbeard.immersivepetroleum.client.page.ManualPageSchematicCrafting;
import flaxbeard.immersivepetroleum.client.render.MultiblockDistillationTowerRenderer;
import flaxbeard.immersivepetroleum.client.render.MultiblockPumpjackRenderer;
import flaxbeard.immersivepetroleum.client.render.RenderSpeedboat;
import flaxbeard.immersivepetroleum.client.render.TileAutoLubricatorRenderer;
import flaxbeard.immersivepetroleum.common.CommonProxy;
import flaxbeard.immersivepetroleum.common.IPContent;
import flaxbeard.immersivepetroleum.common.blocks.BlockIPFluid;
import flaxbeard.immersivepetroleum.common.blocks.metal.TileEntityAutoLubricator;
import flaxbeard.immersivepetroleum.common.blocks.metal.TileEntityDistillationTower;
import flaxbeard.immersivepetroleum.common.blocks.metal.TileEntityPumpjack;
import flaxbeard.immersivepetroleum.common.blocks.multiblocks.MultiblockDistillationTower;
import flaxbeard.immersivepetroleum.common.blocks.multiblocks.MultiblockPumpjack;
import flaxbeard.immersivepetroleum.common.blocks.stone.BlockTypes_IPStoneDecoration;
import flaxbeard.immersivepetroleum.common.entity.EntitySpeedboat;
import flaxbeard.immersivepetroleum.common.items.ItemIPBase;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="immersivepetroleum")
public class ClientProxy
extends CommonProxy {
    public static final String CAT_IP = "ip";
    static ManualInstance.ManualEntry resEntry;

    @Override
    public void preInit() {
        RenderingRegistry.registerEntityRenderingHandler(EntitySpeedboat.class, RenderSpeedboat::new);
    }

    @Override
    public void preInitEnd() {
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent evt) {
        for (Block block : IPContent.registeredIPBlocks) {
            Item blockItem = Item.func_150898_a((Block)block);
            final ResourceLocation loc = (ResourceLocation)Block.field_149771_c.func_177774_c((Object)block);
            if (loc == null) continue;
            if (block instanceof IEBlockInterfaces.IIEMetaBlock) {
                int meta;
                IEBlockInterfaces.IIEMetaBlock ieMetaBlock = (IEBlockInterfaces.IIEMetaBlock)block;
                if (ieMetaBlock.useCustomStateMapper()) {
                    ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)IECustomStateMapper.getStateMapper((IEBlockInterfaces.IIEMetaBlock)ieMetaBlock));
                }
                ModelLoader.setCustomMeshDefinition((Item)blockItem, (ItemMeshDefinition)new ItemMeshDefinition(){

                    public ModelResourceLocation func_178113_a(ItemStack stack) {
                        return new ModelResourceLocation(loc, "inventory");
                    }
                });
                boolean isMD = block == IPContent.blockMetalDevice;
                int n = meta = isMD ? 1 : 0;
                while (meta < ieMetaBlock.getMetaEnums().length) {
                    String custom;
                    String prop;
                    String location = loc.toString();
                    String string = prop = ieMetaBlock.appendPropertiesToState() ? "inventory," + ieMetaBlock.getMetaProperty().func_177701_a() + "=" + ieMetaBlock.getMetaEnums()[meta].toString().toLowerCase(Locale.US) : null;
                    if (ieMetaBlock.useCustomStateMapper() && (custom = ieMetaBlock.getCustomStateMapping(meta, true)) != null) {
                        location = location + "_" + custom;
                    }
                    try {
                        ModelLoader.setCustomModelResourceLocation((Item)blockItem, (int)meta, (ModelResourceLocation)new ModelResourceLocation(location, prop));
                    }
                    catch (NullPointerException npe) {
                        throw new RuntimeException("WELP! apparently " + ieMetaBlock + " lacks an item!", npe);
                    }
                    ++meta;
                }
                if (!isMD) continue;
                ModelLoader.setCustomModelResourceLocation((Item)blockItem, (int)0, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("immersivepetroleum", "auto_lube"), "inventory"));
                continue;
            }
            if (block instanceof BlockIPFluid) {
                ClientProxy.mapFluidState(block, ((BlockIPFluid)block).getFluid());
                continue;
            }
            ModelLoader.setCustomModelResourceLocation((Item)blockItem, (int)0, (ModelResourceLocation)new ModelResourceLocation(loc, "inventory"));
        }
        for (Item item : IPContent.registeredIPItems) {
            if (item instanceof ItemIPBase) {
                ItemIPBase ipMetaItem = (ItemIPBase)item;
                if (ipMetaItem.registerSubModels && ipMetaItem.getSubNames() != null && ipMetaItem.getSubNames().length > 0) {
                    for (int meta = 0; meta < ipMetaItem.getSubNames().length; ++meta) {
                        ResourceLocation loc = new ResourceLocation("immersivepetroleum", ipMetaItem.itemName + "/" + ipMetaItem.getSubNames()[meta]);
                        ModelBakery.registerItemVariants((Item)ipMetaItem, (ResourceLocation[])new ResourceLocation[]{loc});
                        ModelLoader.setCustomModelResourceLocation((Item)ipMetaItem, (int)meta, (ModelResourceLocation)new ModelResourceLocation(loc, "inventory"));
                    }
                    continue;
                }
                final ResourceLocation loc = new ResourceLocation("immersivepetroleum", ipMetaItem.itemName);
                ModelBakery.registerItemVariants((Item)ipMetaItem, (ResourceLocation[])new ResourceLocation[]{loc});
                ModelLoader.setCustomMeshDefinition((Item)ipMetaItem, (ItemMeshDefinition)new ItemMeshDefinition(){

                    public ModelResourceLocation func_178113_a(ItemStack stack) {
                        return new ModelResourceLocation(loc, "inventory");
                    }
                });
                continue;
            }
            final ResourceLocation loc = (ResourceLocation)Item.field_150901_e.func_177774_c((Object)item);
            ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{loc});
            ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)new ItemMeshDefinition(){

                public ModelResourceLocation func_178113_a(ItemStack stack) {
                    return new ModelResourceLocation(loc, "inventory");
                }
            });
        }
    }

    @Override
    public void init() {
        ShaderUtil.init();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onModelBakeEvent(ModelBakeEvent event) {
        ModelResourceLocation mLoc = new ModelResourceLocation(new ResourceLocation("immersiveengineering", IEContent.itemCoresample.itemName), "inventory");
        event.getModelRegistry().func_82595_a((Object)mLoc, (Object)new ModelCoresampleExtended());
    }

    @Override
    public void postInit() {
        ManualHelper.addEntry((String)"schematics", (String)CAT_IP, (IManualPage[])new IManualPage[]{new ManualPages.Crafting(ManualHelper.getManual(), "schematics0", new Object[]{new ItemStack(IPContent.itemProjector, 1, 0)}), new ManualPageSchematicCrafting(ManualHelper.getManual(), "schematics1", new ItemStack(IPContent.itemProjector, 1, 0)), new ManualPages.Text(ManualHelper.getManual(), "schematics2")});
        ClientProxy.handleReservoirManual();
        ManualHelper.addEntry((String)"pumpjack", (String)CAT_IP, (IManualPage[])new IManualPage[]{new ManualPageMultiblock(ManualHelper.getManual(), "pumpjack0", (MultiblockHandler.IMultiblock)MultiblockPumpjack.instance), new ManualPages.Text(ManualHelper.getManual(), "pumpjack1")});
        ArrayList<DistillationRecipe> recipeList = DistillationRecipe.recipeList;
        ArrayList<String[]> l = new ArrayList<String[]>();
        for (DistillationRecipe recipe : recipeList) {
            boolean first = true;
            for (FluidStack output : recipe.fluidOutput) {
                String inputName = recipe.input.getFluid().getLocalizedName(recipe.input);
                String outputName = output.getFluid().getLocalizedName(output);
                String[] test = new String[]{first ? recipe.input.amount + " mB " + inputName : "", output.amount + " mB " + outputName};
                l.add(test);
                first = false;
            }
        }
        String[][] table = (String[][])l.toArray((T[])new String[0][]);
        ManualHelper.addEntry((String)"distillationTower", (String)CAT_IP, (IManualPage[])new IManualPage[]{new ManualPageBigMultiblock(ManualHelper.getManual(), MultiblockDistillationTower.instance), new ManualPages.Text(ManualHelper.getManual(), "distillationTower0"), new ManualPages.Text(ManualHelper.getManual(), "distillationTower1"), new ManualPages.Table(ManualHelper.getManual(), "distillationTower2", table, false)});
        ManualHelper.addEntry((String)"portableGenerator", (String)CAT_IP, (IManualPage[])new IManualPage[]{new ManualPages.Crafting(ManualHelper.getManual(), "portableGenerator0", new Object[]{new ItemStack((Block)IPContent.blockMetalDevice, 1, 1)}), new ManualPages.Text(ManualHelper.getManual(), "portableGenerator1")});
        ManualHelper.addEntry((String)"speedboat", (String)CAT_IP, (IManualPage[])new IManualPage[]{new ManualPages.Crafting(ManualHelper.getManual(), "speedboat0", new Object[]{new ItemStack(IPContent.itemSpeedboat, 1, 0)}), new ManualPages.Crafting(ManualHelper.getManual(), "speedboat1", new Object[]{new ItemStack(IPContent.itemUpgrades, 1, 2)}), new ManualPages.Crafting(ManualHelper.getManual(), "speedboat2", new Object[]{new ItemStack(IPContent.itemUpgrades, 1, 3)}), new ManualPages.Crafting(ManualHelper.getManual(), "speedboat3", new Object[]{new ItemStack(IPContent.itemUpgrades, 1, 1)}), new ManualPages.Crafting(ManualHelper.getManual(), "speedboat4", new Object[]{new ItemStack(IPContent.itemUpgrades, 1, 0)}), new ManualPages.Crafting(ManualHelper.getManual(), "speedboat5", new Object[]{new ItemStack(IPContent.itemUpgrades, 1, 4)})});
        ManualHelper.addEntry((String)"napalm", (String)CAT_IP, (IManualPage[])new IManualPage[]{new ManualPages.Text(ManualHelper.getManual(), "napalm0")});
        ManualHelper.addEntry((String)"asphalt", (String)CAT_IP, (IManualPage[])new IManualPage[]{new ManualPages.Crafting(ManualHelper.getManual(), "asphalt0", new Object[]{new ItemStack((Block)IPContent.blockStoneDecoration, 1, BlockTypes_IPStoneDecoration.ASPHALT.getMeta())})});
        ManualHelper.addEntry((String)"lubricant", (String)CAT_IP, (IManualPage[])new IManualPage[]{new ManualPages.Text(ManualHelper.getManual(), "lubricant0"), new ManualPages.Crafting(ManualHelper.getManual(), "lubricant1", new Object[]{new ItemStack(IPContent.itemOilCan)}), new ManualPages.Text(ManualHelper.getManual(), "lubricant2")});
        ManualHelper.addEntry((String)"automaticLubricator", (String)CAT_IP, (IManualPage[])new IManualPage[]{new ManualPages.Crafting(ManualHelper.getManual(), "automaticLubricator0", new Object[]{new ItemStack((Block)IPContent.blockMetalDevice, 1, 0)}), new ManualPages.Text(ManualHelper.getManual(), "automaticLubricator1")});
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityDistillationTower.TileEntityDistillationTowerParent.class, (TileEntitySpecialRenderer)new MultiblockDistillationTowerRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityPumpjack.TileEntityPumpjackParent.class, (TileEntitySpecialRenderer)new MultiblockPumpjackRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityAutoLubricator.class, (TileEntitySpecialRenderer)new TileAutoLubricatorRenderer());
        ForgeHooksClient.registerTESRItemStack((Item)Item.func_150898_a((Block)IPContent.blockMetalDevice), (int)0, TileEntityAutoLubricator.class);
    }

    private static void mapFluidState(Block block, Fluid fluid) {
        Item item = Item.func_150898_a((Block)block);
        FluidStateMapper mapper = new FluidStateMapper(fluid);
        if (item != null) {
            ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[0]);
            ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)mapper);
        }
        ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)mapper);
    }

    public static void handleReservoirManual() {
        if (ManualHelper.getManual() != null) {
            PumpjackHandler.ReservoirType[] minerals;
            ArrayList<Object> pages = new ArrayList<Object>();
            pages.add(new ManualPages.Text(ManualHelper.getManual(), "oil0"));
            pages.add(new ManualPages.Text(ManualHelper.getManual(), "oil1"));
            for (PumpjackHandler.ReservoirType type : minerals = PumpjackHandler.reservoirList.keySet().toArray(new PumpjackHandler.ReservoirType[0])) {
                String testName;
                Biome testBiome;
                String biome;
                int n;
                int dim2;
                String name = "desc.immersivepetroleum.info.reservoir." + type.name;
                String localizedName = I18n.func_135052_a((String)name, (Object[])new Object[0]);
                if (localizedName.equalsIgnoreCase(name)) {
                    localizedName = type.name;
                }
                boolean isVowel = localizedName.toLowerCase().charAt(0) == 'a' || localizedName.toLowerCase().charAt(0) == 'e' || localizedName.toLowerCase().charAt(0) == 'i' || localizedName.toLowerCase().charAt(0) == 'o' || localizedName.toLowerCase().charAt(0) == 'u';
                String aOrAn = I18n.func_135052_a((String)(isVowel ? "ie.manual.entry.oilVowel" : "ie.manual.entry.oilConsonant"), (Object[])new Object[0]);
                String s0 = "";
                if (type.dimensionWhitelist != null && type.dimensionWhitelist.length > 0) {
                    String validDims = "";
                    for (int dim2 : type.dimensionWhitelist) {
                        validDims = validDims + (!validDims.isEmpty() ? ", " : "") + "<dim;" + dim2 + ">";
                    }
                    s0 = I18n.func_135052_a((String)"ie.manual.entry.oilDimValid", (Object[])new Object[]{localizedName, validDims, aOrAn});
                } else if (type.dimensionBlacklist != null && type.dimensionBlacklist.length > 0) {
                    String invalidDims = "";
                    for (int dim3 : type.dimensionBlacklist) {
                        invalidDims = invalidDims + (!invalidDims.isEmpty() ? ", " : "") + "<dim;" + dim3 + ">";
                    }
                    s0 = I18n.func_135052_a((String)"ie.manual.entry.oilDimInvalid", (Object[])new Object[]{localizedName, invalidDims, aOrAn});
                } else {
                    s0 = I18n.func_135052_a((String)"ie.manual.entry.oilDimAny", (Object[])new Object[]{localizedName, aOrAn});
                }
                String s4 = "";
                if (type.biomeWhitelist != null && type.biomeWhitelist.length > 0) {
                    String validBiomes = "";
                    String[] stringArray = type.biomeWhitelist;
                    n = stringArray.length;
                    for (dim2 = 0; dim2 < n; ++dim2) {
                        biome = stringArray[dim2];
                        for (ResourceLocation test : Biome.field_185377_q.func_148742_b()) {
                            testBiome = (Biome)Biome.field_185377_q.func_82594_a((Object)test);
                            testName = PumpjackHandler.getBiomeName(testBiome);
                            if (testName == null || !testName.equals(biome)) continue;
                            validBiomes = validBiomes + (!validBiomes.isEmpty() ? ", " : "") + PumpjackHandler.getBiomeDisplayName(testBiome.func_185359_l());
                        }
                    }
                    s4 = I18n.func_135052_a((String)"ie.manual.entry.oilBiomeValid", (Object[])new Object[]{validBiomes});
                } else if (type.biomeBlacklist != null && type.biomeBlacklist.length > 0) {
                    String invalidBiomes = "";
                    String[] stringArray = type.biomeBlacklist;
                    n = stringArray.length;
                    for (dim2 = 0; dim2 < n; ++dim2) {
                        biome = stringArray[dim2];
                        for (ResourceLocation test : Biome.field_185377_q.func_148742_b()) {
                            testBiome = (Biome)Biome.field_185377_q.func_82594_a((Object)test);
                            testName = PumpjackHandler.getBiomeName(testBiome);
                            if (testName == null || !testName.equals(biome)) continue;
                            invalidBiomes = invalidBiomes + (!invalidBiomes.isEmpty() ? ", " : "") + PumpjackHandler.getBiomeDisplayName(testBiome.func_185359_l());
                        }
                    }
                    s4 = I18n.func_135052_a((String)"ie.manual.entry.oilBiomeInvalid", (Object[])new Object[]{invalidBiomes});
                } else {
                    s4 = I18n.func_135052_a((String)"ie.manual.entry.oilBiomeAny", (Object[])new Object[0]);
                }
                String s1 = "";
                Fluid fluid = FluidRegistry.getFluid((String)type.fluid);
                if (fluid != null) {
                    s1 = fluid.getLocalizedName(new FluidStack(fluid, 1));
                }
                DecimalFormat f = new DecimalFormat("#,###.##");
                String s3 = "";
                if (type.replenishRate > 0) {
                    s3 = I18n.func_135052_a((String)"ie.manual.entry.oilReplenish", (Object[])new Object[]{type.replenishRate, s1});
                }
                String s2 = I18n.func_135052_a((String)"ie.manual.entry.oil2", (Object[])new Object[]{s0, s1, f.format(type.minSize), f.format(type.maxSize), s3, s4});
                UniversalBucket bucket = ForgeModContainer.getInstance().universalBucket;
                ItemStack stack = new ItemStack((Item)bucket);
                FluidStack fs = new FluidStack(fluid, bucket.getCapacity());
                FluidBucketWrapper fluidHandler = new FluidBucketWrapper(stack);
                fluidHandler.fill(fs, true);
                ItemStack[] displayStacks = new ItemStack[]{fluidHandler.getContainer()};
                pages.add(new ManualPages.ItemDisplay(ManualHelper.getManual(), s2, displayStacks));
            }
            if (resEntry != null) {
                resEntry.setPages(pages.toArray(new IManualPage[pages.size()]));
            } else {
                ManualHelper.addEntry((String)"oil", (String)CAT_IP, (IManualPage[])pages.toArray(new IManualPage[pages.size()]));
                resEntry = ManualHelper.getManual().getEntry("oil");
            }
        }
    }

    @Override
    public void renderTile(TileEntity te) {
        if (te instanceof TileEntityPumpjack.TileEntityPumpjackParent) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179109_b((float)1.0f, (float)1.0f, (float)-2.0f);
            float pt = 0.0f;
            if (Minecraft.func_71410_x().field_71439_g != null) {
                ((TileEntityPumpjack.TileEntityPumpjackParent)te).activeTicks = Minecraft.func_71410_x().field_71439_g.field_70173_aa;
                pt = Minecraft.func_71410_x().func_184121_ak();
            }
            TileEntitySpecialRenderer tesr = TileEntityRendererDispatcher.field_147556_a.func_147547_b(te);
            tesr.func_192841_a(te, 0.0, 0.0, 0.0, pt, 0, 0.0f);
            GlStateManager.func_179121_F();
        } else {
            GlStateManager.func_179094_E();
            GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179109_b((float)0.0f, (float)1.0f, (float)-4.0f);
            TileEntitySpecialRenderer tesr = TileEntityRendererDispatcher.field_147556_a.func_147547_b(te);
            tesr.func_192841_a(te, 0.0, 0.0, 0.0, 0.0f, 0, 0.0f);
            GlStateManager.func_179121_F();
        }
    }

    @Override
    public void drawUpperHalfSlab(ItemStack stack) {
        BlockRendererDispatcher blockRenderer = Minecraft.func_71410_x().func_175602_ab();
        IBlockState state = IEContent.blockMetalDecorationSlabs1.func_176203_a(stack.func_77960_j());
        IBakedModel model = blockRenderer.func_175023_a().func_178125_b(state);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.5f, (float)1.0f);
        RenderHelper.func_74518_a();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179147_l();
        GlStateManager.func_179129_p();
        if (Minecraft.func_71379_u()) {
            GlStateManager.func_179103_j((int)7425);
        } else {
            GlStateManager.func_179103_j((int)7424);
        }
        blockRenderer.func_175019_b().func_178266_a(model, state, 0.75f, false);
        GlStateManager.func_179121_F();
    }

    static class FluidStateMapper
    extends StateMapperBase
    implements ItemMeshDefinition {
        public final ModelResourceLocation location;

        public FluidStateMapper(Fluid fluid) {
            this.location = new ModelResourceLocation("immersivepetroleum:fluid_block", fluid.getName());
        }

        @Nonnull
        protected ModelResourceLocation func_178132_a(@Nonnull IBlockState state) {
            return this.location;
        }

        @Nonnull
        public ModelResourceLocation func_178113_a(@Nonnull ItemStack stack) {
            return this.location;
        }
    }
}

