/*
 * Decompiled with CFR 0.152.
 */
package com.kamildanak.minecraft.foamflower.gui.elements;

import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemTransformVec3f;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiRenderItem
implements IResourceManagerReloadListener {
    private static final ResourceLocation RES_ITEM_GLINT = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    private final ItemModelMesher itemModelMesher;
    private final TextureManager textureManager;
    private final ItemColors itemColors;
    public float zLevel;
    private boolean notRenderingEffectsInGUI = true;

    public GuiRenderItem(TextureManager p_i46552_1_, ItemModelMesher itemModelMesher, ItemColors p_i46552_3_) {
        this.textureManager = p_i46552_1_;
        this.itemModelMesher = itemModelMesher;
        this.itemColors = p_i46552_3_;
    }

    public void isNotRenderingEffectsInGUI(boolean isNot) {
        this.notRenderingEffectsInGUI = isNot;
    }

    public ItemModelMesher getItemModelMesher() {
        return this.itemModelMesher;
    }

    private void renderModel(IBakedModel model, ItemStack stack) {
        this.renderModel(model, -1, stack);
    }

    private void renderModel(IBakedModel model, int color) {
        this.renderModel(model, color, ItemStack.field_190927_a);
    }

    private void renderModel(IBakedModel model, int color, ItemStack stack) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        for (EnumFacing enumfacing : EnumFacing.values()) {
            this.renderQuads(bufferbuilder, model.func_188616_a(null, enumfacing, 0L), color, stack);
        }
        this.renderQuads(bufferbuilder, model.func_188616_a(null, null, 0L), color, stack);
        tessellator.func_78381_a();
    }

    public void renderItem(@Nonnull ItemStack stack, IBakedModel model) {
        if (!stack.func_190926_b()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
            if (model.func_188618_c()) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179091_B();
                TileEntityItemStackRenderer.field_147719_a.func_179022_a(stack);
            } else {
                this.renderModel(model, stack);
                if (stack.func_77962_s()) {
                    this.renderEffect(model);
                }
            }
            GlStateManager.func_179121_F();
        }
    }

    private void renderEffect(IBakedModel model) {
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179143_c((int)514);
        GlStateManager.func_179140_f();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        this.textureManager.func_110577_a(RES_ITEM_GLINT);
        GlStateManager.func_179128_n((int)5890);
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)8.0f, (float)8.0f, (float)8.0f);
        float f = (float)(Minecraft.func_71386_F() % 3000L) / 3000.0f / 8.0f;
        GlStateManager.func_179109_b((float)f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.renderModel(model, -8372020);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)8.0f, (float)8.0f, (float)8.0f);
        float f1 = (float)(Minecraft.func_71386_F() % 4873L) / 4873.0f / 8.0f;
        GlStateManager.func_179109_b((float)(-f1), (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.renderModel(model, -8372020);
        GlStateManager.func_179121_F();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179145_e();
        GlStateManager.func_179143_c((int)515);
        GlStateManager.func_179132_a((boolean)true);
        this.textureManager.func_110577_a(TextureMap.field_110575_b);
    }

    private void putQuadNormal(BufferBuilder renderer, BakedQuad quad) {
        Vec3i vec3i = quad.func_178210_d().func_176730_m();
        renderer.func_178975_e((float)vec3i.func_177958_n(), (float)vec3i.func_177956_o(), (float)vec3i.func_177952_p());
    }

    private void renderQuad(BufferBuilder renderer, BakedQuad quad, int color) {
        renderer.func_178981_a(quad.func_178209_a());
        renderer.func_178968_d(color);
        this.putQuadNormal(renderer, quad);
    }

    private void renderQuads(BufferBuilder renderer, List<BakedQuad> quads, int color, @Nonnull ItemStack stack) {
        boolean flag = color == -1 && !stack.func_190926_b();
        int j = quads.size();
        for (int i = 0; i < j; ++i) {
            BakedQuad bakedquad = quads.get(i);
            int k = color;
            if (flag && bakedquad.func_178212_b()) {
                k = this.itemColors.func_186728_a(stack, bakedquad.func_178211_c());
                if (EntityRenderer.field_78517_a) {
                    k = TextureUtil.func_177054_c((int)k);
                }
                k |= 0xFF000000;
            }
            LightUtil.renderQuadColor((BufferBuilder)renderer, (BakedQuad)bakedquad, (int)k);
        }
    }

    public boolean shouldRenderItemIn3D(@Nonnull ItemStack stack) {
        IBakedModel ibakedmodel = this.itemModelMesher.func_178089_a(stack);
        return !stack.func_190926_b() && ibakedmodel.func_177556_c();
    }

    public void renderItem(ItemStack stack, ItemCameraTransforms.TransformType cameraTransformType) {
        if (!stack.func_190926_b()) {
            IBakedModel ibakedmodel = this.getItemModelWithOverrides(stack, null, null);
            this.renderItemModel(stack, ibakedmodel, cameraTransformType, false);
        }
    }

    public IBakedModel getItemModelWithOverrides(ItemStack p_184393_1_, World p_184393_2_, EntityLivingBase p_184393_3_) {
        IBakedModel ibakedmodel = this.itemModelMesher.func_178089_a(p_184393_1_);
        return ibakedmodel.func_188617_f().handleItemState(ibakedmodel, p_184393_1_, p_184393_2_, p_184393_3_);
    }

    public void renderItem(ItemStack p_184392_1_, EntityLivingBase p_184392_2_, ItemCameraTransforms.TransformType p_184392_3_, boolean p_184392_4_) {
        if (p_184392_1_ != null && p_184392_2_ != null && !p_184392_1_.func_190926_b()) {
            IBakedModel ibakedmodel = this.getItemModelWithOverrides(p_184392_1_, p_184392_2_.field_70170_p, p_184392_2_);
            this.renderItemModel(p_184392_1_, ibakedmodel, p_184392_3_, p_184392_4_);
        }
    }

    protected void renderItemModel(ItemStack p_184394_1_, IBakedModel p_184394_2_, ItemCameraTransforms.TransformType p_184394_3_, boolean p_184394_4_) {
        if (!p_184394_1_.func_190926_b()) {
            this.textureManager.func_110577_a(TextureMap.field_110575_b);
            this.textureManager.func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179091_B();
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_179094_E();
            p_184394_2_ = ForgeHooksClient.handleCameraTransforms((IBakedModel)p_184394_2_, (ItemCameraTransforms.TransformType)p_184394_3_, (boolean)p_184394_4_);
            this.renderItem(p_184394_1_, p_184394_2_);
            GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.BACK);
            GlStateManager.func_179121_F();
            GlStateManager.func_179101_C();
            GlStateManager.func_179084_k();
            this.textureManager.func_110577_a(TextureMap.field_110575_b);
            this.textureManager.func_110581_b(TextureMap.field_110575_b).func_174935_a();
        }
    }

    private boolean isThereOneNegativeScale(ItemTransformVec3f itemTranformVec) {
        return itemTranformVec.field_178363_d.x < 0.0f ^ itemTranformVec.field_178363_d.y < 0.0f ^ itemTranformVec.field_178363_d.z < 0.0f;
    }

    public void renderItemIntoGUI(ItemStack stack, int x, int y) {
        this.renderItemModelIntoGUI(stack, x, y, this.getItemModelWithOverrides(stack, null, null));
    }

    protected void renderItemModelIntoGUI(ItemStack p_184390_1_, int p_184390_2_, int p_184390_3_, IBakedModel p_184390_4_) {
        GlStateManager.func_179094_E();
        this.textureManager.func_110577_a(TextureMap.field_110575_b);
        this.textureManager.func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
        GlStateManager.func_179091_B();
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.setupGuiTransform(p_184390_2_, p_184390_3_, p_184390_4_.func_177556_c());
        p_184390_4_ = ForgeHooksClient.handleCameraTransforms((IBakedModel)p_184390_4_, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.GUI, (boolean)false);
        this.renderItem(p_184390_1_, p_184390_4_);
        GlStateManager.func_179118_c();
        GlStateManager.func_179101_C();
        GlStateManager.func_179140_f();
        GlStateManager.func_179121_F();
        this.textureManager.func_110577_a(TextureMap.field_110575_b);
        this.textureManager.func_110581_b(TextureMap.field_110575_b).func_174935_a();
    }

    private void setupGuiTransform(int xPosition, int yPosition, boolean isGui3d) {
        GlStateManager.func_179109_b((float)xPosition, (float)yPosition, (float)(100.0f + this.zLevel));
        GlStateManager.func_179109_b((float)8.0f, (float)8.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)1.0f);
        GlStateManager.func_179152_a((float)16.0f, (float)16.0f, (float)16.0f);
        if (isGui3d) {
            GlStateManager.func_179140_f();
        } else {
            GlStateManager.func_179140_f();
        }
    }

    public void renderItemAndEffectIntoGUI(ItemStack stack, int xPosition, int yPosition) {
        this.renderItemAndEffectIntoGUI((EntityLivingBase)Minecraft.func_71410_x().field_71439_g, stack, xPosition, yPosition);
    }

    public void renderItemAndEffectIntoGUI(EntityLivingBase p_184391_1_, final ItemStack p_184391_2_, int p_184391_3_, int p_184391_4_) {
        if (p_184391_2_ != null && !p_184391_2_.func_190926_b()) {
            this.zLevel += 50.0f;
            try {
                this.renderItemModelIntoGUI(p_184391_2_, p_184391_3_, p_184391_4_, this.getItemModelWithOverrides(p_184391_2_, null, p_184391_1_));
            }
            catch (Throwable var8) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)var8, (String)"Rendering item");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Item being rendered");
                crashreportcategory.func_71507_a("Item Type", (Object)new Callable(){

                    public String call() throws Exception {
                        return String.valueOf(p_184391_2_.func_77973_b());
                    }
                });
                crashreportcategory.func_71507_a("Item Aux", (Object)new Callable(){

                    public String call() throws Exception {
                        return String.valueOf(p_184391_2_.func_77960_j());
                    }
                });
                crashreportcategory.func_71507_a("Item NBT", (Object)new Callable(){

                    public String call() throws Exception {
                        return String.valueOf(p_184391_2_.func_77978_p());
                    }
                });
                crashreportcategory.func_71507_a("Item Foil", (Object)new Callable(){

                    public String call() throws Exception {
                        return String.valueOf(p_184391_2_.func_77962_s());
                    }
                });
                throw new ReportedException(crashreport);
            }
            this.zLevel -= 50.0f;
        }
    }

    public void renderItemOverlays(FontRenderer fr, ItemStack stack, int xPosition, int yPosition) {
        this.renderItemOverlayIntoGUI(fr, stack, xPosition, yPosition, null);
    }

    public void renderItemOverlayIntoGUI(FontRenderer fr, ItemStack stack, int xPosition, int yPosition, String text) {
        if (!stack.func_190926_b()) {
            EntityPlayerSP entityplayersp2;
            float f;
            if (stack.func_190916_E() != 1 || text != null) {
                String entityplayersp;
                String string = entityplayersp = text == null ? String.valueOf(stack.func_190916_E()) : text;
                if (text == null && stack.func_190916_E() < 1) {
                    entityplayersp = TextFormatting.RED + String.valueOf(stack.func_190916_E());
                }
                GlStateManager.func_179140_f();
                GlStateManager.func_179097_i();
                GlStateManager.func_179084_k();
                fr.func_175063_a(entityplayersp, (float)(xPosition + 19 - 2 - fr.func_78256_a(entityplayersp)), (float)(yPosition + 6 + 3), 0xFFFFFF);
                GlStateManager.func_179145_e();
                GlStateManager.func_179126_j();
            }
            if (stack.func_77973_b().showDurabilityBar(stack)) {
                double entityplayersp1 = stack.func_77973_b().getDurabilityForDisplay(stack);
                int tessellator1 = (int)Math.round(13.0 - entityplayersp1 * 13.0);
                int bufferbuilder1 = (int)Math.round(255.0 - entityplayersp1 * 255.0);
                GlStateManager.func_179140_f();
                GlStateManager.func_179097_i();
                GlStateManager.func_179090_x();
                GlStateManager.func_179118_c();
                GlStateManager.func_179084_k();
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder bufferbuilder = tessellator.func_178180_c();
                this.draw(bufferbuilder, xPosition + 2, yPosition + 13, 13, 2, 0, 0, 0, 255);
                this.draw(bufferbuilder, xPosition + 2, yPosition + 13, 12, 1, (255 - bufferbuilder1) / 4, 64, 0, 255);
                this.draw(bufferbuilder, xPosition + 2, yPosition + 13, tessellator1, 1, 255 - bufferbuilder1, bufferbuilder1, 0, 255);
                GlStateManager.func_179141_d();
                GlStateManager.func_179098_w();
                GlStateManager.func_179145_e();
                GlStateManager.func_179126_j();
            }
            float f2 = f = (entityplayersp2 = Minecraft.func_71410_x().field_71439_g) == null ? 0.0f : entityplayersp2.func_184811_cZ().func_185143_a(stack.func_77973_b(), Minecraft.func_71410_x().func_184121_ak());
            if (f > 0.0f) {
                GlStateManager.func_179140_f();
                GlStateManager.func_179097_i();
                GlStateManager.func_179090_x();
                Tessellator tessellator11 = Tessellator.func_178181_a();
                BufferBuilder bufferbuilder11 = tessellator11.func_178180_c();
                this.draw(bufferbuilder11, xPosition, yPosition + MathHelper.func_76141_d((float)(16.0f * (1.0f - f))), 16, MathHelper.func_76123_f((float)(16.0f * f)), 255, 255, 255, 127);
                GlStateManager.func_179098_w();
                GlStateManager.func_179145_e();
                GlStateManager.func_179126_j();
            }
        }
    }

    private void draw(BufferBuilder renderer, int x, int y, int width, int height, int red, int green, int blue, int alpha) {
        renderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        renderer.func_181662_b((double)(x + 0), (double)(y + 0), 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        renderer.func_181662_b((double)(x + 0), (double)(y + height), 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        renderer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        renderer.func_181662_b((double)(x + width), (double)(y + 0), 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    public void func_110549_a(@Nonnull IResourceManager resourceManager) {
        this.itemModelMesher.func_178085_b();
    }
}

