/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.integration;

import blusunrize.immersiveengineering.api.crafting.AlloyRecipe;
import blusunrize.immersiveengineering.api.crafting.ArcFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.BlastFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.CrusherRecipe;
import blusunrize.immersiveengineering.api.crafting.MetalPressRecipe;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import wanion.lib.common.FixedSizeList;
import wanion.lib.common.MetaItem;
import wanion.unidict.UniOreDictionary;
import wanion.unidict.integration.AbstractIntegrationThread;

final class IEIntegration
extends AbstractIntegrationThread {
    IEIntegration() {
        super("Immersive Engineering");
    }

    public String call() {
        try {
            this.fixAlloyKilnRecipes();
            this.fixArcFurnaceRecipes();
            this.fixBlastFurnaceRecipes();
            this.fixCrusherRecipes();
            this.fixMetalPressRecipes();
        }
        catch (Exception e) {
            this.logger.error(this.threadName + e);
        }
        return this.threadName + "The world's engineer appears to be more immersive.";
    }

    private void fixAlloyKilnRecipes() {
        ArrayList alloyRecipeList = AlloyRecipe.recipeList;
        ArrayList<AlloyRecipe> newRecipes = new ArrayList<AlloyRecipe>();
        Iterator alloyRecipeIterator = alloyRecipeList.iterator();
        while (alloyRecipeIterator.hasNext()) {
            AlloyRecipe alloyRecipe = (AlloyRecipe)alloyRecipeIterator.next();
            newRecipes.add(new AlloyRecipe(this.resourceHandler.getMainItemStack(alloyRecipe.output), (Object)alloyRecipe.input0, (Object)alloyRecipe.input1, alloyRecipe.time));
            alloyRecipeIterator.remove();
        }
        alloyRecipeList.clear();
        alloyRecipeList.addAll(newRecipes);
    }

    private void fixArcFurnaceRecipes() {
        ArrayList arcFurnaceRecipes = ArcFurnaceRecipe.recipeList;
        ArrayList<ArcFurnaceRecipe> correctRecipes = new ArrayList<ArcFurnaceRecipe>(new Double((double)arcFurnaceRecipes.size() * 1.3).intValue());
        Iterator arcFurnaceRecipeIterator = arcFurnaceRecipes.iterator();
        while (arcFurnaceRecipeIterator.hasNext()) {
            ArcFurnaceRecipe recipe = (ArcFurnaceRecipe)arcFurnaceRecipeIterator.next();
            ItemStack correctOutput = this.resourceHandler.getMainItemStack(recipe.output);
            if (correctOutput == recipe.output) continue;
            int time = (int)Math.floor((float)recipe.getTotalProcessTime() / ArcFurnaceRecipe.timeModifier);
            int energy = (int)Math.floor((float)recipe.getTotalProcessEnergy() / ArcFurnaceRecipe.energyModifier / (float)recipe.getTotalProcessTime());
            correctRecipes.add(new ArcFurnaceRecipe(correctOutput, (Object)recipe.input, recipe.slag, time, energy, (Object[])recipe.additives));
            arcFurnaceRecipeIterator.remove();
        }
        arcFurnaceRecipes.addAll(correctRecipes);
    }

    private void fixBlastFurnaceRecipes() {
        ArrayList correctRecipes = new ArrayList(new Double((double)BlastFurnaceRecipe.recipeList.size() * 1.3).intValue());
        correctRecipes.addAll(BlastFurnaceRecipe.recipeList.stream().map(blastFurnaceRecipe -> new BlastFurnaceRecipe(this.resourceHandler.getMainItemStack(blastFurnaceRecipe.output), blastFurnaceRecipe.input, blastFurnaceRecipe.time, blastFurnaceRecipe.slag)).collect(Collectors.toList()));
        BlastFurnaceRecipe.recipeList.clear();
        BlastFurnaceRecipe.recipeList.addAll(correctRecipes);
    }

    private void fixCrusherRecipes() {
        ArrayList crusherRecipes = CrusherRecipe.recipeList;
        FixedSizeList correctRecipes = new FixedSizeList(crusherRecipes.size());
        TIntHashSet uniques = new TIntHashSet(crusherRecipes.size(), 1.0f);
        Iterator crusherRecipesIterator = crusherRecipes.iterator();
        while (crusherRecipesIterator.hasNext()) {
            CrusherRecipe crusherRecipe = (CrusherRecipe)crusherRecipesIterator.next();
            ItemStack correctOutput = this.resourceHandler.getMainItemStack(crusherRecipe.output);
            if (correctOutput == crusherRecipe.output) continue;
            ItemStack input = UniOreDictionary.getFirstEntry(crusherRecipe.oreInputString);
            int recipeId = MetaItem.getCumulative((ItemStack[])new ItemStack[]{input, correctOutput});
            if (!uniques.contains(recipeId)) {
                CrusherRecipe newRecipe = new CrusherRecipe(correctOutput, (Object)crusherRecipe.input, (int)Math.floor((float)crusherRecipe.getTotalProcessEnergy() / CrusherRecipe.energyModifier));
                if (crusherRecipe.secondaryOutput != null) {
                    IEIntegration.setSecondaryOutputAndChance(newRecipe, this.resourceHandler.getMainItemStacks(crusherRecipe.secondaryOutput), crusherRecipe.secondaryChance);
                }
                correctRecipes.add(newRecipe);
                uniques.add(recipeId);
            }
            crusherRecipesIterator.remove();
        }
        crusherRecipes.addAll(correctRecipes);
    }

    private void fixMetalPressRecipes() {
        ArrayListMultimap metalPressRecipes = MetalPressRecipe.recipeList;
        ArrayListMultimap correctRecipes = ArrayListMultimap.create();
        TIntHashSet uniques = new TIntHashSet(metalPressRecipes.size(), 1.0f);
        Iterator metalPressRecipesIterator = metalPressRecipes.values().iterator();
        while (metalPressRecipesIterator.hasNext()) {
            MetalPressRecipe metalPressRecipe = (MetalPressRecipe)metalPressRecipesIterator.next();
            ItemStack output = this.resourceHandler.getMainItemStack(metalPressRecipe.output);
            if (output == metalPressRecipe.output) continue;
            int id = MetaItem.getCumulative((ItemStack[])new ItemStack[]{output, metalPressRecipe.mold.stack});
            if (!uniques.contains(id)) {
                correctRecipes.put((Object)metalPressRecipe.mold, (Object)new MetalPressRecipe(output, (Object)metalPressRecipe.input, metalPressRecipe.mold, (int)Math.floor((float)metalPressRecipe.getTotalProcessEnergy() / MetalPressRecipe.timeModifier)).setInputSize(metalPressRecipe.input.inputSize));
                uniques.add(id);
            }
            metalPressRecipesIterator.remove();
        }
        metalPressRecipes.putAll((Multimap)correctRecipes);
    }

    private static void setSecondaryOutputAndChance(@Nonnull CrusherRecipe crusherRecipe, ItemStack[] itemStacks, float[] chance) {
        if (crusherRecipe.secondaryOutput != null && crusherRecipe.secondaryChance != null && itemStacks.length == chance.length) {
            ArrayList<Object> secondaryAndChanceList = new ArrayList<Object>();
            for (int i = 0; i < itemStacks.length; ++i) {
                secondaryAndChanceList.add(itemStacks[i]);
                secondaryAndChanceList.add(Float.valueOf(chance[i]));
            }
            crusherRecipe.addToSecondaryOutput(secondaryAndChanceList.toArray());
        }
    }
}

