/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.integration;

import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.MachineRecipe;
import ic2.api.recipe.Recipes;
import ic2.core.recipe.MachineRecipeHelper;
import ic2.core.recipe.ScrapboxRecipeManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import wanion.lib.common.Util;
import wanion.unidict.UniDict;
import wanion.unidict.integration.AbstractIntegrationThread;

final class IC2Integration
extends AbstractIntegrationThread {
    private final List<Map<IRecipeInput, MachineRecipe<IRecipeInput, Collection<ItemStack>>>> ic2MachinesRecipeList = new ArrayList<Map<IRecipeInput, MachineRecipe<IRecipeInput, Collection<ItemStack>>>>(8);

    IC2Integration() {
        super("Industrial Craft 2");
        try {
            this.ic2MachinesRecipeList.add((Map<IRecipeInput, MachineRecipe<IRecipeInput, Collection<ItemStack>>>)Util.getField(MachineRecipeHelper.class, (String)"recipes", (Object)Recipes.centrifuge, Map.class));
            this.ic2MachinesRecipeList.add((Map<IRecipeInput, MachineRecipe<IRecipeInput, Collection<ItemStack>>>)Util.getField(MachineRecipeHelper.class, (String)"recipes", (Object)Recipes.compressor, Map.class));
            this.ic2MachinesRecipeList.add((Map<IRecipeInput, MachineRecipe<IRecipeInput, Collection<ItemStack>>>)Util.getField(MachineRecipeHelper.class, (String)"recipes", (Object)Recipes.blastfurnace, Map.class));
            this.ic2MachinesRecipeList.add((Map<IRecipeInput, MachineRecipe<IRecipeInput, Collection<ItemStack>>>)Util.getField(MachineRecipeHelper.class, (String)"recipes", (Object)Recipes.macerator, Map.class));
            this.ic2MachinesRecipeList.add((Map<IRecipeInput, MachineRecipe<IRecipeInput, Collection<ItemStack>>>)Util.getField(MachineRecipeHelper.class, (String)"recipes", (Object)Recipes.metalformerCutting, Map.class));
            this.ic2MachinesRecipeList.add((Map<IRecipeInput, MachineRecipe<IRecipeInput, Collection<ItemStack>>>)Util.getField(MachineRecipeHelper.class, (String)"recipes", (Object)Recipes.metalformerExtruding, Map.class));
            this.ic2MachinesRecipeList.add((Map<IRecipeInput, MachineRecipe<IRecipeInput, Collection<ItemStack>>>)Util.getField(MachineRecipeHelper.class, (String)"recipes", (Object)Recipes.metalformerRolling, Map.class));
            this.ic2MachinesRecipeList.add((Map<IRecipeInput, MachineRecipe<IRecipeInput, Collection<ItemStack>>>)Util.getField(MachineRecipeHelper.class, (String)"recipes", (Object)Recipes.blockcutter, Map.class));
        }
        catch (Exception e) {
            UniDict.getLogger().error(this.threadName + e);
        }
    }

    public String call() {
        this.ic2MachinesRecipeList.forEach(map -> {
            try {
                this.fixMachinesOutputs((Map<IRecipeInput, MachineRecipe<IRecipeInput, Collection<ItemStack>>>)map);
            }
            catch (Exception e) {
                this.logger.error(this.threadName + e);
            }
        });
        try {
            this.fixScrapBoxDrops();
        }
        catch (Exception e) {
            this.logger.error(this.threadName + e);
        }
        return this.threadName + "The world appears to be entirely industrialized.";
    }

    private void fixMachinesOutputs(Map<IRecipeInput, MachineRecipe<IRecipeInput, Collection<ItemStack>>> recipes) {
        for (Map.Entry<IRecipeInput, MachineRecipe<IRecipeInput, Collection<ItemStack>>> recipe : recipes.entrySet()) {
            recipe.setValue((MachineRecipe<IRecipeInput, Collection<ItemStack>>)new MachineRecipe(recipe.getValue().getInput(), this.resourceHandler.getMainItemStacks((Collection)recipe.getValue().getOutput())));
        }
    }

    private void fixScrapBoxDrops() {
        Constructor<?> dropConstructor;
        Class<?>[] classes = ScrapboxRecipeManager.class.getDeclaredClasses();
        Class<?> actualClass = null;
        for (Class<?> clas : classes) {
            if (!clas.getName().equals("ic2.core.recipe.ScrapboxRecipeManager$Drop")) continue;
            actualClass = clas;
            break;
        }
        if (actualClass == null) {
            return;
        }
        Class<?> dropClass = actualClass;
        try {
            dropConstructor = dropClass.getDeclaredConstructor(ItemStack.class, Float.TYPE);
            dropConstructor.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            return;
        }
        List dropList = (List)Util.getField(ScrapboxRecipeManager.class, (String)"drops", (Object)Recipes.scrapboxDrops, List.class);
        ArrayList newDrops = new ArrayList();
        dropList.forEach(drop -> {
            try {
                newDrops.add(dropConstructor.newInstance(this.resourceHandler.getMainItemStack((ItemStack)Util.getField((Class)dropClass, (String)"item", (Object)drop, ItemStack.class)), Util.getField((Class)dropClass, (String)"originalChance", (Object)drop, Float.class)));
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                e.printStackTrace();
            }
        });
        dropList.clear();
        dropList.addAll(newDrops);
    }
}

