/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone;

import de.maxhenkel.gravestone.Config;
import de.maxhenkel.gravestone.DeathInfo;
import de.maxhenkel.gravestone.Log;
import de.maxhenkel.gravestone.ModBlocks;
import de.maxhenkel.gravestone.ModItems;
import de.maxhenkel.gravestone.blocks.BlockGraveStone;
import de.maxhenkel.gravestone.tileentity.TileEntityGraveStone;
import de.maxhenkel.gravestone.util.NoSpaceException;
import de.maxhenkel.gravestone.util.Tools;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class GraveProcessor {
    private EntityLivingBase entity;
    private World world;
    private BlockPos deathPosition;
    private BlockPos gravePosition;
    private static List<Block> replaceableBlocks;
    private List<ItemStack> drops;
    private long time;

    public GraveProcessor(EntityLivingBase entity) {
        this.entity = entity;
        this.world = entity.func_130014_f_();
        this.gravePosition = this.deathPosition = entity.func_180425_c();
        this.drops = new ArrayList<ItemStack>();
        this.time = System.currentTimeMillis();
        if (replaceableBlocks == null) {
            replaceableBlocks = Config.replaceableBlocks;
        }
    }

    public boolean checkSpongeBug() {
        if (!this.world.func_180495_p(this.deathPosition).func_177230_c().equals((Object)ModBlocks.GRAVESTONE)) {
            return false;
        }
        TileEntity tile = this.world.func_175625_s(this.deathPosition);
        if (!(tile instanceof TileEntityGraveStone)) {
            return false;
        }
        TileEntityGraveStone graveTile = (TileEntityGraveStone)tile;
        if (System.currentTimeMillis() - graveTile.getDeathTime() > 500L) {
            return false;
        }
        if (!graveTile.getPlayerUUID().equals(this.entity.func_110124_au().toString())) {
            return false;
        }
        Log.e("LivingDropsEvent fired multiple times!");
        return true;
    }

    public boolean placeGraveStone(List<EntityItem> drops) {
        for (EntityItem ei : drops) {
            this.drops.add(ei.func_92059_d());
        }
        try {
            this.gravePosition = this.getGraveStoneLocation();
        }
        catch (NoSpaceException e) {
            this.gravePosition = this.deathPosition;
            Log.i("Grave from '" + this.entity.func_70005_c_() + "' cant be created (No space)");
            return false;
        }
        try {
            this.world.func_175656_a(this.gravePosition, ModBlocks.GRAVESTONE.func_176223_P().func_177226_a((IProperty)BlockGraveStone.FACING, (Comparable)this.entity.func_174811_aO().func_176734_d()));
            if (this.isReplaceable(this.gravePosition.func_177977_b())) {
                this.world.func_175656_a(this.gravePosition.func_177977_b(), Blocks.field_150346_d.func_176223_P());
            }
        }
        catch (Exception e) {
            return false;
        }
        TileEntity tileentity = this.world.func_175625_s(this.gravePosition);
        if (tileentity == null || !(tileentity instanceof TileEntityGraveStone)) {
            return false;
        }
        try {
            TileEntityGraveStone graveTileEntity = (TileEntityGraveStone)tileentity;
            graveTileEntity.setPlayerName(this.entity.func_70005_c_());
            graveTileEntity.setPlayerUUID(this.entity.func_110124_au().toString());
            graveTileEntity.setDeathTime(this.time);
            graveTileEntity.setRenderHead(this.entity instanceof EntityPlayer);
            this.addItems(graveTileEntity, drops);
        }
        catch (Exception e) {
            Log.w("Failed to fill gravestone with data");
        }
        return true;
    }

    private void addItems(TileEntityGraveStone graveStone, List<EntityItem> items) {
        try {
            for (int i = 0; i < items.size(); ++i) {
                EntityItem item = items.get(i);
                try {
                    ItemStack stack = item.func_92059_d();
                    if (graveStone.func_70302_i_() > i) {
                        graveStone.func_70299_a(i, stack);
                        continue;
                    }
                    InventoryHelper.func_180173_a((World)this.world, (double)graveStone.func_174877_v().func_177958_n(), (double)graveStone.func_174877_v().func_177956_o(), (double)graveStone.func_174877_v().func_177952_p(), (ItemStack)stack);
                    continue;
                }
                catch (Exception e) {
                    Log.w("Failed to add Item '" + item.func_92059_d().func_77977_a() + "' to gravestone");
                }
            }
        }
        catch (Exception e) {
            Log.w("Failed to add Ites to gravestone");
        }
    }

    public BlockPos getGraveStoneLocation() throws NoSpaceException {
        BlockPos location = new BlockPos(this.deathPosition.func_177958_n(), this.deathPosition.func_177956_o(), this.deathPosition.func_177952_p());
        if (this.world.func_189509_E(location) && location.func_177956_o() < this.world.func_72800_K()) {
            location = new BlockPos(location.func_177958_n(), 1, location.func_177952_p());
        }
        while (location.func_177956_o() < this.world.func_72800_K()) {
            if (this.isReplaceable(location)) {
                return location;
            }
            location = location.func_177982_a(0, 1, 0);
        }
        throw new NoSpaceException("No free Block above death Location");
    }

    private boolean isReplaceable(BlockPos pos) {
        Block b = this.world.func_180495_p(pos).func_177230_c();
        if (b.func_149739_a().equals(Blocks.field_150350_a.func_149739_a())) {
            return true;
        }
        for (Block replaceableBlock : replaceableBlocks) {
            if (!b.func_149739_a().equals(replaceableBlock.func_149739_a())) continue;
            return true;
        }
        return false;
    }

    public void givePlayerNote() {
        ItemStack stack;
        if (!(this.entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)this.entity;
        DeathInfo.ItemInfo[] items = new DeathInfo.ItemInfo[this.drops.size()];
        for (int i = 0; i < this.drops.size(); ++i) {
            stack = this.drops.get(i);
            if (stack == null) continue;
            items[i] = new DeathInfo.ItemInfo(Tools.getStringFromItem(stack.func_77973_b()), stack.func_190916_E(), stack.func_77960_j());
        }
        DeathInfo info = new DeathInfo(this.gravePosition, player.field_71093_bK, items, player.func_70005_c_(), this.time, player.func_110124_au());
        stack = new ItemStack((Item)ModItems.DEATH_INFO);
        info.addToItemStack(stack);
        player.field_71071_by.func_70441_a(stack);
    }

    public EntityLivingBase getEntity() {
        return this.entity;
    }

    public World getWorld() {
        return this.world;
    }

    public BlockPos getDeathPosition() {
        return this.deathPosition;
    }

    public static List<Block> getReplaceableBlocks() {
        return replaceableBlocks;
    }

    public List<ItemStack> getDrops() {
        return this.drops;
    }

    public long getTime() {
        return this.time;
    }

    public BlockPos getGravePosition() {
        return this.gravePosition;
    }
}

