/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.tile;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.blay09.mods.cookingforblockheads.ModConfig;
import net.blay09.mods.cookingforblockheads.api.capability.CapabilityKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.registry.CookingRegistry;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileSink
extends TileEntity {
    private final FluidTank waterTank = new WaterTank(16000);
    private final SinkItemProvider itemProvider = new SinkItemProvider(this.waterTank);
    private EnumDyeColor color = EnumDyeColor.WHITE;

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.func_145839_a(pkt.func_148857_g());
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        this.waterTank.writeToNBT(tagCompound);
        tagCompound.func_74774_a("Color", (byte)this.color.func_176767_b());
        return tagCompound;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.waterTank.readFromNBT(tagCompound);
        this.color = EnumDyeColor.func_176766_a((int)tagCompound.func_74771_c("Color"));
    }

    public int getWaterAmount() {
        return this.waterTank.getFluidAmount();
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityKitchenItemProvider.CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityKitchenItemProvider.CAPABILITY) {
            return (T)this.itemProvider;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.waterTank;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public EnumDyeColor getColor() {
        return this.color;
    }

    public void setColor(EnumDyeColor color) {
        this.color = color;
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.markAndNotifyBlock(this.field_174879_c, this.field_145850_b.func_175726_f(this.field_174879_c), state, state, 3);
        this.func_70296_d();
    }

    private static class SinkItemProvider
    implements IKitchenItemProvider {
        private final NonNullList<ItemStack> itemStacks = NonNullList.func_191196_a();
        private final FluidTank fluidTank;
        private int waterUsed;

        public SinkItemProvider(FluidTank fluidTank) {
            this.fluidTank = fluidTank;
            this.itemStacks.addAll(CookingRegistry.getWaterItems());
        }

        @Override
        public void resetSimulation() {
            this.waterUsed = 0;
        }

        @Override
        public ItemStack useItemStack(int slot, int amount, boolean simulate, List<IKitchenItemProvider> inventories, boolean requireBucket) {
            if (!ModConfig.general.sinkRequiresWater || this.fluidTank.getFluidAmount() - this.waterUsed > amount * 1000) {
                if (requireBucket && this.getStackInSlot(slot).func_77973_b() == Items.field_151117_aB && !CookingRegistry.consumeBucket(inventories, simulate)) {
                    return ItemStack.field_190927_a;
                }
                if (simulate) {
                    this.waterUsed += amount * 1000;
                } else {
                    this.fluidTank.drain(amount * 1000, true);
                }
                return ItemHandlerHelper.copyStackWithSize((ItemStack)this.getStackInSlot(slot), (int)amount);
            }
            return ItemStack.field_190927_a;
        }

        @Override
        public ItemStack returnItemStack(ItemStack itemStack) {
            for (ItemStack providedStack : this.itemStacks) {
                if (!ItemHandlerHelper.canItemStacksStackRelaxed((ItemStack)itemStack, (ItemStack)providedStack)) continue;
                this.fluidTank.fill(new FluidStack(FluidRegistry.WATER, 1000), true);
                break;
            }
            return ItemStack.field_190927_a;
        }

        @Override
        public int getSlots() {
            return this.itemStacks.size();
        }

        @Override
        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return (ItemStack)this.itemStacks.get(slot);
        }
    }

    private static class WaterTank
    extends FluidTank {
        private static final FluidStack MAX_WATER = new FluidStack(FluidRegistry.WATER, Integer.MAX_VALUE);

        public WaterTank(int capacity) {
            super(capacity);
        }

        public FluidStack getFluid() {
            if (!ModConfig.general.sinkRequiresWater) {
                return MAX_WATER;
            }
            return super.getFluid();
        }

        public int getFluidAmount() {
            if (!ModConfig.general.sinkRequiresWater) {
                return Integer.MAX_VALUE;
            }
            return super.getFluidAmount();
        }

        public int getCapacity() {
            if (!ModConfig.general.sinkRequiresWater) {
                return Integer.MAX_VALUE;
            }
            return super.getCapacity();
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (!ModConfig.general.sinkRequiresWater || resource.getFluid() != FluidRegistry.WATER) {
                return resource.amount;
            }
            return super.fill(resource, doFill);
        }

        public FluidStack drain(FluidStack resource, boolean doDrain) {
            if (!ModConfig.general.sinkRequiresWater && resource.getFluid() == FluidRegistry.WATER) {
                return resource.copy();
            }
            return super.drain(resource, doDrain);
        }

        public FluidStack drain(int maxDrain, boolean doDrain) {
            if (!ModConfig.general.sinkRequiresWater) {
                return new FluidStack(FluidRegistry.WATER, maxDrain);
            }
            return super.drain(maxDrain, doDrain);
        }
    }
}

