/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.registry;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.blay09.mods.cookingforblockheads.registry.RecipeType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class FoodRecipeWithIngredients {
    private final ItemStack outputItem;
    private final RecipeType recipeType;
    private final int recipeWidth;
    private final List<NonNullList<ItemStack>> craftMatrix;

    public FoodRecipeWithIngredients(ItemStack outputItem, RecipeType recipeType, int recipeWidth, List<NonNullList<ItemStack>> craftMatrix) {
        this.outputItem = outputItem;
        this.recipeType = recipeType;
        this.recipeWidth = recipeWidth;
        this.craftMatrix = craftMatrix;
    }

    public static FoodRecipeWithIngredients read(ByteBuf buf) {
        ItemStack outputItem = ByteBufUtils.readItemStack((ByteBuf)buf);
        byte recipeWidth = buf.readByte();
        int ingredientCount = buf.readByte();
        ArrayList craftMatrix = Lists.newArrayListWithCapacity((int)ingredientCount);
        for (int i = 0; i < ingredientCount; ++i) {
            int stackCount = buf.readByte();
            if (stackCount > 0) {
                NonNullList stackList = NonNullList.func_191196_a();
                for (int j = 0; j < stackCount; ++j) {
                    stackList.add((Object)ByteBufUtils.readItemStack((ByteBuf)buf));
                }
                craftMatrix.add(stackList);
                continue;
            }
            craftMatrix.add(null);
        }
        RecipeType recipeType = RecipeType.fromId(buf.readByte());
        return new FoodRecipeWithIngredients(outputItem, recipeType, recipeWidth, craftMatrix);
    }

    public void write(ByteBuf buf) {
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.outputItem);
        buf.writeByte(this.recipeWidth);
        buf.writeByte(this.craftMatrix.size());
        for (List list : this.craftMatrix) {
            buf.writeByte(list.size());
            for (ItemStack stack : list) {
                ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)stack);
            }
        }
        buf.writeByte(this.recipeType.ordinal());
    }

    public RecipeType getRecipeType() {
        return this.recipeType;
    }

    public int getRecipeWidth() {
        return this.recipeWidth;
    }

    public List<NonNullList<ItemStack>> getCraftMatrix() {
        return this.craftMatrix;
    }

    public ItemStack getOutputItem() {
        return this.outputItem;
    }
}

