/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.registry;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.blay09.mods.cookingforblockheads.ItemUtils;
import net.blay09.mods.cookingforblockheads.KitchenMultiBlock;
import net.blay09.mods.cookingforblockheads.api.ISortButton;
import net.blay09.mods.cookingforblockheads.api.RecipeStatus;
import net.blay09.mods.cookingforblockheads.api.SinkHandler;
import net.blay09.mods.cookingforblockheads.api.ToastHandler;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.KitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.event.FoodRegistryInitEvent;
import net.blay09.mods.cookingforblockheads.compat.HarvestCraftAddon;
import net.blay09.mods.cookingforblockheads.container.inventory.InventoryCraftBook;
import net.blay09.mods.cookingforblockheads.registry.recipe.FoodIngredient;
import net.blay09.mods.cookingforblockheads.registry.recipe.FoodRecipe;
import net.blay09.mods.cookingforblockheads.registry.recipe.GeneralFoodRecipe;
import net.blay09.mods.cookingforblockheads.registry.recipe.SmeltingFood;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class CookingRegistry {
    private static final List<IRecipe> recipeList = Lists.newArrayList();
    private static final ArrayListMultimap<ItemIdentifier, FoodRecipe> foodItems = ArrayListMultimap.create();
    private static final NonNullList<ItemStack> tools = NonNullList.func_191196_a();
    private static final Map<ItemStack, Integer> ovenFuelItems = Maps.newHashMap();
    private static final Map<ItemStack, ItemStack> ovenRecipes = Maps.newHashMap();
    private static final Map<ItemStack, SinkHandler> sinkHandlers = Maps.newHashMap();
    private static final Map<ItemStack, ToastHandler> toastHandlers = Maps.newHashMap();
    private static final NonNullList<ItemStack> waterItems = NonNullList.func_191196_a();
    private static final NonNullList<ItemStack> milkItems = NonNullList.func_191196_a();
    private static final List<ISortButton> customSortButtons = Lists.newArrayList();
    private static Collection<ItemStack> nonFoodRecipes;

    public static void initFoodRegistry() {
        recipeList.clear();
        foodItems.clear();
        FoodRegistryInitEvent init = new FoodRegistryInitEvent();
        MinecraftForge.EVENT_BUS.post((Event)init);
        nonFoodRecipes = init.getNonFoodRecipes();
        block0: for (IRecipe recipe : CraftingManager.field_193380_a) {
            ItemStack output = recipe.func_77571_b();
            if (output.func_190926_b()) continue;
            if (output.func_77973_b() instanceof ItemFood) {
                if (HarvestCraftAddon.isWeirdConversionRecipe(recipe)) continue;
                CookingRegistry.addFoodRecipe(recipe);
                continue;
            }
            for (ItemStack itemStack : nonFoodRecipes) {
                if (!ItemUtils.areItemStacksEqualWithWildcard(recipe.func_77571_b(), itemStack)) continue;
                CookingRegistry.addFoodRecipe(recipe);
                continue block0;
            }
        }
        Iterator iterator = FurnaceRecipes.func_77602_a().func_77599_b().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry obj;
            Map.Entry entry = obj = iterator.next();
            ItemStack sourceStack = ItemStack.field_190927_a;
            if (entry.getKey() instanceof Item) {
                sourceStack = new ItemStack((Item)entry.getKey());
            } else if (entry.getKey() instanceof Block) {
                sourceStack = new ItemStack((Block)entry.getKey());
            } else if (entry.getKey() instanceof ItemStack) {
                sourceStack = (ItemStack)entry.getKey();
            }
            ItemStack resultStack = (ItemStack)entry.getValue();
            if (resultStack.func_77973_b() instanceof ItemFood) {
                foodItems.put((Object)new ItemIdentifier(resultStack), (Object)new SmeltingFood(resultStack, sourceStack));
                continue;
            }
            if (!CookingRegistry.isNonFoodRecipe(resultStack)) continue;
            foodItems.put((Object)new ItemIdentifier(resultStack), (Object)new SmeltingFood(resultStack, sourceStack));
        }
    }

    public static boolean isNonFoodRecipe(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return false;
        }
        for (ItemStack nonFoodStack : nonFoodRecipes) {
            if (!ItemUtils.areItemStacksEqualWithWildcard(itemStack, nonFoodStack)) continue;
            return true;
        }
        return false;
    }

    public static void addFoodRecipe(IRecipe recipe) {
        ItemStack output = recipe.func_77571_b();
        if (!output.func_190926_b()) {
            recipeList.add(recipe);
            foodItems.put((Object)new ItemIdentifier(output), (Object)new GeneralFoodRecipe(recipe));
        }
    }

    public static Multimap<ItemIdentifier, FoodRecipe> getFoodRecipes() {
        return foodItems;
    }

    public static Collection<FoodRecipe> getFoodRecipes(ItemStack outputItem) {
        return foodItems.get((Object)new ItemIdentifier(outputItem));
    }

    public static Collection<FoodRecipe> getFoodRecipes(ItemIdentifier outputItem) {
        return foodItems.get((Object)outputItem);
    }

    public static void addToolItem(ItemStack toolItem) {
        tools.add((Object)toolItem);
    }

    public static boolean isToolItem(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return false;
        }
        for (ItemStack toolItem : tools) {
            if (!ItemUtils.areItemStacksEqualWithWildcard(toolItem, itemStack)) continue;
            return true;
        }
        return false;
    }

    public static boolean isToolItem(Ingredient ingredient) {
        for (ItemStack itemStack : ingredient.func_193365_a()) {
            if (!CookingRegistry.isToolItem(itemStack)) continue;
            return true;
        }
        return false;
    }

    public static void addOvenFuel(ItemStack itemStack, int fuelTime) {
        ovenFuelItems.put(itemStack, fuelTime);
    }

    public static int getOvenFuelTime(ItemStack itemStack) {
        for (Map.Entry<ItemStack, Integer> entry : ovenFuelItems.entrySet()) {
            if (!ItemUtils.areItemStacksEqualWithWildcard(entry.getKey(), itemStack)) continue;
            return entry.getValue();
        }
        return 0;
    }

    public static void addSmeltingItem(ItemStack source, ItemStack result) {
        ovenRecipes.put(source, result);
    }

    public static ItemStack getSmeltingResult(ItemStack itemStack) {
        for (Map.Entry<ItemStack, ItemStack> entry : ovenRecipes.entrySet()) {
            if (!ItemUtils.areItemStacksEqualWithWildcard(entry.getKey(), itemStack)) continue;
            return entry.getValue();
        }
        return ItemStack.field_190927_a;
    }

    public static void addToastHandler(ItemStack itemStack, ToastHandler toastHandler) {
        toastHandlers.put(itemStack, toastHandler);
    }

    @Nullable
    public static ToastHandler getToastHandler(ItemStack itemStack) {
        for (Map.Entry<ItemStack, ToastHandler> entry : toastHandlers.entrySet()) {
            if (!ItemUtils.areItemStacksEqualWithWildcard(entry.getKey(), itemStack)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static void addSinkHandler(ItemStack itemStack, SinkHandler sinkHandler) {
        sinkHandlers.put(itemStack, sinkHandler);
    }

    public static ItemStack getSinkOutput(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        for (Map.Entry<ItemStack, SinkHandler> entry : sinkHandlers.entrySet()) {
            if (!ItemUtils.areItemStacksEqualWithWildcard(entry.getKey(), itemStack)) continue;
            return entry.getValue().getSinkOutput(itemStack);
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack findAnyItemStack(ItemStack checkStack, List<IKitchenItemProvider> inventories, boolean requireBucket) {
        if (checkStack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        for (int i = 0; i < inventories.size(); ++i) {
            IKitchenItemProvider itemProvider = inventories.get(i);
            for (int j = 0; j < itemProvider.getSlots(); ++j) {
                ItemStack itemStack = itemProvider.getStackInSlot(j);
                if (!ItemUtils.areItemStacksEqualWithWildcard(itemStack, checkStack) || itemProvider.useItemStack(j, 1, true, inventories, requireBucket).func_190926_b()) continue;
                return itemStack;
            }
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack findAnyItemStack(@Nullable FoodIngredient ingredient, List<IKitchenItemProvider> inventories, boolean requireBucket) {
        if (ingredient == null) {
            return ItemStack.field_190927_a;
        }
        for (int i = 0; i < inventories.size(); ++i) {
            IKitchenItemProvider itemProvider = inventories.get(i);
            for (int j = 0; j < itemProvider.getSlots(); ++j) {
                ItemStack itemStack = itemProvider.getStackInSlot(j);
                if (itemStack.func_190926_b() || !ingredient.isValidItem(itemStack) || itemProvider.useItemStack(j, 1, true, inventories, requireBucket).func_190926_b()) continue;
                return itemStack;
            }
        }
        return ItemStack.field_190927_a;
    }

    public static boolean consumeBucket(List<IKitchenItemProvider> inventories, boolean simulate) {
        ItemStack itemStack = new ItemStack(Items.field_151133_ar);
        for (int i = 0; i < inventories.size(); ++i) {
            IKitchenItemProvider itemProvider = inventories.get(i);
            for (int j = 0; j < itemProvider.getSlots(); ++j) {
                ItemStack providedStack = itemProvider.getStackInSlot(j);
                if (providedStack.func_190926_b() || !ItemUtils.areItemStacksEqualWithWildcard(itemStack, providedStack) || itemProvider.useItemStack(j, 1, simulate, inventories, false).func_190926_b()) continue;
                return true;
            }
        }
        return false;
    }

    public static RecipeStatus getRecipeStatus(FoodRecipe recipe, List<IKitchenItemProvider> inventories) {
        boolean requireBucket = CookingRegistry.doesItemRequireBucketForCrafting(recipe.getOutputItem());
        for (IKitchenItemProvider itemProvider : inventories) {
            itemProvider.resetSimulation();
        }
        List<FoodIngredient> craftMatrix = recipe.getCraftMatrix();
        NonNullList itemFound = NonNullList.func_191197_a((int)craftMatrix.size(), (Object)ItemStack.field_190927_a);
        boolean missingTools = false;
        for (int i = 0; i < craftMatrix.size(); ++i) {
            FoodIngredient ingredient = craftMatrix.get(i);
            itemFound.set(i, (Object)CookingRegistry.findAnyItemStack(ingredient, inventories, requireBucket));
            if (!((ItemStack)itemFound.get(i)).func_190926_b() || ingredient == null) continue;
            if (ingredient.isToolItem()) {
                missingTools = true;
                continue;
            }
            return RecipeStatus.MISSING_INGREDIENTS;
        }
        return missingTools ? RecipeStatus.MISSING_TOOLS : RecipeStatus.AVAILABLE;
    }

    public static List<IKitchenItemProvider> getItemProviders(@Nullable KitchenMultiBlock multiBlock, InventoryPlayer inventory) {
        return multiBlock != null ? multiBlock.getItemProviders(inventory) : Lists.newArrayList((Object[])new IKitchenItemProvider[]{new KitchenItemProvider((IItemHandler)new InvWrapper((IInventory)inventory))});
    }

    @Nullable
    public static IRecipe findFoodRecipe(InventoryCraftBook craftMatrix, World world) {
        for (IRecipe recipe : recipeList) {
            if (!recipe.func_77569_a((InventoryCrafting)craftMatrix, world)) continue;
            return recipe;
        }
        return null;
    }

    public static void addWaterItem(ItemStack waterItem) {
        waterItems.add((Object)waterItem);
    }

    public static void addMilkItem(ItemStack milkItem) {
        milkItems.add((Object)milkItem);
    }

    public static void addSortButton(ISortButton button) {
        customSortButtons.add(button);
    }

    public static NonNullList<ItemStack> getWaterItems() {
        return waterItems;
    }

    public static NonNullList<ItemStack> getMilkItems() {
        return milkItems;
    }

    public static List<ISortButton> getSortButtons() {
        return customSortButtons;
    }

    public static boolean doesItemRequireBucketForCrafting(ItemStack outputItem) {
        ItemStack containerItem = ForgeHooks.getContainerItem((ItemStack)outputItem);
        if (!containerItem.func_190926_b() && containerItem.func_77973_b() == Items.field_151133_ar) {
            return true;
        }
        ResourceLocation registryName = outputItem.func_77973_b().getRegistryName();
        return registryName != null && registryName.func_110623_a().contains("bucket");
    }

    public static class ItemIdentifier {
        ResourceLocation location;
        int metadata;

        public ItemIdentifier(ResourceLocation location, int metadata) {
            this.location = location;
            this.metadata = metadata;
        }

        public ItemIdentifier(ItemStack object) {
            this.location = object.func_77973_b().getRegistryName();
            this.metadata = object.func_77952_i();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ItemIdentifier)) {
                return false;
            }
            ItemIdentifier identifier = (ItemIdentifier)o;
            return this.metadata == identifier.metadata && Objects.equals(this.location, identifier.location);
        }

        public int hashCode() {
            return Objects.hash(this.location, this.metadata);
        }

        public String toString() {
            return this.location.toString() + "@" + this.metadata;
        }
    }
}

