/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.compat;

import com.google.common.base.Function;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import net.blay09.mods.cookingforblockheads.block.BlockMilkJar;
import net.blay09.mods.cookingforblockheads.block.BlockToaster;
import net.blay09.mods.cookingforblockheads.tile.TileMilkJar;
import net.blay09.mods.cookingforblockheads.tile.TileToaster;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TheOneProbeAddon
implements Function<ITheOneProbe, Void> {
    @Nullable
    public Void apply(@Nullable ITheOneProbe top) {
        if (top != null) {
            top.registerProvider((IProbeInfoProvider)new ProbeInfoProvider());
        }
        return null;
    }

    @Nullable
    private static <T extends TileEntity> T tryGetTileEntity(World world, BlockPos pos, Class<T> tileClass) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null && tileClass.isAssignableFrom(tileEntity.getClass())) {
            return (T)tileEntity;
        }
        return null;
    }

    public static class ProbeInfoProvider
    implements IProbeInfoProvider {
        public String getID() {
            return "cookingforblockheads";
        }

        public void addProbeInfo(ProbeMode mode, IProbeInfo info, EntityPlayer player, World world, IBlockState state, IProbeHitData data) {
            TileToaster tileEntity;
            if (state.func_177230_c() instanceof BlockMilkJar) {
                TileMilkJar tileEntity2 = (TileMilkJar)TheOneProbeAddon.tryGetTileEntity(world, data.getPos(), TileMilkJar.class);
                if (tileEntity2 != null) {
                    this.addMilkJarInfo(tileEntity2, mode, info);
                }
            } else if (state.func_177230_c() instanceof BlockToaster && (tileEntity = (TileToaster)TheOneProbeAddon.tryGetTileEntity(world, data.getPos(), TileToaster.class)) != null) {
                this.addToasterInfo(tileEntity, mode, info);
            }
        }

        private void addMilkJarInfo(TileMilkJar tileEntity, ProbeMode mode, IProbeInfo info) {
            info.text(String.format("Milk Stored: %d/%d", (int)tileEntity.getMilkAmount(), (int)tileEntity.getMilkCapacity()));
        }

        private void addToasterInfo(TileToaster tileEntity, ProbeMode mode, IProbeInfo info) {
            if (tileEntity.isActive()) {
                info.text(String.format("Toasting... (%s)", (int)(tileEntity.getToastProgress() * 100.0f)) + "%");
                info.progress((int)(tileEntity.getToastProgress() * 100.0f), 100);
            }
        }
    }
}

