/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.client.render;

import net.blay09.mods.cookingforblockheads.client.render.RenderUtils;
import net.blay09.mods.cookingforblockheads.tile.TileCounter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.IItemHandler;

public class CounterRenderer
extends TileEntitySpecialRenderer<TileCounter> {
    public static IBakedModel[][] models;
    public static IBakedModel[][] modelsFlipped;
    private static final float[] doorOriginsX;
    private static final float[] doorOriginsZ;

    public void render(TileCounter tileEntity, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (!tileEntity.func_145830_o()) {
            return;
        }
        BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
        RenderItem itemRenderer = Minecraft.func_71410_x().func_175599_af();
        EnumFacing facing = tileEntity.getFacing();
        EnumDyeColor blockColor = tileEntity.getColor();
        float blockAngle = RenderUtils.getFacingAngle(tileEntity.getFacing());
        float doorAngle = tileEntity.getDoorAnimator().getRenderAngle(partialTicks);
        boolean isFlipped = tileEntity.isFlipped();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        float doorOriginX = doorOriginsX[facing.func_176736_b()];
        float doorOriginZ = doorOriginsZ[facing.func_176736_b()];
        float doorDirection = -1.0f;
        if (isFlipped) {
            if (facing.func_176740_k() == EnumFacing.Axis.X) {
                doorOriginZ = 1.0f - doorOriginZ;
            } else {
                doorOriginX = 1.0f - doorOriginX;
            }
            doorDirection = 1.0f;
        }
        GlStateManager.func_179109_b((float)doorOriginX, (float)0.0f, (float)doorOriginZ);
        GlStateManager.func_179114_b((float)(doorDirection * (float)Math.toDegrees(doorAngle)), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)(-doorOriginX), (float)0.0f, (float)(-doorOriginZ));
        this.func_147499_a(TextureMap.field_110575_b);
        IBakedModel model = isFlipped ? modelsFlipped[facing.func_176736_b()][blockColor.func_176765_a()] : models[tileEntity.getFacing().func_176736_b()][blockColor.func_176765_a()];
        dispatcher.func_175019_b().func_178262_a(model, 1.0f, 1.0f, 1.0f, 1.0f);
        GlStateManager.func_179121_F();
        if (doorAngle > 0.0f) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
            GlStateManager.func_179114_b((float)blockAngle, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)0.3f, (float)0.3f, (float)0.3f);
            float topY = 0.35f;
            IItemHandler itemHandler = tileEntity.getItemHandler();
            for (int i = itemHandler.getSlots() - 1; i >= 0; --i) {
                ItemStack itemStack = itemHandler.getStackInSlot(i);
                if (itemStack.func_190926_b()) continue;
                int rowIndex = i % 13;
                float offsetX = 0.7f;
                float spacing = 0.175f;
                if (rowIndex / 9 > 0) {
                    offsetX -= 0.2f;
                    spacing *= 2.0f;
                }
                float offsetY = topY - (float)(i / 13) * 1.25f;
                float offsetZ = 0.5f - (float)(rowIndex / 9) * 0.9f;
                RenderUtils.renderItem(itemRenderer, itemStack, offsetX -= (float)(rowIndex % 9) * spacing, offsetY, offsetZ, 45.0f, 0.0f, 1.0f, 0.0f);
            }
            GlStateManager.func_179121_F();
        }
    }

    static {
        doorOriginsX = new float[]{0.15625f, 0.09375f, 0.84375f, 0.90625f};
        doorOriginsZ = new float[]{0.90625f, 0.15625f, 0.09375f, 0.84375f};
    }
}

