/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.block;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.blay09.mods.cookingforblockheads.api.ToastHandler;
import net.blay09.mods.cookingforblockheads.api.ToastOutputHandler;
import net.blay09.mods.cookingforblockheads.block.BlockKitchen;
import net.blay09.mods.cookingforblockheads.registry.CookingRegistry;
import net.blay09.mods.cookingforblockheads.tile.TileToaster;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockToaster
extends BlockKitchen {
    public static final String name = "toaster";
    public static final ResourceLocation registryName = new ResourceLocation("cookingforblockheads", "toaster");
    private static final AxisAlignedBB BOUNDING_BOX = new AxisAlignedBB(0.275, 0.0, 0.275, 0.725, 0.4, 0.725);
    private static final PropertyBool ACTIVE = PropertyBool.func_177716_a((String)"active");

    public BlockToaster() {
        super(Material.field_151573_f);
        this.func_149663_c(registryName.toString());
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149711_c(2.5f);
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, ACTIVE});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileToaster) {
            return state.func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(((TileToaster)tileEntity).isActive()));
        }
        return state;
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOX;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileToaster) {
            TileToaster tileToaster = (TileToaster)tileEntity;
            ItemStack heldItem = player.func_184586_b(hand);
            if (heldItem.func_190926_b() || !tileToaster.getItemHandler().getStackInSlot(0).func_190926_b() && !tileToaster.getItemHandler().getStackInSlot(1).func_190926_b()) {
                if (!(tileToaster.isActive() || tileToaster.getItemHandler().getStackInSlot(0).func_190926_b() && tileToaster.getItemHandler().getStackInSlot(1).func_190926_b())) {
                    tileToaster.setActive(!tileToaster.isActive());
                }
            } else {
                ToastHandler toastHandler = CookingRegistry.getToastHandler(heldItem);
                if (toastHandler != null) {
                    ItemStack output;
                    ItemStack itemStack = output = toastHandler instanceof ToastOutputHandler ? ((ToastOutputHandler)toastHandler).getToasterOutput(heldItem) : ItemStack.field_190927_a;
                    if (!output.func_190926_b()) {
                        for (int i = 0; i < tileToaster.getItemHandler().getSlots(); ++i) {
                            if (!tileToaster.getItemHandler().getStackInSlot(i).func_190926_b()) continue;
                            tileToaster.getItemHandler().setStackInSlot(i, heldItem.func_77979_a(1));
                            return true;
                        }
                        return true;
                    }
                }
            }
        }
        return true;
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileToaster();
    }

    @Override
    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        super.func_190948_a(stack, world, tooltip, advanced);
        for (String s : I18n.func_135052_a((String)("tooltip." + registryName + ".description"), (Object[])new Object[0]).split("\\\\n")) {
            tooltip.add(TextFormatting.GRAY + s);
        }
    }

    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        TileToaster tileEntity = (TileToaster)world.func_175625_s(pos);
        if (tileEntity != null && tileEntity.isActive() && rand.nextFloat() < tileEntity.getToastProgress()) {
            double x = (float)pos.func_177958_n() + 0.5f + (rand.nextFloat() - 0.5f) * 0.25f;
            double y = (float)pos.func_177956_o() + 0.2f + rand.nextFloat() * 6.0f / 16.0f;
            double z = (float)pos.func_177952_p() + 0.5f + (rand.nextFloat() - 0.5f) * 0.25f;
            world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x, y, z, 0.0, 0.0, 0.0, new int[0]);
        }
    }
}

