/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.block;

import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.blay09.mods.cookingforblockheads.CookingForBlockheads;
import net.blay09.mods.cookingforblockheads.ItemUtils;
import net.blay09.mods.cookingforblockheads.block.BlockKitchen;
import net.blay09.mods.cookingforblockheads.tile.TileCounter;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class BlockCounter
extends BlockKitchen {
    public static final String name = "counter";
    public static final ResourceLocation registryName = new ResourceLocation("cookingforblockheads", "counter");
    public static final PropertyEnum<ModelPass> PASS = PropertyEnum.func_177709_a((String)"pass", ModelPass.class);

    public BlockCounter() {
        super(Material.field_151576_e);
        this.func_149663_c(registryName.toString());
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, FLIPPED, PASS, COLOR});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileCounter) {
            return state.func_177226_a((IProperty)COLOR, (Comparable)((TileCounter)tileEntity).getColor());
        }
        return state;
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        EnumFacing facing;
        switch (meta & 7) {
            case 0: {
                facing = EnumFacing.EAST;
                break;
            }
            case 1: {
                facing = EnumFacing.WEST;
                break;
            }
            case 2: {
                facing = EnumFacing.SOUTH;
                break;
            }
            default: {
                facing = EnumFacing.NORTH;
            }
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing).func_177226_a((IProperty)FLIPPED, (Comparable)Boolean.valueOf((meta & 8) != 0));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        int meta;
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case EAST: {
                meta = 0;
                break;
            }
            case WEST: {
                meta = 1;
                break;
            }
            case SOUTH: {
                meta = 2;
                break;
            }
            default: {
                meta = 3;
            }
        }
        if (((Boolean)state.func_177229_b((IProperty)FLIPPED)).booleanValue()) {
            meta |= 8;
        }
        return meta;
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileCounter();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileCounter tileCounter;
        ItemStack heldItem = player.func_184586_b(hand);
        if (!heldItem.func_190926_b() && heldItem.func_77973_b() == Items.field_151100_aR) {
            if (this.recolorBlock(world, pos, facing, EnumDyeColor.func_176766_a((int)heldItem.func_77952_i()))) {
                heldItem.func_190918_g(1);
            }
            return true;
        }
        if (facing == state.func_177229_b((IProperty)FACING) && (tileCounter = (TileCounter)world.func_175625_s(pos)) != null) {
            if (player.func_70093_af()) {
                tileCounter.getDoorAnimator().toggleForcedOpen();
                return true;
            }
            if (!heldItem.func_190926_b() && tileCounter.getDoorAnimator().isForcedOpen()) {
                heldItem = ItemHandlerHelper.insertItemStacked((IItemHandler)tileCounter.getItemHandler(), (ItemStack)heldItem, (boolean)false);
                player.func_184611_a(hand, heldItem);
                return true;
            }
        }
        if (!world.field_72995_K) {
            if (facing == EnumFacing.UP && !heldItem.func_190926_b()) {
                return false;
            }
            player.openGui((Object)CookingForBlockheads.instance, 6, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    @Override
    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState state = super.func_180642_a(world, pos, side, hitX, hitY, hitZ, meta, placer);
        return state.func_177226_a((IProperty)FLIPPED, (Comparable)Boolean.valueOf(this.shouldBePlacedFlipped(pos, (EnumFacing)state.func_177229_b((IProperty)FACING), placer)));
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileCounter tileEntity = (TileCounter)world.func_175625_s(pos);
        if (tileEntity != null) {
            ItemUtils.dropItemHandlerItems(world, pos, tileEntity.getItemHandler());
        }
        super.func_180663_b(world, pos, state);
    }

    @Override
    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        super.func_190948_a(stack, world, tooltip, advanced);
        for (String s : I18n.func_135052_a((String)("tooltip." + registryName + ".description"), (Object[])new Object[0]).split("\\\\n")) {
            tooltip.add(TextFormatting.GRAY + s);
        }
    }

    public boolean recolorBlock(World world, BlockPos pos, EnumFacing side, EnumDyeColor color) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileCounter) {
            TileCounter tileCounter = (TileCounter)tileEntity;
            tileCounter.setColor(color);
        }
        return true;
    }

    public static enum ModelPass implements IStringSerializable
    {
        STATIC,
        DOOR,
        DOOR_FLIPPED;


        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

