/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.blay09.mods.cookingforblockheads.ItemUtils;
import net.blay09.mods.cookingforblockheads.api.IKitchenMultiBlock;
import net.blay09.mods.cookingforblockheads.api.capability.CapabilityKitchenConnector;
import net.blay09.mods.cookingforblockheads.api.capability.CapabilityKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.CapabilityKitchenSmeltingProvider;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenSmeltingProvider;
import net.blay09.mods.cookingforblockheads.api.capability.KitchenItemProvider;
import net.blay09.mods.cookingforblockheads.block.ModBlocks;
import net.blay09.mods.cookingforblockheads.registry.CookingRegistry;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class KitchenMultiBlock
implements IKitchenMultiBlock {
    private final Set<BlockPos> checkedPos = Sets.newHashSet();
    private final List<IKitchenItemProvider> itemProviderList = Lists.newArrayList();
    private final List<IKitchenSmeltingProvider> smeltingProviderList = Lists.newArrayList();

    public KitchenMultiBlock(World world, BlockPos pos) {
        this.findNeighbourKitchenBlocks(world, pos);
    }

    private void findNeighbourKitchenBlocks(World world, BlockPos pos) {
        for (int i = 0; i <= 5; ++i) {
            EnumFacing dir = EnumFacing.func_82600_a((int)i);
            BlockPos position = pos.func_177972_a(dir);
            if (this.checkedPos.contains(position)) continue;
            this.checkedPos.add(position);
            TileEntity tileEntity = world.func_175625_s(position);
            if (tileEntity != null) {
                IKitchenSmeltingProvider smeltingProvider;
                IKitchenItemProvider itemProvider = (IKitchenItemProvider)tileEntity.getCapability(CapabilityKitchenItemProvider.CAPABILITY, null);
                if (itemProvider != null) {
                    this.itemProviderList.add(itemProvider);
                }
                if ((smeltingProvider = (IKitchenSmeltingProvider)tileEntity.getCapability(CapabilityKitchenSmeltingProvider.CAPABILITY, null)) != null) {
                    this.smeltingProviderList.add(smeltingProvider);
                }
                if (itemProvider == null && smeltingProvider == null && !tileEntity.hasCapability(CapabilityKitchenConnector.CAPABILITY, null)) continue;
                this.findNeighbourKitchenBlocks(world, position);
                continue;
            }
            IBlockState state = world.func_180495_p(position);
            if (state.func_177230_c() != ModBlocks.kitchenFloor) continue;
            this.findNeighbourKitchenBlocks(world, position);
        }
    }

    @Override
    public List<IKitchenItemProvider> getItemProviders(InventoryPlayer playerInventory) {
        ArrayList sourceInventories = Lists.newArrayList();
        sourceInventories.addAll(this.itemProviderList);
        sourceInventories.add(new KitchenItemProvider((IItemHandler)new InvWrapper((IInventory)playerInventory)));
        return sourceInventories;
    }

    @Override
    public ItemStack smeltItem(ItemStack itemStack, int count) {
        IKitchenSmeltingProvider provider;
        ItemStack restStack = itemStack.func_77946_l().func_77979_a(count);
        Iterator<IKitchenSmeltingProvider> iterator = this.smeltingProviderList.iterator();
        while (iterator.hasNext() && !(restStack = (provider = iterator.next()).smeltItem(restStack)).func_190926_b()) {
        }
        itemStack.func_190918_g(count - (!restStack.func_190926_b() ? restStack.func_190916_E() : 0));
        return itemStack;
    }

    public void trySmelt(ItemStack outputItem, ItemStack inputItem, EntityPlayer player, boolean stack) {
        if (inputItem.func_190926_b()) {
            return;
        }
        boolean requireBucket = CookingRegistry.doesItemRequireBucketForCrafting(outputItem);
        List<IKitchenItemProvider> inventories = this.getItemProviders(player.field_71071_by);
        for (IKitchenItemProvider itemProvider : inventories) {
            itemProvider.resetSimulation();
            for (int i = 0; i < itemProvider.getSlots(); ++i) {
                int smeltCount;
                ItemStack restStack;
                ItemStack itemStack = itemProvider.getStackInSlot(i);
                if (!ItemUtils.areItemStacksEqualWithWildcard(itemStack, inputItem) || (restStack = itemProvider.useItemStack(i, smeltCount = Math.min(itemStack.func_190916_E(), stack ? inputItem.func_77976_d() : 1), false, inventories, requireBucket)).func_190926_b()) continue;
                if (!(restStack = this.smeltItem(restStack, smeltCount)).func_190926_b() && !player.field_71071_by.func_70441_a(restStack = itemProvider.returnItemStack(restStack))) {
                    player.func_71019_a(restStack, false);
                }
                player.field_71070_bA.func_75142_b();
                return;
            }
        }
    }

    @Override
    public boolean hasSmeltingProvider() {
        return this.smeltingProviderList.size() > 0;
    }
}

