/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import sonar.core.SonarCore;
import sonar.core.helpers.NBTHelper;
import sonar.flux.FluxNetworks;
import sonar.flux.api.network.IFluxNetwork;
import sonar.flux.api.network.INetworkStatistics;

public class PacketNetworkStatistics
implements IMessage {
    public int networkID;
    public INetworkStatistics stats;
    public NBTTagCompound received;

    public PacketNetworkStatistics() {
    }

    public PacketNetworkStatistics(int networkID, INetworkStatistics stats) {
        this.networkID = networkID;
        this.stats = stats;
    }

    public void fromBytes(ByteBuf buf) {
        this.networkID = buf.readInt();
        this.received = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.networkID);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.stats.writeData(new NBTTagCompound(), NBTHelper.SyncType.SAVE));
    }

    public static class Handler
    implements IMessageHandler<PacketNetworkStatistics, IMessage> {
        public IMessage onMessage(PacketNetworkStatistics message, MessageContext ctx) {
            if (ctx.side == Side.CLIENT) {
                SonarCore.proxy.getThreadListener(ctx.side).func_152344_a(() -> {
                    String playerName = SonarCore.proxy.getPlayerEntity(ctx).func_70005_c_();
                    IFluxNetwork common = FluxNetworks.getClientCache().getNetwork(message.networkID);
                    if (!common.isFakeNetwork()) {
                        common.getStatistics().readData(message.received, NBTHelper.SyncType.SAVE);
                    }
                });
            }
            return null;
        }
    }
}

