/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.network;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import sonar.core.api.utils.BlockCoords;
import sonar.core.helpers.SonarHelper;
import sonar.core.utils.CustomColour;
import sonar.flux.FluxNetworks;
import sonar.flux.api.AccessType;
import sonar.flux.api.AdditionType;
import sonar.flux.api.FluxError;
import sonar.flux.api.RemovalType;
import sonar.flux.api.network.IFluxNetwork;
import sonar.flux.api.network.PlayerAccess;
import sonar.flux.client.GuiTypeMessage;
import sonar.flux.common.containers.ContainerFlux;
import sonar.flux.common.tileentity.TileEntityFlux;
import sonar.flux.connection.FluxHelper;
import sonar.flux.network.PacketFluxButton;
import sonar.flux.network.PacketFluxError;
import sonar.flux.network.PacketType;

public class PacketHelper {
    public static void sendPacketToServer(PacketType type, TileEntityFlux source, NBTTagCompound packetTag) {
        BlockCoords coords = source.getCoords();
        FluxNetworks.network.sendToServer((IMessage)new PacketFluxButton(type, coords.getBlockPos(), packetTag, coords.getDimension()));
    }

    public static void sendPacketToServer(PacketType type, BlockCoords coords, NBTTagCompound packetTag) {
        FluxNetworks.network.sendToServer((IMessage)new PacketFluxButton(type, coords.getBlockPos(), packetTag, coords.getDimension()));
    }

    public static NBTTagCompound createNetworkSetPacket(int networkID) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("networkID", networkID);
        return tag;
    }

    public static IMessage doNetworkSetPacket(TileEntityFlux source, EntityPlayer player, NBTTagCompound packetTag) {
        int networkID = packetTag.func_74762_e("networkID");
        if (source.getNetwork().getNetworkID() == networkID) {
            return null;
        }
        IFluxNetwork network = FluxNetworks.getServerCache().getNetwork(networkID);
        if (!network.isFakeNetwork()) {
            if (network.getPlayerAccess(player).canConnect()) {
                source.getNetwork().removeConnection(source, RemovalType.REMOVE);
                network.addConnection(source, AdditionType.ADD);
            } else {
                return new PacketFluxError(source.func_174877_v(), FluxError.ACCESS_DENIED);
            }
        }
        return null;
    }

    public static NBTTagCompound createNetworkEditPacket(int networkID, String networkName, CustomColour networkColour, AccessType accessType) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("networkID", networkID);
        tag.func_74778_a("networkName", networkName);
        tag.func_74768_a("colourRGB", networkColour.getRGB());
        tag.func_74768_a("accessType", accessType.ordinal());
        return tag;
    }

    public static IMessage doNetworkEditPacket(TileEntityFlux source, EntityPlayer player, NBTTagCompound packetTag) {
        int networkID = packetTag.func_74762_e("networkID");
        String newName = packetTag.func_74779_i("networkName");
        CustomColour colour = new CustomColour(packetTag.func_74762_e("colourRGB"));
        AccessType access = AccessType.values()[packetTag.func_74762_e("accessType")];
        IFluxNetwork common = FluxNetworks.getServerCache().getNetwork(networkID);
        if (!common.isFakeNetwork()) {
            if (common.getPlayerAccess(player).canEdit()) {
                common.setNetworkName(newName);
                common.setAccessType(access);
                common.setCustomColour(colour);
                common.markDirty();
            } else {
                return new PacketFluxError(source.func_174877_v(), FluxError.EDIT_NETWORK);
            }
        }
        return null;
    }

    public static NBTTagCompound createNetworkCreationPacket(String networkName, CustomColour networkColour, AccessType accessType) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("networkName", networkName);
        tag.func_74768_a("colourRGB", networkColour.getRGB());
        tag.func_74768_a("accessType", accessType.ordinal());
        return tag;
    }

    public static IMessage doNetworkCreationPacket(TileEntityFlux source, EntityPlayer player, NBTTagCompound packetTag) {
        String newName = packetTag.func_74779_i("networkName");
        CustomColour colour = new CustomColour(packetTag.func_74762_e("colourRGB"));
        AccessType access = AccessType.values()[packetTag.func_74762_e("accessType")];
        if (FluxNetworks.getServerCache().hasSpaceForNetwork(player)) {
            IFluxNetwork iFluxNetwork = FluxNetworks.getServerCache().createNetwork(player, newName, colour, access);
        }
        return new PacketFluxError(source.func_174877_v(), FluxError.NOT_OWNER);
    }

    public static NBTTagCompound createNetworkDeletePacket(int networkID) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("networkID", networkID);
        return tag;
    }

    public static IMessage doNetworkDeletePacket(TileEntityFlux source, EntityPlayer player, NBTTagCompound packetTag) {
        int networkID = packetTag.func_74762_e("networkID");
        IFluxNetwork toDelete = FluxNetworks.getServerCache().getNetwork(networkID);
        if (!toDelete.isFakeNetwork() && toDelete instanceof IFluxNetwork) {
            if (toDelete.getPlayerAccess(player).canDelete()) {
                FluxNetworks.getServerCache().onPlayerRemoveNetwork(FluxHelper.getOwnerUUID(player), toDelete);
            } else {
                return new PacketFluxError(source.func_174877_v(), FluxError.NOT_OWNER);
            }
        }
        return null;
    }

    public static NBTTagCompound createSetPriorityPacket(int priority) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("priority", priority);
        return tag;
    }

    public static IMessage doSetPriorityPacket(TileEntityFlux source, EntityPlayer player, NBTTagCompound packetTag) {
        int priority = packetTag.func_74762_e("priority");
        if (!source.canAccess(player).canEdit()) {
            return new PacketFluxError(source.func_174877_v(), FluxError.ACCESS_DENIED);
        }
        source.priority.setObject((Object)priority);
        return null;
    }

    public static NBTTagCompound createSetTransferLimitPacket(int transferLimit) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74772_a("transferLimit", (long)transferLimit);
        return tag;
    }

    public static IMessage doSetTransferLimitPacket(TileEntityFlux source, EntityPlayer player, NBTTagCompound packetTag) {
        long priority = packetTag.func_74763_f("transferLimit");
        if (!source.canAccess(player).canEdit()) {
            return new PacketFluxError(source.func_174877_v(), FluxError.ACCESS_DENIED);
        }
        source.limit.setObject((Object)priority);
        return null;
    }

    public static NBTTagCompound createAddPlayerPacket(int networkID, String playerName, PlayerAccess playerAccess) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("networkID", networkID);
        tag.func_74778_a("playerName", playerName);
        tag.func_74768_a("playerAccess", playerAccess.ordinal());
        return tag;
    }

    public static IMessage doAddPlayerPacket(TileEntityFlux source, EntityPlayer player, NBTTagCompound packetTag) {
        int networkID = packetTag.func_74762_e("networkID");
        String playerName = packetTag.func_74779_i("playerName");
        PlayerAccess access = PlayerAccess.values()[packetTag.func_74762_e("playerAccess")];
        GameProfile profile = SonarHelper.getGameProfileForUsername((String)playerName);
        if (profile == null || profile.getId() == null) {
            return new PacketFluxError(source.func_174877_v(), FluxError.INVALID_USER);
        }
        UUID newPlayer = profile.getId();
        IFluxNetwork common = FluxNetworks.getServerCache().getNetwork(networkID);
        if (!common.isFakeNetwork() && common instanceof IFluxNetwork) {
            if (common.getPlayerAccess(player).canEdit()) {
                IFluxNetwork network = common;
                network.addPlayerAccess(newPlayer, access);
                network.markDirty();
            } else {
                return new PacketFluxError(source.func_174877_v(), FluxError.EDIT_NETWORK);
            }
        }
        return null;
    }

    public static NBTTagCompound createRemovePlayerPacket(int networkID, UUID playerRemoved, PlayerAccess playerAccess) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("networkID", networkID);
        tag.func_186854_a("playerRemoved", playerRemoved);
        tag.func_74768_a("playerAccess", playerAccess.ordinal());
        return tag;
    }

    public static IMessage doRemovePlayerPacket(TileEntityFlux source, EntityPlayer player, NBTTagCompound packetTag) {
        int networkID = packetTag.func_74762_e("networkID");
        UUID playerRemoved = packetTag.func_186857_a("playerRemoved");
        PlayerAccess access = PlayerAccess.values()[packetTag.func_74762_e("playerAccess")];
        IFluxNetwork common = FluxNetworks.getServerCache().getNetwork(networkID);
        if (!common.isFakeNetwork() && common instanceof IFluxNetwork) {
            if (common.getPlayerAccess(player).canEdit()) {
                IFluxNetwork network = common;
                network.removePlayerAccess(playerRemoved, access);
                network.markDirty();
            } else {
                return new PacketFluxError(source.func_174877_v(), FluxError.EDIT_NETWORK);
            }
        }
        return null;
    }

    public static NBTTagCompound createChangePlayerPacket(int networkID, UUID playerChanged, PlayerAccess playerAccess) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("networkID", networkID);
        tag.func_186854_a("playerChanged", playerChanged);
        tag.func_74768_a("playerAccess", playerAccess.ordinal());
        return tag;
    }

    public static IMessage doChangePlayerPacket(TileEntityFlux source, EntityPlayer player, NBTTagCompound packetTag) {
        int networkID = packetTag.func_74762_e("networkID");
        UUID playerChanged = packetTag.func_186857_a("playerChanged");
        if (playerChanged != null) {
            PlayerAccess access = PlayerAccess.values()[packetTag.func_74762_e("playerAccess")];
            access = (PlayerAccess)SonarHelper.incrementEnum((Enum)access, (Enum[])PlayerAccess.values());
            while (access.canDelete()) {
                access = (PlayerAccess)SonarHelper.incrementEnum((Enum)access, (Enum[])PlayerAccess.values());
            }
            IFluxNetwork common = FluxNetworks.getServerCache().getNetwork(networkID);
            if (!common.isFakeNetwork() && common instanceof IFluxNetwork) {
                if (common.getPlayerAccess(player).canEdit()) {
                    if (!FluxHelper.getOwnerUUID(player).equals(playerChanged)) {
                        IFluxNetwork network = common;
                        network.addPlayerAccess(playerChanged, access);
                        network.markDirty();
                    }
                } else {
                    return new PacketFluxError(source.func_174877_v(), FluxError.EDIT_NETWORK);
                }
            }
        }
        return new PacketFluxError(source.func_174877_v(), FluxError.INVALID_USER);
    }

    public static NBTTagCompound createDisconnectPacket(int networkID) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("networkID", networkID);
        return tag;
    }

    public static IMessage doDisconnectPacket(TileEntityFlux source, EntityPlayer player, NBTTagCompound packetTag) {
        IFluxNetwork network;
        int networkID = packetTag.func_74762_e("networkID");
        if (networkID == (network = source.getNetwork()).getNetworkID() && network.getPlayerAccess(player).canConnect() && source.playerUUID.getUUID().equals(FluxHelper.getOwnerUUID(player))) {
            network.removeConnection(source, RemovalType.REMOVE);
        }
        return null;
    }

    public static NBTTagCompound createStateChangePacket(GuiTypeMessage guiType) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("guiType", guiType.ordinal());
        return tag;
    }

    public static IMessage doStateChangePacket(TileEntityFlux source, EntityPlayer player, NBTTagCompound packetTag) {
        GuiTypeMessage state = GuiTypeMessage.values()[packetTag.func_74762_e("guiType")];
        Container container = player.field_71070_bA;
        if (container != null && container instanceof ContainerFlux) {
            ((ContainerFlux)container).switchState(state);
        }
        return null;
    }
}

