/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.network;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import sonar.core.SonarCore;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.helpers.NBTHelper;
import sonar.flux.FluxNetworks;
import sonar.flux.api.network.IFluxCommon;
import sonar.flux.api.network.IFluxNetwork;
import sonar.flux.connection.BasicFluxNetwork;

public class PacketFluxNetworkList
implements IMessage {
    public ArrayList<? extends IFluxNetwork> networks;
    public boolean update;

    public PacketFluxNetworkList() {
    }

    public PacketFluxNetworkList(ArrayList<? extends IFluxNetwork> toSend, boolean update) {
        this.networks = toSend;
        this.update = update;
    }

    public void fromBytes(ByteBuf buf) {
        this.update = buf.readBoolean();
        NBTTagCompound compound = ByteBufUtils.readTag((ByteBuf)buf);
        NBTTagList list = compound.func_150295_c("nets", 10);
        ArrayList<INBTSyncable> networks = new ArrayList<INBTSyncable>();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            networks.add(NBTHelper.instanceNBTSyncable(BasicFluxNetwork.class, (NBTTagCompound)list.func_150305_b(i)));
        }
        this.networks = networks;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.update);
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        for (IFluxCommon iFluxCommon : this.networks) {
            if (iFluxCommon == null || iFluxCommon.isFakeNetwork() || iFluxCommon.getNetworkID() == -1) continue;
            list.func_74742_a((NBTBase)iFluxCommon.writeData(new NBTTagCompound(), NBTHelper.SyncType.SAVE));
        }
        tag.func_74782_a("nets", (NBTBase)list);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
    }

    public static class Handler
    implements IMessageHandler<PacketFluxNetworkList, IMessage> {
        public IMessage onMessage(PacketFluxNetworkList message, MessageContext ctx) {
            if (ctx.side == Side.CLIENT) {
                SonarCore.proxy.getThreadListener(ctx.side).func_152344_a(() -> FluxNetworks.getClientCache().updateNetworksFromPacket(message.networks, message.update));
            }
            return null;
        }
    }
}

