/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.network;

import io.netty.buffer.ByteBuf;
import javax.xml.ws.Holder;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import sonar.core.SonarCore;
import sonar.core.network.PacketCoords;
import sonar.flux.common.tileentity.TileEntityFlux;
import sonar.flux.network.PacketType;

public class PacketFluxButton
extends PacketCoords {
    public PacketType type;
    public NBTTagCompound packetTag;
    public int dimension;

    public PacketFluxButton() {
    }

    public PacketFluxButton(PacketType type, BlockPos pos, NBTTagCompound packetTag) {
        super(pos);
        this.type = type;
        this.packetTag = packetTag;
    }

    public PacketFluxButton(PacketType type, BlockPos pos, NBTTagCompound packetTag, int dimension) {
        this(type, pos, packetTag);
        this.dimension = dimension;
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.type = PacketType.values()[buf.readInt()];
        this.dimension = buf.readInt();
        this.packetTag = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.type.ordinal());
        buf.writeInt(this.dimension);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.packetTag);
    }

    public static class Handler
    implements IMessageHandler<PacketFluxButton, IMessage> {
        public IMessage onMessage(PacketFluxButton message, MessageContext ctx) {
            Holder newMessage = new Holder();
            SonarCore.proxy.getThreadListener(ctx.side).func_152344_a(() -> {
                EntityPlayer player = SonarCore.proxy.getPlayerEntity(ctx);
                if (player != null && player.func_130014_f_() != null) {
                    TileEntity te;
                    World world = player.func_130014_f_();
                    if (world.field_73011_w.getDimension() != message.dimension) {
                        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
                        world = server.func_71218_a(message.dimension);
                    }
                    if ((te = world.func_175625_s(message.pos)) instanceof TileEntityFlux) {
                        TileEntityFlux source = (TileEntityFlux)te;
                        newMessage.value = message.type.doPacket(source, player, message.packetTag);
                    }
                }
            });
            return (IMessage)newMessage.value;
        }
    }
}

