/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.network;

import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.storage.WorldSavedData;
import sonar.core.helpers.NBTHelper;
import sonar.core.utils.CustomColour;
import sonar.flux.FluxEvents;
import sonar.flux.FluxNetworks;
import sonar.flux.api.AccessType;
import sonar.flux.api.network.IFluxNetwork;
import sonar.flux.connection.BasicFluxNetwork;
import sonar.flux.network.FluxNetworkCache;

public class NetworkData
extends WorldSavedData {
    public static final String IDENTIFIER = "sonar.flux.networks.configurations";
    public static String TAG_LIST = "networks";
    public static String UNIQUE_ID = "uniqueID";
    public static String NETWORK_ID = "id";
    public static String COLOUR = "colour";
    public static String OWNER_UUID = "ownerUUID";
    public static String CACHE_PLAYER = "cachePName";
    public static String NETWORK_NAME = "name";
    public static String ACCESS = "access";
    public static String PLAYER_LIST = "playerList";

    public NetworkData(String name) {
        super(name);
    }

    public NetworkData() {
        this(IDENTIFIER);
    }

    public void func_76184_a(NBTTagCompound nbt) {
        FluxNetworkCache cache = FluxNetworks.getServerCache();
        cache.uniqueID = nbt.func_74762_e(UNIQUE_ID);
        if (nbt.func_74764_b(TAG_LIST)) {
            NBTTagList list = nbt.func_150295_c(TAG_LIST, 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound tag = list.func_150305_b(i);
                int networkID = tag.func_74762_e(NETWORK_ID);
                String networkName = tag.func_74779_i(NETWORK_NAME);
                UUID ownerUUID = tag.func_186857_a(OWNER_UUID);
                String cachedPlayer = tag.func_74779_i(CACHE_PLAYER);
                CustomColour colour = (CustomColour)NBTHelper.instanceNBTSyncable(CustomColour.class, (NBTTagCompound)tag.func_74775_l(COLOUR));
                AccessType type = AccessType.valueOf(tag.func_74779_i(ACCESS));
                BasicFluxNetwork network = new BasicFluxNetwork(networkID, ownerUUID, networkName, colour, type);
                network.getPlayers().readData(tag.func_74775_l(PLAYER_LIST), NBTHelper.SyncType.SAVE);
                cache.addNetwork(network);
                FluxEvents.logLoadedNetwork(network);
            }
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound nbt) {
        FluxNetworkCache cache = FluxNetworks.getServerCache();
        nbt.func_74768_a(UNIQUE_ID, cache.uniqueID);
        if (((ArrayList)cache.getAllNetworks()).size() > 0) {
            NBTTagList list = new NBTTagList();
            for (IFluxNetwork network : FluxNetworks.getServerCache().getAllNetworks()) {
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74768_a(NETWORK_ID, network.getNetworkID());
                tag.func_186854_a(OWNER_UUID, network.getOwnerUUID());
                tag.func_74778_a(CACHE_PLAYER, network.getCachedPlayerName());
                tag.func_74778_a(NETWORK_NAME, network.getNetworkName());
                tag.func_74782_a(COLOUR, (NBTBase)network.getNetworkColour().writeData(new NBTTagCompound(), NBTHelper.SyncType.SAVE));
                tag.func_74778_a(ACCESS, network.getAccessType().name());
                tag.func_74782_a(PLAYER_LIST, (NBTBase)network.getPlayers().writeData(new NBTTagCompound(), NBTHelper.SyncType.SAVE));
                list.func_74742_a((NBTBase)tag);
            }
            nbt.func_74782_a(TAG_LIST, (NBTBase)list);
            FluxNetworks.logger.debug("ALL " + list.func_74745_c() + " Networks were saved successfully");
        }
        return nbt;
    }

    public boolean func_76188_b() {
        return true;
    }
}

