/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.network;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.entity.player.EntityPlayer;
import sonar.flux.FluxNetworks;
import sonar.flux.api.network.IFluxNetwork;
import sonar.flux.api.network.IFluxNetworkCache;
import sonar.flux.connection.EmptyFluxNetwork;

public class ClientNetworkCache
implements IFluxNetworkCache {
    public HashMap<Integer, IFluxNetwork> networks = new HashMap();

    public void clearNetworks() {
        this.networks.clear();
    }

    @Override
    public IFluxNetwork getNetwork(int iD) {
        IFluxNetwork network = this.networks.get(iD);
        if (network != null && !network.isFakeNetwork()) {
            return network;
        }
        return EmptyFluxNetwork.INSTANCE;
    }

    public void updateNetworksFromPacket(ArrayList<? extends IFluxNetwork> packet, boolean updateEntireList) {
        if (updateEntireList) {
            packet.forEach((Consumer<? extends IFluxNetwork>)((Consumer<IFluxNetwork>)network -> this.readNetworkFromPacket((IFluxNetwork)network)));
        } else {
            HashMap newMap = new HashMap();
            packet.forEach((Consumer<? extends IFluxNetwork>)((Consumer<IFluxNetwork>)network -> newMap.put(network.getNetworkID(), network)));
            this.networks = newMap;
        }
    }

    public void readNetworkFromPacket(IFluxNetwork network) {
        IFluxNetwork storedNet = this.getNetwork(network.getNetworkID());
        if (storedNet == null || storedNet.isFakeNetwork()) {
            this.networks.put(network.getNetworkID(), network);
        } else {
            storedNet.updateNetworkFrom(network);
        }
    }

    @Override
    public List<IFluxNetwork> getAllowedNetworks(EntityPlayer player, boolean admin) {
        ArrayList<IFluxNetwork> available = new ArrayList<IFluxNetwork>();
        for (IFluxNetwork network : this.getAllNetworks()) {
            if (!network.getPlayerAccess(player).canConnect()) continue;
            available.add(network);
        }
        return available;
    }

    @Override
    public List<IFluxNetwork> getAllNetworks() {
        ArrayList<IFluxNetwork> available = new ArrayList<IFluxNetwork>();
        this.networks.values().forEach(net -> available.add((IFluxNetwork)net));
        return available;
    }

    public static ClientNetworkCache instance() {
        return FluxNetworks.getClientCache();
    }
}

