/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.connection;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.nbt.NBTTagCompound;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.helpers.NBTHelper;
import sonar.core.helpers.SonarHelper;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.ISyncableListener;
import sonar.core.network.sync.SyncEnum;
import sonar.core.network.sync.SyncNBTAbstract;
import sonar.core.network.sync.SyncTagType;
import sonar.core.network.sync.SyncUUID;
import sonar.core.network.sync.SyncableList;
import sonar.core.utils.CustomColour;
import sonar.flux.api.AccessType;
import sonar.flux.api.ClientFlux;
import sonar.flux.api.network.FluxPlayer;
import sonar.flux.api.network.FluxPlayersList;
import sonar.flux.api.network.IFluxCommon;
import sonar.flux.api.network.INetworkStatistics;
import sonar.flux.api.network.PlayerAccess;
import sonar.flux.network.NetworkStatistics;

public abstract class FluxNetworkCommon
implements IFluxCommon,
ISyncableListener {
    public SyncTagType.STRING cachedOwnerName = new SyncTagType.STRING(0);
    public SyncTagType.STRING networkName = new SyncTagType.STRING(1);
    public SyncTagType.INT networkID = new SyncTagType.INT(2);
    public SyncEnum<AccessType> accessType = new SyncEnum((Enum[])AccessType.values(), 3).setDefault((Enum)AccessType.PRIVATE);
    public SyncTagType.LONG maxStored = new SyncTagType.LONG(4);
    public SyncTagType.LONG energyStored = new SyncTagType.LONG(5);
    public SyncUUID ownerUUID = new SyncUUID(6);
    public SyncNBTAbstract<CustomColour> colour = new SyncNBTAbstract(CustomColour.class, 7);
    public NetworkStatistics networkStats = new NetworkStatistics();
    public ArrayList<ClientFlux> fluxConnections = new ArrayList();
    public FluxPlayersList players = new FluxPlayersList();
    public SyncableList parts = new SyncableList((ISyncableListener)this);

    public FluxNetworkCommon() {
        this.parts.addParts(new IDirtyPart[]{this.cachedOwnerName, this.networkName, this.networkID, this.accessType, this.maxStored, this.energyStored, this.ownerUUID, this.colour, this.networkStats, this.players});
        this.colour.setObject((INBTSyncable)new CustomColour(41, 94, 138));
    }

    public FluxNetworkCommon(int ID, UUID owner, String name, CustomColour networkColour, AccessType type) {
        this.parts.addParts(new IDirtyPart[]{this.cachedOwnerName, this.networkName, this.networkID, this.accessType, this.maxStored, this.energyStored, this.ownerUUID, this.colour, this.networkStats, this.players});
        this.colour.setObject((INBTSyncable)new CustomColour(41, 94, 138));
        this.ownerUUID.setObject(owner);
        this.networkID.setObject((Object)ID);
        GameProfile profile = SonarHelper.getProfileByUUID((UUID)owner);
        this.cachedOwnerName.setObject((Object)(profile != null ? profile.getName() : ""));
        this.networkName.setObject((Object)name);
        this.colour.setObject((INBTSyncable)networkColour);
        this.accessType.setObject((Enum)type);
        this.players.add(new FluxPlayer(owner, PlayerAccess.OWNER, (String)this.cachedOwnerName.getObject()));
    }

    @Override
    public AccessType getAccessType() {
        return (AccessType)this.accessType.getObject();
    }

    @Override
    public int getNetworkID() {
        return (Integer)this.networkID.getObject();
    }

    @Override
    public CustomColour getNetworkColour() {
        return (CustomColour)this.colour.getObject();
    }

    @Override
    public String getNetworkName() {
        return (String)this.networkName.getObject();
    }

    @Override
    public String getCachedPlayerName() {
        if (this.cachedOwnerName.getObject() == null || ((String)this.cachedOwnerName.getObject()).isEmpty()) {
            GameProfile profile = SonarHelper.getProfileByUUID((UUID)this.ownerUUID.getUUID());
            this.cachedOwnerName.setObject((Object)(profile != null ? profile.getName() : ""));
        }
        return (String)this.cachedOwnerName.getObject();
    }

    @Override
    public UUID getOwnerUUID() {
        return this.ownerUUID.getUUID();
    }

    @Override
    public INetworkStatistics getStatistics() {
        return this.networkStats;
    }

    @Override
    public long getEnergyAvailable() {
        return (Long)this.energyStored.getObject();
    }

    @Override
    public long getMaxEnergyStored() {
        return (Long)this.maxStored.getObject();
    }

    @Override
    public void setClientConnections(ArrayList<ClientFlux> flux) {
        this.fluxConnections = (ArrayList)flux.clone();
    }

    @Override
    public ArrayList<ClientFlux> getClientFluxConnection() {
        return this.fluxConnections;
    }

    @Override
    public boolean isFakeNetwork() {
        return false;
    }

    @Override
    public FluxPlayersList getPlayers() {
        return this.players;
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        NBTHelper.readSyncParts((NBTTagCompound)nbt, (NBTHelper.SyncType)type, (SyncableList)this.parts);
        this.players.readData(nbt, type);
    }

    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        NBTHelper.writeSyncParts((NBTTagCompound)nbt, (NBTHelper.SyncType)type, (SyncableList)this.parts, (boolean)false);
        this.players.writeData(nbt, type);
        return nbt;
    }
}

