/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.connection;

import cofh.redstoneflux.api.IEnergyConnection;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import sonar.core.SonarCore;
import sonar.core.api.SonarAPI;
import sonar.core.api.energy.EnergyType;
import sonar.core.api.energy.ISonarEnergyContainerHandler;
import sonar.core.api.energy.ISonarEnergyHandler;
import sonar.core.api.utils.ActionType;
import sonar.core.integration.SonarLoader;
import sonar.core.listener.ISonarListenable;
import sonar.core.listener.ListenerTally;
import sonar.core.listener.PlayerListener;
import sonar.flux.FluxConfig;
import sonar.flux.FluxNetworks;
import sonar.flux.api.AdditionType;
import sonar.flux.api.FluxListener;
import sonar.flux.api.RemovalType;
import sonar.flux.api.network.FluxPlayer;
import sonar.flux.api.network.IFluxNetwork;
import sonar.flux.api.tiles.IFlux;
import sonar.flux.api.tiles.IFluxController;
import sonar.flux.api.tiles.IFluxListenable;
import sonar.flux.api.tiles.IFluxPlug;
import sonar.flux.api.tiles.IFluxPoint;
import sonar.flux.common.tileentity.TileEntityStorage;
import sonar.flux.network.FluxNetworkCache;
import sonar.flux.network.PacketFluxConnectionsList;
import sonar.flux.network.PacketFluxNetworkList;
import sonar.flux.network.PacketNetworkStatistics;

public class FluxHelper {
    public static void addConnection(IFluxListenable flux, AdditionType type) {
        IFluxNetwork network;
        FluxNetworkCache.instance().getListenerList().addSubListenable((ISonarListenable)flux);
        if (flux.getNetworkID() != -1 && !(network = FluxNetworks.getServerCache().getNetwork(flux.getNetworkID())).isFakeNetwork()) {
            network.addConnection(flux, null);
        }
    }

    public static void removeConnection(IFluxListenable flux, RemovalType type) {
        IFluxNetwork network;
        FluxNetworkCache.instance().getListenerList().removeSubListenable((ISonarListenable)flux);
        if (flux.getNetworkID() != -1 && !(network = FluxNetworks.getServerCache().getNetwork(flux.getNetworkID())).isFakeNetwork()) {
            network.removeConnection(flux, null);
        }
    }

    public static UUID getOwnerUUID(EntityPlayer player) {
        return player.func_146103_bH().getId();
    }

    public static boolean isPlayerAdmin(EntityPlayer player) {
        return player.func_184812_l_();
    }

    public static void sortConnections(List<IFlux> flux, IFluxController.PriorityMode mode) {
        switch (mode) {
            case DEFAULT: {
                break;
            }
            case LARGEST: {
                flux.sort((o1, o2) -> o2.getCurrentPriority() - o1.getCurrentPriority());
                break;
            }
            case SMALLEST: {
                flux.sort(Comparator.comparingInt(IFlux::getCurrentPriority));
                break;
            }
        }
    }

    public static void sendPacket(IFluxNetwork network, ListenerTally<PlayerListener> tally) {
        block6: for (int i = 0; i < tally.tallies.length; ++i) {
            if (tally.tallies[i] <= 0) continue;
            FluxListener type = FluxListener.values()[i];
            switch (type) {
                case CONNECTIONS: {
                    network.buildFluxConnections();
                    FluxNetworks.network.sendTo((IMessage)new PacketFluxConnectionsList(network.getClientFluxConnection(), network.getNetworkID()), ((PlayerListener)tally.listener).player);
                    continue block6;
                }
                case FULL_NETWORK: {
                    List toSend = FluxNetworkCache.instance().getAllowedNetworks((EntityPlayer)((PlayerListener)tally.listener).player, false);
                    FluxNetworks.network.sendTo((IMessage)new PacketFluxNetworkList((ArrayList<? extends IFluxNetwork>)toSend, false), ((PlayerListener)tally.listener).player);
                    tally.removeTallies(1, new Enum[]{type});
                    tally.addTallies(1, new Enum[]{FluxListener.SYNC_NETWORK});
                    continue block6;
                }
                case STATISTICS: {
                    FluxNetworks.network.sendTo((IMessage)new PacketNetworkStatistics(network.getNetworkID(), network.getStatistics()), ((PlayerListener)tally.listener).player);
                    continue block6;
                }
                case SYNC_NETWORK: {
                    continue block6;
                }
            }
        }
    }

    public static long transferEnergy(IFluxPlug plug, List<IFluxPoint> points, IFluxController.TransferMode mode) {
        long limit;
        long currentLimit = limit = FluxHelper.pullEnergy(plug, plug.getCurrentTransferLimit(), ActionType.SIMULATE);
        for (IFluxPoint point : points) {
            if (currentLimit <= 0L) break;
            if (point.getConnectionType() == plug.getConnectionType()) continue;
            long toTransfer = (long)(mode == IFluxController.TransferMode.EVEN ? Math.min(Math.ceil((double)limit / (double)points.size()), (double)currentLimit) : (double)currentLimit);
            long pointRec = FluxHelper.pushEnergy(point, toTransfer, ActionType.PERFORM);
            currentLimit -= FluxHelper.pullEnergy(plug, pointRec, ActionType.PERFORM);
        }
        return limit - currentLimit;
    }

    public static long pullEnergy(IFlux from, long maxTransferRF, ActionType actionType) {
        long extracted = 0L;
        maxTransferRF = Math.min(maxTransferRF, from.getCurrentTransferLimit());
        if (from != null && maxTransferRF != 0L) {
            switch (from.getConnectionType()) {
                case PLUG: {
                    TileEntity[] tiles = from.cachedTiles();
                    for (int i = 0; i < 6; ++i) {
                        TileEntity tile = tiles[i];
                        if (tile == null) continue;
                        EnumFacing face = EnumFacing.values()[i].func_176734_d();
                        long simulate = SonarAPI.getEnergyHelper().extractEnergy(tile, Math.min(maxTransferRF - extracted, from.getCurrentTransferLimit()), face, ActionType.SIMULATE);
                        long remove = SonarAPI.getEnergyHelper().extractEnergy(tile, from.getValidTransfer(simulate, face), face, actionType);
                        if (!actionType.shouldSimulate()) {
                            from.onEnergyRemoved(EnumFacing.field_82609_l[i], remove);
                        }
                        extracted += remove;
                    }
                    break;
                }
                case STORAGE: {
                    TileEntityStorage tile = (TileEntityStorage)from;
                    int remove = tile.storage.extractEnergy((int)Math.min(maxTransferRF - extracted, Integer.MAX_VALUE), actionType.shouldSimulate());
                    if (!actionType.shouldSimulate()) {
                        from.onEnergyRemoved(EnumFacing.field_82609_l[0], remove);
                    }
                    extracted += (long)remove;
                    break;
                }
            }
        }
        return extracted;
    }

    public static long pushEnergy(IFlux to, long maxTransferRF, ActionType actionType) {
        long received = 0L;
        maxTransferRF = Math.min(maxTransferRF, to.getCurrentTransferLimit());
        if (to != null && maxTransferRF != 0L && to.canTransfer()) {
            switch (to.getConnectionType()) {
                case POINT: {
                    TileEntity[] tiles = to.cachedTiles();
                    for (int i = 0; i < 6; ++i) {
                        TileEntity tile = tiles[i];
                        if (tile == null) continue;
                        EnumFacing face = EnumFacing.values()[i].func_176734_d();
                        long simulate = SonarAPI.getEnergyHelper().receiveEnergy(tile, Math.min(maxTransferRF - received, to.getCurrentTransferLimit()), face, ActionType.SIMULATE);
                        long added = SonarAPI.getEnergyHelper().receiveEnergy(tile, to.getValidTransfer(simulate, face), face, actionType);
                        if (!actionType.shouldSimulate()) {
                            to.onEnergyAdded(EnumFacing.field_82609_l[i], added);
                        }
                        received += added;
                    }
                    break;
                }
                case STORAGE: {
                    TileEntityStorage tile = (TileEntityStorage)to;
                    int added = tile.storage.receiveEnergy((int)Math.min(maxTransferRF - received, Integer.MAX_VALUE), actionType.shouldSimulate());
                    if (!actionType.shouldSimulate()) {
                        to.onEnergyAdded(EnumFacing.field_82609_l[0], added);
                    }
                    received += (long)added;
                    break;
                }
                case CONTROLLER: {
                    IFluxController controller = (IFluxController)to;
                    if (controller.getTransmitterMode() == IFluxController.TransmitterMode.OFF) break;
                    ArrayList playerNames = (ArrayList)controller.getNetwork().getPlayers().clone();
                    ArrayList<EntityPlayer> players = new ArrayList<EntityPlayer>();
                    for (FluxPlayer fluxPlayer : playerNames) {
                        Entity entity = FMLCommonHandler.instance().getMinecraftServerInstance().func_175576_a(fluxPlayer.id);
                        if (entity == null || !(entity instanceof EntityPlayer)) continue;
                        players.add((EntityPlayer)entity);
                    }
                    block11: for (EntityPlayer entityPlayer : players) {
                        block5 : switch (controller.getTransmitterMode()) {
                            case HELD_ITEM: {
                                ItemStack stack = entityPlayer.func_184614_ca();
                                if (FluxHelper.canTransferEnergy(stack) == null) break;
                                long receive = SonarAPI.getEnergyHelper().receiveEnergy(stack, maxTransferRF - received, actionType);
                                received += receive;
                                if (!actionType.shouldSimulate()) {
                                    to.onEnergyRemoved(EnumFacing.field_82609_l[0], receive);
                                }
                                if (maxTransferRF - received > 0L) break;
                                break;
                            }
                            case HOTBAR: 
                            case ON: {
                                long receive;
                                InventoryPlayer inv = entityPlayer.field_71071_by;
                                for (int i = 0; i < (controller.getTransmitterMode() == IFluxController.TransmitterMode.ON ? inv.func_70302_i_() : 9); ++i) {
                                    ItemStack itemStack = inv.func_70301_a(i);
                                    if (FluxHelper.canTransferEnergy(itemStack) == null) continue;
                                    receive = SonarAPI.getEnergyHelper().receiveEnergy(itemStack, maxTransferRF - received, actionType);
                                    received += receive;
                                    if (!actionType.shouldSimulate()) {
                                        to.onEnergyRemoved(EnumFacing.field_82609_l[0], receive);
                                    }
                                    if (maxTransferRF - received <= 0L) break block5;
                                }
                                continue block11;
                            }
                        }
                    }
                    break;
                }
            }
        }
        return received;
    }

    public static boolean canConnect(TileEntity tile, EnumFacing dir) {
        return tile != null && !(tile instanceof IFlux) && (FluxHelper.canTransferEnergy(tile, dir) != null || SonarLoader.rfLoaded && tile instanceof IEnergyConnection && (Boolean)FluxConfig.transfers.get((Object)EnergyType.RF).a != false);
    }

    public static List<ISonarEnergyHandler> getEnergyHandlers() {
        ArrayList<ISonarEnergyHandler> handlers = new ArrayList<ISonarEnergyHandler>();
        for (ISonarEnergyHandler handler : SonarCore.energyHandlers) {
            if (!((Boolean)FluxConfig.transfers.get((Object)handler.getProvidedType()).a).booleanValue()) continue;
            handlers.add(handler);
        }
        return handlers;
    }

    public static List<ISonarEnergyContainerHandler> getEnergyContainerHandlers() {
        ArrayList<ISonarEnergyContainerHandler> handlers = new ArrayList<ISonarEnergyContainerHandler>();
        for (ISonarEnergyContainerHandler handler : SonarCore.energyContainerHandlers) {
            if (!((Boolean)FluxConfig.transfers.get((Object)handler.getProvidedType()).b).booleanValue()) continue;
            handlers.add(handler);
        }
        return handlers;
    }

    public static ISonarEnergyHandler canTransferEnergy(TileEntity tile, EnumFacing dir) {
        List<ISonarEnergyHandler> handlers = FluxNetworks.energyHandlers;
        for (ISonarEnergyHandler handler : handlers) {
            if (!handler.canProvideEnergy(tile, dir)) continue;
            return handler;
        }
        return null;
    }

    public static ISonarEnergyContainerHandler canTransferEnergy(ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        List<ISonarEnergyContainerHandler> handlers = FluxNetworks.energyContainerHandlers;
        for (ISonarEnergyContainerHandler handler : handlers) {
            if (!handler.canHandleItem(stack)) continue;
            return handler;
        }
        return null;
    }
}

