/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.common.tileentity;

import cofh.redstoneflux.api.IEnergyHandler;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import sonar.core.SonarCore;
import sonar.core.common.tileentity.TileEntitySonar;
import sonar.core.helpers.SonarHelper;
import sonar.core.listener.ISonarListenable;
import sonar.core.listener.ISonarListener;
import sonar.core.listener.ListenableList;
import sonar.core.listener.ListenerTally;
import sonar.core.listener.PlayerListener;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.SyncTagType;
import sonar.core.network.sync.SyncTagTypeList;
import sonar.core.network.sync.SyncUUID;
import sonar.core.network.utils.IByteBufTile;
import sonar.flux.FluxConfig;
import sonar.flux.api.AdditionType;
import sonar.flux.api.FluxError;
import sonar.flux.api.FluxListener;
import sonar.flux.api.RemovalType;
import sonar.flux.api.configurator.FluxConfigurationType;
import sonar.flux.api.configurator.IFluxConfigurable;
import sonar.flux.api.network.FluxCache;
import sonar.flux.api.network.IFluxNetwork;
import sonar.flux.api.network.PlayerAccess;
import sonar.flux.api.tiles.IFlux;
import sonar.flux.api.tiles.IFluxListenable;
import sonar.flux.common.block.FluxConnection;
import sonar.flux.connection.EmptyFluxNetwork;
import sonar.flux.connection.FluxHelper;

@Optional.InterfaceList(value={@Optional.Interface(iface="cofh.redstoneflux.api.IEnergyHandler", modid="redstoneflux")})
public class TileEntityFlux
extends TileEntitySonar
implements IFluxListenable,
IEnergyHandler,
IByteBufTile,
IFluxConfigurable {
    public SyncTagType.INT priority = new SyncTagType.INT(0);
    public SyncTagType.LONG limit = (SyncTagType.LONG)new SyncTagType.LONG(1).setDefault((Object)FluxConfig.defaultLimit);
    public SyncTagType.BOOLEAN disableLimit = new SyncTagType.BOOLEAN(2);
    public SyncTagType.INT networkID = (SyncTagType.INT)new SyncTagType.INT(4).setDefault((Object)-1);
    public SyncUUID playerUUID = new SyncUUID(5);
    public SyncTagType.STRING customName = (SyncTagType.STRING)new SyncTagType.STRING(6).setDefault((Object)"Flux Connection");
    public SyncTagType.INT colour = new SyncTagType.INT(7);
    public ListenableList<PlayerListener> listeners = new ListenableList((ISonarListenable)this, FluxListener.values().length);
    public TileEntity[] cachedTiles = new TileEntity[6];
    public boolean hasTiles;
    public SyncTagTypeList<Boolean> connections = new SyncTagTypeList(0, 8);
    private final IFlux.ConnectionType type;
    public long toReceive;
    public long toSend;
    public long totalTransferMax;
    public long[] currentTransfer = new long[6];
    public IFluxNetwork network;
    private int checkTicks;
    public FluxError error;

    public TileEntityFlux(IFlux.ConnectionType type) {
        this.syncList.addParts(new IDirtyPart[]{this.priority, this.limit, this.disableLimit, this.networkID, this.playerUUID, this.customName, this.colour, this.connections});
        this.connections.setObjects(Lists.newArrayList((Object[])new Boolean[]{false, false, false, false, false, false}));
        this.network = EmptyFluxNetwork.INSTANCE;
        this.error = FluxError.NONE;
        this.type = type;
    }

    public void setPlayerUUID(UUID name) {
        this.playerUUID.setObject(name);
    }

    @Override
    public void connect(IFluxNetwork network) {
        this.network = network;
        this.networkID.setObject((Object)network.getNetworkID());
        this.colour.setObject((Object)network.getNetworkColour().getRGB());
        this.setState(true);
        this.markBlockForUpdate();
    }

    @Override
    public void disconnect(IFluxNetwork network) {
        if (network.getNetworkID() == ((Integer)this.networkID.getObject()).intValue()) {
            this.network = EmptyFluxNetwork.INSTANCE;
            this.networkID.setObject((Object)-1);
            this.colour.setObject((Object)EmptyFluxNetwork.colour.getRGB());
            this.setState(false);
            this.markBlockForUpdate();
        }
    }

    public void setState(boolean bool) {
        World world = this.func_145831_w();
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        if (state.func_177230_c() instanceof FluxConnection) {
            world.func_180501_a(this.func_174877_v(), state.func_177226_a((IProperty)FluxConnection.CONNECTED, (Comparable)Boolean.valueOf(bool)), 2);
        }
    }

    @Override
    public PlayerAccess canAccess(EntityPlayer player) {
        if (FluxHelper.isPlayerAdmin(player)) {
            return PlayerAccess.CREATIVE;
        }
        if (this.playerUUID.getUUID() != null && this.playerUUID.getUUID().equals(FluxHelper.getOwnerUUID(player))) {
            return PlayerAccess.OWNER;
        }
        return this.getNetwork().isFakeNetwork() ? PlayerAccess.BLOCKED : this.getNetwork().getPlayerAccess(player);
    }

    @Override
    public UUID getConnectionOwner() {
        return this.playerUUID.getUUID();
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (this.isServer()) {
            this.totalTransferMax = (Long)this.limit.getObject();
            for (int i = 0; i < 6; ++i) {
                this.currentTransfer[i] = (Long)this.limit.getObject();
            }
            if (this.checkTicks >= 20) {
                this.updateNeighbours(false);
                this.checkTicks = 0;
            } else {
                ++this.checkTicks;
            }
            this.listeners.forEach(tally -> FluxHelper.sendPacket(this.getNetwork(), (ListenerTally<PlayerListener>)tally));
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public void onSyncPacketRequested(EntityPlayer player) {
        this.updateNeighbours(true);
        super.onSyncPacketRequested(player);
    }

    @Override
    public void updateNeighbours(boolean full) {
        boolean changed = false;
        this.hasTiles = false;
        for (EnumFacing face : this.getValidFaces()) {
            boolean canConnect;
            int ordinal = face.func_176745_a();
            BlockPos pos = this.func_174877_v().func_177972_a(face);
            TileEntity tile = this.func_145831_w().func_175625_s(pos);
            boolean bl = canConnect = tile != null && FluxHelper.canConnect(tile, face.func_176734_d());
            if ((full || canConnect != (Boolean)this.connections.getObjects().get(ordinal)) && this.setNeighbour(face, (TileEntity)(canConnect ? tile : null))) {
                changed = true;
            }
            if (!canConnect) continue;
            this.hasTiles = true;
        }
        if (changed) {
            this.connections.markChanged();
            SonarCore.sendFullSyncAroundWithRenderUpdate((TileEntity)this, (int)128);
        }
    }

    public boolean setNeighbour(EnumFacing face, TileEntity tile) {
        TileEntity prev = this.cachedTiles[face.func_176745_a()];
        boolean changed = tile != null;
        this.connections.getObjects().set(face.func_176745_a(), changed);
        this.cachedTiles[face.func_176745_a()] = tile;
        return prev != tile;
    }

    @Override
    public TileEntity[] cachedTiles() {
        return this.cachedTiles;
    }

    public EnumFacing[] getValidFaces() {
        return EnumFacing.values();
    }

    @Override
    public boolean canTransfer() {
        return this.hasTiles;
    }

    public void onFirstTick() {
        super.onFirstTick();
        if (this.isServer()) {
            FluxHelper.addConnection(this, AdditionType.ADD);
            this.updateNeighbours(true);
            SonarCore.sendPacketAround((TileEntity)this, (int)128, (int)0);
        }
        if (this.isClient()) {
            this.requestSyncPacket();
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.isServer()) {
            FluxHelper.removeConnection(this, RemovalType.REMOVE);
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.isServer()) {
            FluxHelper.removeConnection(this, RemovalType.CHUNK_UNLOAD);
        }
    }

    @Override
    public int getNetworkID() {
        return (Integer)this.networkID.getObject();
    }

    @Override
    public NBTTagCompound addConfigs(NBTTagCompound config, EntityPlayer player) {
        if (!this.getNetwork().isFakeNetwork() && this.network.getNetworkID() != -1) {
            config.func_74768_a(FluxConfigurationType.NETWORK.getNBTName(), this.getNetwork().getNetworkID());
        }
        config.func_74768_a(FluxConfigurationType.PRIORITY.getNBTName(), ((Integer)this.priority.getObject()).intValue());
        config.func_74772_a(FluxConfigurationType.TRANSFER.getNBTName(), ((Long)this.limit.getObject()).longValue());
        config.func_74757_a(FluxConfigurationType.DISABLE_LIMIT.getNBTName(), ((Boolean)this.disableLimit.getObject()).booleanValue());
        return config;
    }

    @Override
    public void readConfigs(NBTTagCompound config, EntityPlayer player) {
        int storedID;
        if (config.func_74764_b(FluxConfigurationType.NETWORK.getNBTName()) && (storedID = config.func_74762_e(FluxConfigurationType.NETWORK.getNBTName())) != -1) {
            FluxHelper.removeConnection(this, null);
            this.networkID.setObject((Object)storedID);
            FluxHelper.addConnection(this, null);
        }
        if (config.func_74764_b(FluxConfigurationType.PRIORITY.getNBTName())) {
            this.priority.setObject((Object)config.func_74762_e(FluxConfigurationType.PRIORITY.getNBTName()));
        }
        if (config.func_74764_b(FluxConfigurationType.TRANSFER.getNBTName())) {
            this.limit.setObject((Object)config.func_74763_f(FluxConfigurationType.TRANSFER.getNBTName()));
        }
        if (config.func_74764_b(FluxConfigurationType.DISABLE_LIMIT.getNBTName())) {
            this.disableLimit.setObject((Object)config.func_74767_n(FluxConfigurationType.DISABLE_LIMIT.getNBTName()));
        }
    }

    @Override
    public IFluxNetwork getNetwork() {
        return this.network;
    }

    @Override
    public IFlux.ConnectionType getConnectionType() {
        return this.type;
    }

    @Override
    public long getTransferLimit() {
        return (Boolean)this.disableLimit.getObject() != false ? Long.MAX_VALUE : (Long)this.limit.getObject();
    }

    @Override
    public long getCurrentTransferLimit() {
        return (Boolean)this.disableLimit.getObject() != false ? Long.MAX_VALUE : this.totalTransferMax;
    }

    @Override
    public long getCurrentTransfer(EnumFacing face) {
        return face == null ? this.getCurrentTransferLimit() : Math.min(this.getCurrentTransferLimit(), this.currentTransfer[face.ordinal()]);
    }

    @Override
    public long getValidTransfer(long valid, EnumFacing face) {
        return Math.min(valid, this.getCurrentTransferLimit());
    }

    @Override
    public void onEnergyRemoved(EnumFacing face, long remove) {
        this.totalTransferMax -= remove;
    }

    @Override
    public void onEnergyAdded(EnumFacing face, long added) {
        this.totalTransferMax -= added;
    }

    @Override
    public int getCurrentPriority() {
        return (Integer)this.priority.getObject();
    }

    @Override
    public World getDimension() {
        return this.field_145850_b;
    }

    @Override
    public String getCustomName() {
        return (String)this.customName.getObject();
    }

    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    @Optional.Method(modid="redstoneflux")
    public int getEnergyStored(EnumFacing from) {
        return 0;
    }

    @Optional.Method(modid="redstoneflux")
    public int getMaxEnergyStored(EnumFacing from) {
        return Integer.MAX_VALUE;
    }

    public void writePacket(ByteBuf buf, int id) {
        switch (id) {
            case -1: {
                this.disableLimit.writeToBuf(buf);
                break;
            }
            case 1: {
                this.priority.writeToBuf(buf);
                break;
            }
            case 2: {
                this.limit.writeToBuf(buf);
                break;
            }
            case 3: {
                this.customName.writeToBuf(buf);
            }
        }
    }

    public void readPacket(ByteBuf buf, int id) {
        switch (id) {
            case -1: {
                this.disableLimit.readFromBuf(buf);
                break;
            }
            case 1: {
                this.priority.readFromBuf(buf);
                this.getNetwork().markTypeDirty(FluxCache.flux);
                break;
            }
            case 2: {
                this.limit.readFromBuf(buf);
                break;
            }
            case 3: {
                this.customName.readFromBuf(buf);
                break;
            }
            case 4: {
                EntityPlayer player = SonarHelper.getPlayerFromUUID((UUID)this.playerUUID.getUUID());
                if (player == null) break;
                this.listeners.addListener(player, new Enum[]{FluxListener.CONNECTIONS});
                break;
            }
            case 5: {
                EntityPlayer player = SonarHelper.getPlayerFromUUID((UUID)this.playerUUID.getUUID());
                if (player == null) break;
                this.listeners.clearListener((ISonarListener)this.listeners.findListener(player));
                this.listeners.addListener(player, new Enum[]{FluxListener.SYNC_NETWORK});
            }
        }
    }

    public ListenableList<PlayerListener> getListenerList() {
        return this.listeners;
    }

    public void onListenerAdded(ListenerTally<PlayerListener> tally) {
    }

    public void onListenerRemoved(ListenerTally<PlayerListener> tally) {
    }

    public void onSubListenableAdded(ISonarListenable<PlayerListener> listen) {
    }

    public void onSubListenableRemoved(ISonarListenable<PlayerListener> listen) {
    }

    public boolean isValid() {
        return !this.func_145837_r();
    }

    @Override
    public void setMaxSend(long send) {
        this.toSend = send;
    }

    @Override
    public void setMaxReceive(long receive) {
        this.toReceive = receive;
    }
}

