/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.common.item;

import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import sonar.core.SonarCore;
import sonar.core.api.IFlexibleGui;
import sonar.core.common.item.SonarItem;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.SonarHelper;
import sonar.flux.api.configurator.FluxConfigurationType;
import sonar.flux.api.configurator.IFluxConfigurable;
import sonar.flux.client.GuiConfigurator;
import sonar.flux.common.containers.ContainerConfigurator;

public class FluxConfigurator
extends SonarItem
implements IFlexibleGui<ItemStack> {
    public static final String CONFIGS_TAG = "configs";
    public static final String DISABLED_TAG = "disabled";

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof IFluxConfigurable) {
                IFluxConfigurable configurable = (IFluxConfigurable)tile;
                if (configurable.canAccess(player).canEdit()) {
                    ItemStack stack;
                    ItemStack itemStack = stack = hand == null ? ItemStack.field_190927_a : player.func_184586_b(hand);
                    if (player.func_70093_af()) {
                        NBTTagCompound configs = stack.func_190925_c(CONFIGS_TAG);
                        stack.func_77983_a(CONFIGS_TAG, (NBTBase)configurable.addConfigs(new NBTTagCompound(), player));
                        FontHelper.sendMessage((String)"Copied Configuration", (World)world, (EntityPlayer)player);
                    } else {
                        NBTTagCompound configs = stack.func_190925_c(CONFIGS_TAG);
                        if (!configs.func_82582_d()) {
                            NBTTagCompound disabled = stack.func_190925_c(DISABLED_TAG);
                            if (disabled.func_82582_d()) {
                                configurable.readConfigs(configs, player);
                            } else {
                                NBTTagCompound allowed = configs.func_74737_b();
                                for (FluxConfigurationType type : FluxConfigurationType.values()) {
                                    if (!disabled.func_74767_n(type.getNBTName())) continue;
                                    allowed.func_82580_o(type.getNBTName());
                                }
                                configurable.readConfigs(allowed, player);
                            }
                        }
                        FontHelper.sendMessage((String)"Pasted Configuration", (World)world, (EntityPlayer)player);
                    }
                    return EnumActionResult.SUCCESS;
                }
                FontHelper.sendMessage((String)(SonarHelper.getProfileByUUID((UUID)configurable.getConnectionOwner()).getName() + " : You don't have permission to access this network"), (World)world, (EntityPlayer)player);
            } else {
                FontHelper.sendMessage((String)"INVALID BLOCK", (World)world, (EntityPlayer)player);
            }
        }
        return EnumActionResult.SUCCESS;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack;
        ItemStack itemStack = stack = hand == null ? null : player.func_184586_b(hand);
        if (!world.field_72995_K) {
            SonarCore.instance.guiHandler.openBasicItemStack(false, stack, player, world, player.func_180425_c(), 0);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public void onGuiOpened(ItemStack obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
    }

    public Object getServerElement(ItemStack obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        return id == 0 ? new ContainerConfigurator(player) : null;
    }

    public Object getClientElement(ItemStack obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        return id == 0 ? new GuiConfigurator(player, obj) : null;
    }
}

