/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.client.states;

import java.awt.Color;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.text.TextFormatting;
import sonar.core.client.gui.SonarTextField;
import sonar.core.helpers.FontHelper;
import sonar.core.utils.CustomColour;
import sonar.flux.api.AccessType;
import sonar.flux.client.GUI;
import sonar.flux.client.GuiFlux;
import sonar.flux.client.GuiFluxBase;
import sonar.flux.client.GuiState;
import sonar.flux.client.GuiTypeMessage;
import sonar.flux.network.PacketHelper;
import sonar.flux.network.PacketType;

public class GuiStateNetworkEdit
extends GuiState {
    public SonarTextField name;
    public SonarTextField r;
    public SonarTextField g;
    public SonarTextField b;
    public int currentColour;
    public AccessType currentAccess = AccessType.PRIVATE;
    public boolean previewSelected = true;
    public boolean showFullPreview = true;

    public GuiStateNetworkEdit() {
        super(GuiTypeMessage.NETWORK_EDIT, 176, 166, 256, "network.edit");
    }

    @Override
    public void draw(GuiFlux flux, int x, int y) {
        if (flux.disabledState) {
            flux.renderNavigationPrompt("No network to edit", "Network Selection");
        } else {
            String networkName;
            GlStateManager.func_179094_E();
            if (GuiFluxBase.state == GuiState.NETWORK_CREATE) {
                FontHelper.textCentre((String)GUI.CREATE_NETWORK.toString(), (int)flux.getXSize(), (int)8, (int)Color.GRAY.getRGB());
            } else {
                FontHelper.textCentre((String)GUI.EDIT_NETWORK.toString(), (int)flux.getXSize(), (int)8, (int)Color.GRAY.getRGB());
            }
            FontHelper.text((String)((Object)((Object)GUI.NETWORK_NAME) + ": "), (int)8, (int)24, (int)0);
            FontHelper.text((String)"Colour: ", (int)8, (int)80, (int)0);
            FontHelper.text((String)(TextFormatting.RED + "R:"), (int)46, (int)80, (int)-1);
            FontHelper.text((String)(TextFormatting.GREEN + "G:"), (int)86, (int)80, (int)-1);
            FontHelper.text((String)(TextFormatting.BLUE + "B:"), (int)126, (int)80, (int)-1);
            CustomColour colour = this.getCurrentColour();
            Gui.func_73734_a((int)55, (int)95, (int)165, (int)104, (int)colour.getRGB());
            FontHelper.text((String)((Object)((Object)GUI.ACCESS_SETTING) + ": " + TextFormatting.AQUA + FontHelper.translate((String)this.currentAccess.getName())), (int)8, (int)40, (int)0);
            FontHelper.text((String)(FontHelper.translate((String)"Preview") + ": "), (int)8, (int)96, (int)0);
            String string = networkName = this.name.func_146179_b().isEmpty() ? "Network Name" : this.name.func_146179_b();
            if (this.showFullPreview) {
                flux.renderNetworkInFull(networkName, this.currentAccess, colour.getRGB(), this.previewSelected, 11, 110);
            } else {
                flux.renderNetwork(networkName, this.currentAccess, colour.getRGB(), this.previewSelected, 11, 110);
            }
            if (x - flux.getGuiLeft() > 55 && x - flux.getGuiLeft() < 165 && y - flux.getGuiTop() > 95 && y - flux.getGuiTop() < 104) {
                flux.drawCreativeTabHoveringText(GUI.NEXT_COLOUR.toString(), x - flux.getGuiLeft(), y - flux.getGuiTop());
            }
            if (x - flux.getGuiLeft() > 5 && x - flux.getGuiLeft() < 165 && y - flux.getGuiTop() > 38 && y - flux.getGuiTop() < 52) {
                flux.drawCreativeTabHoveringText(GUI.CHANGE_SETTING.toString(), x - flux.getGuiLeft(), y - flux.getGuiTop());
            }
            GlStateManager.func_179121_F();
        }
    }

    @Override
    public void init(GuiFlux flux) {
        if (!flux.common.isFakeNetwork()) {
            this.initEditFields(flux, flux.common.getNetworkName(), flux.common.getNetworkColour());
            flux.getButtonList().add(new GuiButton(5, flux.getGuiLeft() + 5, flux.getGuiTop() + 140, 80, 20, "Reset"));
            flux.getButtonList().add(new GuiButton(6, flux.getGuiLeft() + 90, flux.getGuiTop() + 140, 80, 20, "Save Changes"));
            this.currentAccess = flux.common.getAccessType();
        } else {
            flux.disabledState = true;
        }
    }

    @Override
    public void button(GuiFlux flux, GuiButton button) {
        switch (button.field_146127_k) {
            case 5: {
                this.resetCreateTab(flux);
                break;
            }
            case 6: {
                if (this.name.func_146179_b().isEmpty()) break;
                if (GuiFluxBase.state == GuiState.NETWORK_CREATE) {
                    PacketHelper.sendPacketToServer(PacketType.CREATE_NETWORK, flux.tile, PacketHelper.createNetworkCreationPacket(this.name.func_146179_b(), this.getCurrentColour(), this.currentAccess));
                } else {
                    PacketHelper.sendPacketToServer(PacketType.EDIT_NETWORK, flux.tile, PacketHelper.createNetworkEditPacket(flux.getNetworkID(), this.name.func_146179_b(), this.getCurrentColour(), this.currentAccess));
                }
                flux.switchState(GuiState.NETWORK_SELECT);
                this.resetCreateTab(flux);
                return;
            }
        }
    }

    @Override
    public void click(GuiFlux flux, int x, int y, int mouseButton) {
        if (mouseButton == 1) {
            this.name.func_146180_a("");
        }
        if (x - flux.getGuiLeft() > 55 && x - flux.getGuiLeft() < 165 && y - flux.getGuiTop() > 95 && y - flux.getGuiTop() < 104) {
            ++this.currentColour;
            if (this.currentColour >= GuiFluxBase.colours.length) {
                this.currentColour = 0;
            }
            CustomColour colour = GuiFluxBase.colours[this.currentColour];
            this.r.func_146180_a(String.valueOf(colour.red));
            this.g.func_146180_a(String.valueOf(colour.green));
            this.b.func_146180_a(String.valueOf(colour.blue));
        }
        if (x - flux.getGuiLeft() > 5 && x - flux.getGuiLeft() < 165 && y - flux.getGuiTop() > 38 && y - flux.getGuiTop() < 52) {
            this.currentAccess = AccessType.values()[this.currentAccess.ordinal() + 1 < AccessType.values().length ? this.currentAccess.ordinal() + 1 : 0];
        }
        if (x - flux.getGuiLeft() > 11 && x - flux.getGuiLeft() < 165 && y - flux.getGuiTop() > 108 && y - flux.getGuiTop() < 134) {
            this.showFullPreview = !this.showFullPreview;
        }
    }

    @Override
    public boolean type(GuiFlux flux, char c, int i) {
        if (i == 1) {
            flux.switchState(GuiState.INDEX);
            return false;
        }
        return true;
    }

    public void resetCreateTab(GuiFlux flux) {
        this.name.func_146180_a("");
        this.currentColour = 0;
        this.currentAccess = AccessType.PRIVATE;
        flux.reset();
    }

    public void initEditFields(GuiFlux flux, String networkName, CustomColour colour) {
        this.name = new SonarTextField(1, flux.getFontRenderer(), 38, 22, 130, 12).setBoxOutlineColour(Color.DARK_GRAY.getRGB());
        this.name.func_146203_f(24);
        this.name.func_146180_a(networkName);
        this.r = new SonarTextField(2, flux.getFontRenderer(), 56, 78, 28, 12).setBoxOutlineColour(Color.DARK_GRAY.getRGB()).setDigitsOnly(true);
        this.r.func_146203_f(3);
        this.r.func_146180_a(String.valueOf(colour.red));
        this.g = new SonarTextField(3, flux.getFontRenderer(), 96, 78, 28, 12).setBoxOutlineColour(Color.DARK_GRAY.getRGB()).setDigitsOnly(true);
        this.g.func_146203_f(3);
        this.g.func_146180_a(String.valueOf(colour.green));
        this.b = new SonarTextField(4, flux.getFontRenderer(), 136, 78, 28, 12).setBoxOutlineColour(Color.DARK_GRAY.getRGB()).setDigitsOnly(true);
        this.b.func_146203_f(3);
        this.b.func_146180_a(String.valueOf(colour.blue));
    }

    public CustomColour getCurrentColour() {
        return new CustomColour(this.r.getIntegerFromText(), this.g.getIntegerFromText(), this.b.getIntegerFromText());
    }

    @Override
    public SonarTextField[] getFields(GuiFlux flux) {
        return new SonarTextField[]{this.name, this.r, this.g, this.b};
    }

    @Override
    public int getSelectionSize(GuiFlux flux) {
        return 0;
    }
}

