/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.client.states;

import java.util.ArrayList;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.util.text.TextFormatting;
import sonar.core.client.gui.SonarTextField;
import sonar.core.client.gui.widgets.SonarScroller;
import sonar.core.helpers.FontHelper;
import sonar.flux.api.ClientFlux;
import sonar.flux.client.GUI;
import sonar.flux.client.GuiFlux;
import sonar.flux.client.GuiFluxBase;
import sonar.flux.client.GuiTypeMessage;
import sonar.flux.client.states.GuiStateScrollable;
import sonar.flux.network.PacketHelper;
import sonar.flux.network.PacketType;

public class GuiStateNetworkConnections
extends GuiStateScrollable {
    public SonarScroller scroller;
    public ClientFlux selected;
    public boolean toRemove;
    public static int listSize = 10;

    public GuiStateNetworkConnections() {
        super(GuiTypeMessage.CONNECTIONS, 176, 166, 64, "network.nav.config");
    }

    @Override
    public void draw(GuiFlux flux, int x, int y) {
        if (flux.common.isFakeNetwork()) {
            flux.renderNavigationPrompt("No Connections Available", "Network Selection");
            return;
        }
        ArrayList<ClientFlux> connections = flux.common.getClientFluxConnection();
        int start = (int)((float)connections.size() * this.scroller.getCurrentScroll());
        int finish = Math.min(start + listSize + 2, connections.size());
        this.selected = null;
        for (int i = start; i < finish; ++i) {
            ClientFlux clientFlux = connections.get(i);
            if (clientFlux == null) continue;
            int posX = 11;
            int posY = 8 + 12 * i - 12 * start;
            if (x > flux.getGuiLeft() + posX && x < flux.getGuiLeft() + posX + 154 && y >= flux.getGuiTop() + posY && y < flux.getGuiTop() + posY + 12) {
                this.toRemove = x > flux.getGuiLeft() + posX + 144;
                this.selected = clientFlux;
                flux.renderFlux(clientFlux, true, posX, posY);
            } else {
                flux.renderFlux(clientFlux, false, posX, posY);
            }
            flux.bindTexture(GuiFluxBase.buttons);
            flux.func_73729_b(154, posY, 56, 0, 12, 12);
        }
        flux.bindTexture(flux.getBackground());
        if (this.selected != null) {
            boolean isCurrent = this.selected.coords.getBlockPos().equals((Object)flux.tile.func_174877_v());
            ArrayList<String> strings = new ArrayList<String>();
            if (this.toRemove) {
                strings.add(TextFormatting.RED + "REMOVE");
            } else {
                if (isCurrent) {
                    strings.add(TextFormatting.GREEN + "THIS CONNECTION!");
                }
                strings.add(FontHelper.translate((String)"flux.type") + ": " + TextFormatting.AQUA + this.selected.getConnectionType().toString());
                strings.add(TextFormatting.GRAY + this.selected.getCoords().toString());
                strings.add((Object)((Object)GUI.MAX) + ": " + TextFormatting.AQUA + (this.selected.getTransferLimit() == Long.MAX_VALUE ? "NO LIMIT" : Long.valueOf(this.selected.getTransferLimit())));
                strings.add((Object)((Object)GUI.PRIORITY) + ": " + TextFormatting.AQUA + this.selected.getCurrentPriority());
            }
            flux.func_146283_a(strings, x - flux.getGuiLeft(), y - flux.getGuiTop());
        } else {
            this.toRemove = false;
        }
    }

    @Override
    public void init(GuiFlux flux) {
        this.scroller = new SonarScroller(flux.getGuiLeft() + 165, flux.getGuiTop() + 8, 146, 10);
        for (int i = 0; i < listSize + 2; ++i) {
            flux.getButtonList().add((GuiButton)new GuiFluxBase.NetworkButton(10 + i, flux.getGuiLeft() + 7, flux.getGuiTop() + 8 + i * 12));
        }
    }

    @Override
    public void button(GuiFlux flux, GuiButton button) {
    }

    @Override
    public void click(GuiFlux flux, int x, int y, int mouseButton) {
        if (this.toRemove && this.selected != null) {
            PacketHelper.sendPacketToServer(PacketType.REMOVE_CONNECTION, this.selected.coords, PacketHelper.createDisconnectPacket(flux.getNetworkID()));
        }
    }

    @Override
    public SonarTextField[] getFields(GuiFlux flux) {
        return new SonarTextField[0];
    }

    @Override
    public SonarScroller[] getScrollers() {
        return new SonarScroller[]{this.scroller};
    }

    @Override
    public int getSelectionSize(GuiFlux flux) {
        if (flux.common == null) {
            return 0;
        }
        return flux.common.getClientFluxConnection().size();
    }
}

