/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.client.states;

import net.minecraft.client.gui.GuiButton;
import net.minecraft.tileentity.TileEntity;
import sonar.core.SonarCore;
import sonar.core.client.gui.SonarTextField;
import sonar.flux.client.GuiFlux;
import sonar.flux.client.GuiState;
import sonar.flux.client.GuiTypeMessage;

public class GuiStateIndex
extends GuiState {
    public SonarTextField fluxName;
    public SonarTextField priority;
    public SonarTextField limit;

    public GuiStateIndex() {
        super(GuiTypeMessage.INDEX, 176, 166, 0, "network.nav.home");
    }

    @Override
    public void draw(GuiFlux flux, int x, int y) {
        flux.drawScreen(flux.tile, flux.tile.getConnectionType());
    }

    @Override
    public void init(GuiFlux flux) {
        int networkColour = flux.common.getNetworkColour().getRGB();
        this.priority = new SonarTextField(0, flux.getFontRenderer(), 50, 46, 30, 12).setBoxOutlineColour(networkColour).setDigitsOnly(true);
        this.priority.func_146203_f(3);
        this.priority.func_146180_a(String.valueOf(flux.tile.getCurrentPriority()));
        this.limit = new SonarTextField(1, flux.getFontRenderer(), 110, 46, 58, 12).setBoxOutlineColour(networkColour).setDigitsOnly(true);
        this.limit.func_146203_f(8);
        this.limit.func_146180_a(String.valueOf(flux.tile.limit.getObject()));
        this.fluxName = new SonarTextField(1, flux.getFontRenderer(), 38, 28, 130, 12).setBoxOutlineColour(networkColour);
        this.fluxName.func_146203_f(24);
        this.fluxName.func_146180_a(flux.tile.getCustomName());
    }

    @Override
    public void button(GuiFlux flux, GuiButton button) {
        if (button.field_146127_k == 0) {
            flux.switchState(GuiState.NETWORK_SELECT);
            flux.reset();
            return;
        }
        if (button.field_146127_k == 5) {
            flux.switchState(GuiState.CONNECTIONS);
            SonarCore.sendPacketToServer((TileEntity)flux.tile, (int)4);
        }
    }

    @Override
    public void click(GuiFlux flux, int x, int y, int mouseButton) {
        if (x - flux.getGuiLeft() > 5 && x - flux.getGuiLeft() < 165 && y - flux.getGuiTop() > 66 && y - flux.getGuiTop() < 80) {
            flux.tile.disableLimit.invert();
            SonarCore.sendPacketToServer((TileEntity)flux.tile, (int)-1);
        } else if (x - flux.getGuiLeft() > 5 && x - flux.getGuiLeft() < 165 && y - flux.getGuiTop() > 10 && y - flux.getGuiTop() < 20) {
            flux.switchState(GuiState.NETWORK_SELECT);
        }
    }

    @Override
    public boolean type(GuiFlux flux, char c, int i) {
        return true;
    }

    @Override
    public void textboxKeyTyped(GuiFlux flux, SonarTextField field, char c, int i) {
        if (field == this.priority) {
            flux.tile.priority.setObject((Object)this.priority.getIntegerFromText());
            SonarCore.sendPacketToServer((TileEntity)flux.tile, (int)1);
        } else if (field == this.limit) {
            flux.tile.limit.setObject((Object)this.limit.getLongFromText());
            SonarCore.sendPacketToServer((TileEntity)flux.tile, (int)2);
        } else if (field == this.fluxName) {
            flux.tile.customName.setObject((Object)this.fluxName.func_146179_b());
            SonarCore.sendPacketToServer((TileEntity)flux.tile, (int)3);
        }
    }

    @Override
    public SonarTextField[] getFields(GuiFlux flux) {
        return new SonarTextField[]{this.priority, this.limit, this.fluxName};
    }

    @Override
    public int getSelectionSize(GuiFlux flux) {
        return 0;
    }
}

