/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.client;

import java.awt.Color;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sonar.core.client.gui.GuiSonarTile;
import sonar.core.client.gui.SonarButtons;
import sonar.core.helpers.FontHelper;
import sonar.core.utils.CustomColour;
import sonar.core.utils.IWorldPosition;
import sonar.flux.FluxNetworks;
import sonar.flux.api.AccessType;
import sonar.flux.api.FluxError;
import sonar.flux.api.network.IFluxCommon;
import sonar.flux.api.tiles.IFlux;
import sonar.flux.client.GuiState;
import sonar.flux.common.tileentity.TileEntityFlux;
import sonar.flux.network.PacketHelper;
import sonar.flux.network.PacketType;

public abstract class GuiFluxBase
extends GuiSonarTile {
    public static final ResourceLocation select = new ResourceLocation("fluxnetworks:textures/gui/networkSelect.png");
    public static final ResourceLocation connections = new ResourceLocation("fluxnetworks:textures/gui/connections.png");
    public static final ResourceLocation bground = new ResourceLocation("fluxnetworks:textures/gui/fluxPlug.png");
    public static final ResourceLocation buttons = new ResourceLocation("fluxnetworks:textures/gui/buttons/buttons.png");
    public static final ResourceLocation navigation = new ResourceLocation("fluxnetworks:textures/gui/navigation.png");
    public static final CustomColour[] colours = new CustomColour[]{new CustomColour(41, 94, 138), new CustomColour(52, 52, 119), new CustomColour(88, 42, 114), new CustomColour(136, 45, 96), new CustomColour(170, 57, 57), new CustomColour(170, 111, 57), new CustomColour(198, 185, 0), new CustomColour(96, 151, 50)};
    public static final int midBlue = FontHelper.getIntFromColor((int)41, (int)94, (int)138);
    public static final int lightBlue = FontHelper.getIntFromColor((int)90, (int)180, (int)255);
    public static final int darkBlue = FontHelper.getIntFromColor((int)37, (int)61, (int)81);
    public int errorDisplayTicks;
    public int errorDisplayTime = 300;
    public static GuiState state = GuiState.INDEX;
    public TileEntityFlux tile;

    public GuiFluxBase(Container container, TileEntityFlux tile) {
        super(container, (IWorldPosition)tile);
        this.tile = tile;
        this.tile.error = FluxError.NONE;
    }

    public void renderFlux(IFlux network, boolean isSelected, int x, int y) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int colour = midBlue;
        switch (network.getConnectionType()) {
            case POINT: {
                colour = new CustomColour(136, 40, 40).getRGB();
                break;
            }
            case PLUG: {
                colour = colours[7].getRGB();
                break;
            }
            case STORAGE: {
                colour = midBlue;
                break;
            }
            case CONTROLLER: {
                colour = new CustomColour(100, 100, 120).getRGB();
                break;
            }
        }
        GuiFluxBase.func_73734_a((int)x, (int)y, (int)(x + 154), (int)(y + 12), (int)colour);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(state.getBackground());
        this.func_73729_b(x, y, 0, 166, 154, 12);
        FontHelper.text((String)network.getCustomName(), (int)(x + 3), (int)(y + 2), (int)(isSelected ? Color.WHITE.getRGB() : Color.DARK_GRAY.getRGB()));
    }

    public void renderNetwork(String networkName, AccessType access, int rgb, boolean isSelected, int x, int y) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiFluxBase.func_73734_a((int)x, (int)y, (int)(x + 154), (int)(y + 12), (int)rgb);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(select);
        this.func_73729_b(x, y, 0, 166, 154, 12);
        FontHelper.text((String)networkName, (int)(x + 3), (int)(y + 2), (int)(isSelected ? Color.WHITE.getRGB() : Color.DARK_GRAY.getRGB()));
    }

    public void renderNetworkInFull(String networkName, AccessType access, int rgb, boolean isSelected, int x, int y) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiFluxBase.func_73734_a((int)x, (int)y, (int)(x + 154), (int)(y + 24), (int)rgb);
        GuiFluxBase.func_73734_a((int)(x + 1), (int)(y + 1), (int)(x + 154 - 1), (int)(y + 24 - 1), (int)Color.BLACK.getRGB());
        FontHelper.text((String)(TextFormatting.BOLD + networkName), (int)(x + 3), (int)(y + 2), (int)(isSelected ? Color.WHITE.getRGB() : Color.DARK_GRAY.getRGB()));
        FontHelper.text((String)(FontHelper.translate((String)"network.accessSetting") + ": " + TextFormatting.AQUA + FontHelper.translate((String)access.getName())), (int)(x + 3), (int)(y + 13), (int)0);
    }

    public void renderEnergyBar(int x, int y, long stored, long max, int startCol, int endCol) {
        GuiFluxBase.func_73734_a((int)x, (int)y, (int)(this.field_146999_f - x), (int)(y + 16), (int)Color.DARK_GRAY.getRGB());
        GuiFluxBase.func_73734_a((int)(x + 1), (int)(y + 1), (int)(this.field_146999_f - x - 1), (int)(y + 15), (int)Color.BLACK.getRGB());
        if (max != 0L && stored != 0L) {
            long k = stored * (long)(this.field_146999_f - x * 2) / max;
            this.func_73733_a(x + 1, y + 1, (int)((long)(x - 1) + k), y + 15, startCol, endCol);
        }
        FontHelper.textCentre((String)(FontHelper.formatStorage((long)stored) + '/' + FontHelper.formatStorage((long)max)), (int)this.field_146999_f, (int)(y + 4), (int)-1);
    }

    public void renderNavigationPrompt(String error, String prompt) {
        FontHelper.textCentre((String)FontHelper.translate((String)error), (int)this.field_146999_f, (int)10, (int)Color.GRAY.getRGB());
        GlStateManager.func_179139_a((double)0.75, (double)0.75, (double)0.75);
        FontHelper.textCentre((String)("Click" + TextFormatting.AQUA + ' ' + prompt + ' ' + TextFormatting.RESET + "Above"), (int)((int)((double)this.field_146999_f * 1.0 / 0.75)), (int)26, (int)Color.GRAY.getRGB());
        GlStateManager.func_179139_a((double)1.3333333333333333, (double)1.3333333333333333, (double)1.3333333333333333);
    }

    public void drawCreativeTabHoveringText(String tabName, int mouseX, int mouseY) {
        if (this.tile.error == FluxError.NONE) {
            this.drawSonarCreativeTabHoveringText(tabName, mouseX, mouseY);
        }
    }

    public void func_146283_a(List<String> textLines, int x, int y) {
        if (this.tile.error == FluxError.NONE) {
            super.func_146283_a(textLines, x, y);
        }
    }

    protected void drawError(int x, int y) {
        if (this.tile.error != FluxError.NONE) {
            if (this.errorDisplayTicks < this.errorDisplayTime) {
                ++this.errorDisplayTicks;
                this.drawHoveringText(Collections.singletonList(TextFormatting.RED + "" + TextFormatting.BOLD + FontHelper.translate((String)this.tile.error.getErrorMessage())), x, y, this.field_146289_q);
            } else {
                this.errorDisplayTicks = 0;
                this.tile.error = FluxError.NONE;
            }
        }
    }

    public void switchState(GuiState state) {
        PacketHelper.sendPacketToServer(PacketType.GUI_STATE_CHANGE, this.tile, PacketHelper.createStateChangePacket(state.type));
        GuiFluxBase.state = state;
        this.doReset();
    }

    public int getNetworkID() {
        return (Integer)this.tile.networkID.getObject();
    }

    public List<? extends IFluxCommon> getNetworks() {
        return FluxNetworks.getClientCache().getAllNetworks();
    }

    public void setNetwork(IFluxCommon network) {
        if (network.getNetworkID() != -1) {
            PacketHelper.sendPacketToServer(PacketType.SET_NETWORK, this.tile, PacketHelper.createNetworkSetPacket(network.getNetworkID()));
        }
    }

    public ResourceLocation getBackground() {
        return state.getBackground();
    }

    public SelectButtons selectButton(int id, int x, int y, int texX, String name) {
        return new SelectButtons(id, x, y, texX, name);
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    public List<GuiButton> getButtonList() {
        return this.field_146292_n;
    }

    public int getXSize() {
        return this.field_146999_f;
    }

    public int getYSize() {
        return this.field_147000_g;
    }

    @SideOnly(value=Side.CLIENT)
    public static class NetworkButton
    extends SonarButtons.ImageButton {
        public NetworkButton(int id, int x, int y) {
            super(id, x, y, bground, 0, 190, 154, 11);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class NavigationButtons
    extends SonarButtons.ImageButton {
        public int field_146127_k;
        public GuiState buttonState;

        public NavigationButtons(GuiState state, int id, int x, int y) {
            super(id, x, y, navigation, state.texX / 2, 0, 16, 16);
            this.field_146127_k = id;
            this.buttonState = state;
        }

        public void func_146111_b(int x, int y) {
            GuiFluxBase.this.drawCreativeTabHoveringText(FontHelper.translate((String)this.buttonState.getClientName()), x, y);
        }

        public void func_191745_a(Minecraft mc, int x, int y, float partialTicks) {
            if (this.field_146125_m) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_146123_n = x >= this.field_146128_h && y >= this.field_146129_i && x < this.field_146128_h + this.field_146120_f + 1 && y < this.field_146129_i + this.field_146121_g + 1;
                mc.func_110434_K().func_110577_a(this.texture);
                GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)0.5);
                this.func_175174_a((float)((double)this.field_146128_h / 0.5), (float)((double)this.field_146129_i / 0.5), this.textureX, state == this.buttonState ? this.textureY : this.textureY + 32, this.sizeX * 2, this.sizeY * 2);
                GlStateManager.func_179139_a((double)2.0, (double)2.0, (double)2.0);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class SelectButtons
    extends SonarButtons.ImageButton {
        public int field_146127_k;
        public String name;

        public SelectButtons(int id, int x, int y, int texX, String name) {
            super(id, x, y, buttons, texX / 2, 0, 11, 11);
            this.field_146127_k = id;
            this.name = name;
        }

        public void func_146111_b(int x, int y) {
            GuiFluxBase.this.drawCreativeTabHoveringText(FontHelper.translate((String)this.name), x, y);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class ConfigNetworkButton
    extends SonarButtons.ImageButton {
        public ConfigNetworkButton(int id, int x, int y) {
            super(id, x, y, new ResourceLocation("fluxnetworks:textures/gui/buttons/buttons.png"), 0, 0, 16, 16);
        }

        public void func_191745_a(Minecraft mc, int x, int y, float partialTicks) {
            super.func_191745_a(mc, x, y, partialTicks);
            this.field_146123_n = x >= this.field_146128_h && y >= this.field_146129_i && x < this.field_146128_h + this.field_146120_f && y < this.field_146129_i + this.field_146121_g;
            this.textureY = this.field_146123_n ? 0 : 17;
        }

        public void func_146111_b(int x, int y) {
            GuiFluxBase.this.drawCreativeTabHoveringText("Configure Network", x, y);
        }
    }
}

