/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.client;

import java.awt.Color;
import java.io.IOException;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.input.Keyboard;
import sonar.core.client.gui.SonarTextField;
import sonar.core.client.gui.widgets.SonarScroller;
import sonar.core.helpers.FontHelper;
import sonar.flux.FluxNetworks;
import sonar.flux.api.network.IFluxCommon;
import sonar.flux.api.network.IFluxNetwork;
import sonar.flux.api.tiles.IFlux;
import sonar.flux.api.tiles.IFluxController;
import sonar.flux.client.GUI;
import sonar.flux.client.GuiFluxBase;
import sonar.flux.client.GuiState;
import sonar.flux.common.tileentity.TileEntityFlux;
import sonar.flux.common.tileentity.TileEntityStorage;
import sonar.flux.connection.EmptyFluxNetwork;

public class GuiFlux
extends GuiFluxBase {
    public EntityPlayer player;
    public IFluxCommon common = EmptyFluxNetwork.INSTANCE;
    public boolean disabledState;

    public GuiFlux(Container container, TileEntityFlux tile, EntityPlayer player) {
        super(container, tile);
        this.player = player;
    }

    public void func_146281_b() {
        super.func_146281_b();
        state = GuiState.INDEX;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.common = FluxNetworks.getClientCache().getNetwork(this.getNetworkID());
        Keyboard.enableRepeatEvents((boolean)true);
        this.field_146999_f = GuiFlux.state.x;
        this.field_147000_g = GuiFlux.state.y;
        this.field_146297_k.field_71439_g.field_71070_bA = this.field_147002_h;
        this.field_147003_i = (this.field_146294_l - this.field_146999_f) / 2;
        this.field_147009_r = (this.field_146295_m - this.field_147000_g) / 2;
        this.disabledState = false;
        int i = 0;
        for (GuiState state : GuiState.VALUES) {
            this.field_146292_n.add(new GuiFluxBase.NavigationButtons(this, state, -i, this.field_147003_i + 2 + 18 * i, this.field_147009_r - 15));
            ++i;
        }
        state.init(this);
    }

    public boolean isSelectedNetwork(IFluxCommon network) {
        return network.getNetworkName().equals(this.common.getNetworkName()) && network.getNetworkID() == this.getNetworkID() && network.getCachedPlayerName().equals(this.common.getCachedPlayerName());
    }

    public void drawScreen(IFlux flux, IFlux.ConnectionType type) {
        int colour = this.common.getNetworkColour().getRGB();
        FontHelper.text((String)((Object)((Object)GUI.NETWORK_NAME) + ": "), (int)7, (int)30, (int)colour);
        FontHelper.text((String)((Object)((Object)GUI.PRIORITY) + ":"), (int)7, (int)48, (int)colour);
        FontHelper.text((String)((Object)((Object)GUI.MAX) + ":"), (int)87, (int)48, (int)colour);
        FontHelper.text((String)((Object)((Object)GUI.IGNORE_LIMIT) + ": " + TextFormatting.WHITE + ((Boolean)this.tile.disableLimit.getObject()).toString()), (int)7, (int)66, (int)colour);
        this.renderNetwork(this.common.getNetworkName(), this.common.getAccessType(), this.common.getNetworkColour().getRGB(), true, 11, 8);
        switch (type) {
            case CONTROLLER: {
                IFluxController controller = (IFluxController)flux;
                FontHelper.text((String)(TextFormatting.DARK_GRAY + FontHelper.translate((String)"network.sendMode") + TextFormatting.DARK_GRAY + ": " + TextFormatting.RESET + FontHelper.translate((String)controller.getSendMode().getName())), (int)8, (int)84, (int)colour);
                FontHelper.text((String)(TextFormatting.DARK_GRAY + FontHelper.translate((String)"network.receiveMode") + TextFormatting.DARK_GRAY + ": " + TextFormatting.RESET + FontHelper.translate((String)controller.getReceiveMode().getName())), (int)8, (int)104, (int)colour);
                FontHelper.text((String)(TextFormatting.DARK_GRAY + FontHelper.translate((String)"network.transferMode") + TextFormatting.DARK_GRAY + ": " + TextFormatting.RESET + FontHelper.translate((String)controller.getTransferMode().getName()) + (controller.getTransferMode().isBanned() ? TextFormatting.RED + " BANNED" : "")), (int)8, (int)124, (int)colour);
                FontHelper.text((String)(TextFormatting.DARK_GRAY + FontHelper.translate((String)"network.transmitterMode") + TextFormatting.DARK_GRAY + ": " + TextFormatting.RESET + FontHelper.translate((String)controller.getTransmitterMode().getName())), (int)8, (int)144, (int)colour);
                break;
            }
            case PLUG: {
                break;
            }
            case POINT: {
                break;
            }
            case STORAGE: {
                TileEntityStorage entity = (TileEntityStorage)flux;
                this.renderEnergyBar(14, 94, entity.storage.getEnergyStored(), entity.storage.getMaxEnergyStored(), midBlue, FontHelper.getIntFromColor((int)41, (int)94, (int)220));
                IFluxNetwork common = FluxNetworks.getClientCache().getNetwork((Integer)this.tile.networkID.getObject());
                this.renderEnergyBar(14, 134, common.getEnergyAvailable(), common.getMaxEnergyStored(), colour, colour);
                FontHelper.text((String)"Local Buffer: ", (int)14, (int)84, (int)Color.DARK_GRAY.getRGB());
                FontHelper.text((String)("Network Buffer: " + (common.getEnergyAvailable() != 0L ? (long)(entity.storage.getEnergyStored() * 100) / common.getEnergyAvailable() + " %" : "")), (int)14, (int)124, (int)colour);
                break;
            }
        }
    }

    public void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        if (!this.disabledState) {
            for (SonarTextField field : state.getFields(this)) {
                field.func_146194_f();
            }
        }
        this.common = FluxNetworks.getClientCache().getNetwork(this.getNetworkID());
        state.draw(this, x, y);
        this.drawError(x - this.field_147003_i, y - this.field_147009_r);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.forScrollers(s -> s.handleMouse(state.needsScrollBars(), state.getSelectionSize(this)));
    }

    public void func_73863_a(int x, int y, float var) {
        super.func_73863_a(x, y, var);
        this.forScrollers(s -> s.drawScreen(x, y, state.needsScrollBars()));
    }

    protected void func_146284_a(GuiButton button) {
        if (button != null) {
            if (button instanceof GuiFluxBase.NavigationButtons) {
                this.switchState(((GuiFluxBase.NavigationButtons)button).buttonState);
                this.reset();
                return;
            }
            if (!this.disabledState) {
                state.button(this, button);
            }
        }
    }

    public void func_73864_a(int x, int y, int mouseButton) throws IOException {
        super.func_73864_a(x, y, mouseButton);
        if (!this.disabledState) {
            for (SonarTextField field : state.getFields(this)) {
                field.func_146192_a(x - this.field_147003_i, y - this.field_147009_r, mouseButton);
            }
            state.click(this, x, y, mouseButton);
        }
    }

    public void func_73869_a(char c, int i) throws IOException {
        if (this.disabledState) {
            super.func_73869_a(c, i);
            return;
        }
        for (SonarTextField field : state.getFields(this)) {
            if (field == null || !field.func_146206_l()) continue;
            if (c == '\r' || c == '\u001b') {
                field.func_146195_b(false);
            } else {
                field.func_146201_a(c, i);
                state.textboxKeyTyped(this, field, c, i);
            }
            return;
        }
        if (state.type(this, c, i)) {
            super.func_73869_a(c, i);
        }
    }

    protected void func_146976_a(float var1, int var2, int var3) {
        super.func_146976_a(var1, var2, var3);
        this.forScrollers(s -> this.func_73729_b(s.left, s.top + (int)((float)(s.length - 17) * s.getCurrentScroll()), 176, 0, 10, 15));
    }

    public void forScrollers(Consumer<SonarScroller> action) {
        SonarScroller[] scrollers;
        for (SonarScroller scroller : scrollers = state.getScrollers()) {
            if (scroller == null) continue;
            action.accept(scroller);
        }
    }
}

