/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.api.tiles;

import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import sonar.core.api.utils.BlockCoords;
import sonar.flux.api.network.IFluxNetwork;
import sonar.flux.api.network.PlayerAccess;

public interface IFlux {
    public int getNetworkID();

    public IFluxNetwork getNetwork();

    public UUID getConnectionOwner();

    public PlayerAccess canAccess(EntityPlayer var1);

    public World getDimension();

    public BlockCoords getCoords();

    public ConnectionType getConnectionType();

    public long getTransferLimit();

    public long getCurrentTransferLimit();

    public long getCurrentTransfer(EnumFacing var1);

    public long getValidTransfer(long var1, EnumFacing var3);

    public void onEnergyRemoved(EnumFacing var1, long var2);

    public void onEnergyAdded(EnumFacing var1, long var2);

    public void setMaxSend(long var1);

    public void setMaxReceive(long var1);

    public int getCurrentPriority();

    public String getCustomName();

    public TileEntity[] cachedTiles();

    public boolean canTransfer();

    public void updateNeighbours(boolean var1);

    public void connect(IFluxNetwork var1);

    public void disconnect(IFluxNetwork var1);

    public static enum ConnectionType {
        POINT,
        PLUG,
        STORAGE,
        CONTROLLER;


        public boolean canSend() {
            return this == PLUG || this == STORAGE;
        }

        public boolean canReceive() {
            return this == POINT || this == STORAGE || this == CONTROLLER;
        }
    }
}

