/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.api.network;

import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.ISyncableListener;
import sonar.flux.api.network.FluxPlayer;

public class FluxPlayersList
extends ArrayList<FluxPlayer>
implements IDirtyPart,
INBTSyncable {
    public boolean hasChanged = true;
    private ISyncableListener listener;

    public boolean containsUUID(UUID check) {
        for (FluxPlayer player : this) {
            if (player == null || !player.id.equals(check)) continue;
            return true;
        }
        return false;
    }

    public boolean containsPlayer(FluxPlayer check) {
        for (FluxPlayer player : this) {
            if (player == null || !player.equals(check)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean add(FluxPlayer player) {
        if (!this.containsPlayer(player)) {
            super.add(player);
            this.markChanged();
            return this.hasChanged;
        }
        return false;
    }

    public boolean remove(FluxPlayer player) {
        this.markChanged();
        super.remove(player);
        return this.hasChanged;
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (nbt.func_74764_b("playerList")) {
            NBTTagList list = nbt.func_150295_c("playerList", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound tag = list.func_150305_b(i);
                this.add(new FluxPlayer(tag));
            }
        }
    }

    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (this.hasChanged || type.mustSync()) {
            NBTTagList list = new NBTTagList();
            this.forEach((? super E player) -> list.func_74742_a((NBTBase)player.writeData(new NBTTagCompound(), type)));
            nbt.func_74782_a("playerList", (NBTBase)list);
        }
        return nbt;
    }

    public FluxPlayersList setListener(ISyncableListener listener) {
        this.listener = listener;
        return this;
    }

    public ISyncableListener getListener() {
        return this.listener;
    }

    public void markChanged() {
        if (this.listener != null) {
            this.listener.markChanged((IDirtyPart)this);
        }
    }
}

