/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.api.network;

import java.util.UUID;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.FMLCommonHandler;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.helpers.NBTHelper;
import sonar.core.helpers.SonarHelper;
import sonar.flux.api.network.PlayerAccess;

public class FluxPlayer
implements INBTSyncable {
    public UUID id;
    public String cachedName = "";
    public PlayerAccess access;

    public FluxPlayer(UUID id, PlayerAccess access, String cachedName) {
        this(id, access);
        this.cachedName = cachedName;
    }

    public FluxPlayer(UUID id, PlayerAccess access) {
        this.id = id;
        this.access = access;
    }

    public FluxPlayer(NBTTagCompound tag) {
        this.readData(tag, NBTHelper.SyncType.SAVE);
        if (this.cachedName.isEmpty() && FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            this.cachedName = SonarHelper.getProfileByUUID((UUID)this.id).getName();
        }
    }

    public UUID getUUID() {
        return this.id;
    }

    public String getCachedName() {
        return this.cachedName;
    }

    public PlayerAccess getAccess() {
        return this.access;
    }

    public void setAccess(PlayerAccess access) {
        this.access = access;
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        this.id = nbt.func_186857_a("playerUUID");
        this.cachedName = nbt.func_74779_i("cachedName");
        this.access = PlayerAccess.values()[nbt.func_74771_c("playerAccess")];
    }

    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        nbt.func_186854_a("playerUUID", this.id);
        nbt.func_74778_a("cachedName", this.cachedName);
        nbt.func_74774_a("playerAccess", (byte)this.access.ordinal());
        return nbt;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof FluxPlayer) {
            FluxPlayer player = (FluxPlayer)obj;
            return player.id.equals(this.id) && player.access.equals((Object)this.access);
        }
        return false;
    }
}

