/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.api;

import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import sonar.core.api.utils.BlockCoords;
import sonar.flux.api.network.IFluxNetwork;
import sonar.flux.api.network.PlayerAccess;
import sonar.flux.api.tiles.IFlux;
import sonar.flux.connection.EmptyFluxNetwork;

public class ClientFlux
implements IFlux {
    public BlockCoords coords;
    public IFlux.ConnectionType type;
    public int priority;
    public long limit;
    public String customName;

    public ClientFlux(IFlux flux) {
        this.coords = flux.getCoords();
        this.type = flux.getConnectionType();
        this.priority = flux.getCurrentPriority();
        this.limit = flux.getTransferLimit();
        this.customName = flux.getCustomName();
    }

    public ClientFlux(BlockCoords coords, IFlux.ConnectionType type, int priority, long limit, String customName) {
        this.coords = coords;
        this.type = type;
        this.priority = priority;
        this.limit = limit;
        this.customName = customName;
    }

    @Override
    public World getDimension() {
        return this.coords.getWorld();
    }

    @Override
    public BlockCoords getCoords() {
        return this.coords;
    }

    @Override
    public IFluxNetwork getNetwork() {
        return EmptyFluxNetwork.INSTANCE;
    }

    @Override
    public IFlux.ConnectionType getConnectionType() {
        return this.type;
    }

    @Override
    public long getTransferLimit() {
        return this.limit;
    }

    @Override
    public int getCurrentPriority() {
        return this.priority;
    }

    @Override
    public String getCustomName() {
        return this.customName;
    }

    @Override
    public long getCurrentTransferLimit() {
        return this.limit;
    }

    @Override
    public void onEnergyRemoved(EnumFacing face, long remove) {
    }

    @Override
    public void onEnergyAdded(EnumFacing face, long added) {
    }

    @Override
    public TileEntity[] cachedTiles() {
        return new TileEntity[0];
    }

    @Override
    public boolean canTransfer() {
        return false;
    }

    @Override
    public UUID getConnectionOwner() {
        return null;
    }

    @Override
    public int getNetworkID() {
        return -1;
    }

    @Override
    public void updateNeighbours(boolean full) {
    }

    @Override
    public void connect(IFluxNetwork network) {
    }

    @Override
    public void disconnect(IFluxNetwork network) {
    }

    @Override
    public long getCurrentTransfer(EnumFacing face) {
        return 0L;
    }

    @Override
    public long getValidTransfer(long valid, EnumFacing face) {
        return 0L;
    }

    @Override
    public void setMaxSend(long send) {
    }

    @Override
    public void setMaxReceive(long receive) {
    }

    @Override
    public PlayerAccess canAccess(EntityPlayer player) {
        return PlayerAccess.SHARED_OWNER;
    }
}

