/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import sonar.core.SonarRegister;
import sonar.core.api.energy.ISonarEnergyContainerHandler;
import sonar.core.api.energy.ISonarEnergyHandler;
import sonar.flux.FluxConfig;
import sonar.flux.FluxCrafting;
import sonar.flux.FluxEvents;
import sonar.flux.api.FluxAPI;
import sonar.flux.common.block.FluxController;
import sonar.flux.common.block.FluxPlug;
import sonar.flux.common.block.FluxPoint;
import sonar.flux.common.block.FluxStorage;
import sonar.flux.common.entity.EntityFireItem;
import sonar.flux.common.item.AdminConfigurator;
import sonar.flux.common.item.FluxConfigurator;
import sonar.flux.common.item.FluxItem;
import sonar.flux.common.tileentity.TileEntityController;
import sonar.flux.common.tileentity.TileEntityPlug;
import sonar.flux.common.tileentity.TileEntityPoint;
import sonar.flux.common.tileentity.TileEntityStorage;
import sonar.flux.connection.FluxHelper;
import sonar.flux.network.ClientNetworkCache;
import sonar.flux.network.FluxCommon;
import sonar.flux.network.FluxNetworkCache;
import sonar.flux.network.NetworkData;

@Mod(modid="fluxnetworks", name="FluxNetworks", acceptedMinecraftVersions="[1.12,1.12.2]", version="3.0.5", dependencies="required-after:sonarcore@[5.0.6,);")
public class FluxNetworks {
    public static final String name = "FluxNetworks";
    public static final String modid = "fluxnetworks";
    public static final String version = "3.0.5";
    public static final String mc_versions = "[1.12,1.12.2]";
    public static final String SONAR_VERSION = "5.0.6";
    public static final int saveDimension = 0;
    @SidedProxy(clientSide="sonar.flux.network.FluxClient", serverSide="sonar.flux.network.FluxCommon")
    public static FluxCommon proxy;
    @Mod.Instance(value="fluxnetworks")
    public static FluxNetworks instance;
    public FluxNetworkCache serverCache = new FluxNetworkCache();
    public ClientNetworkCache clientCache = new ClientNetworkCache();
    public static List<ISonarEnergyHandler> energyHandlers;
    public static List<ISonarEnergyContainerHandler> energyContainerHandlers;
    public static SimpleNetworkWrapper network;
    public static Logger logger;
    public static Item flux;
    public static Item fluxCore;
    public static Item fluxConfigurator;
    public static Item adminConfigurator;
    public static Block fluxBlock;
    public static Block fluxPlug;
    public static Block fluxPoint;
    public static Block fluxCable;
    public static Block fluxStorage;
    public static Block largeFluxStorage;
    public static Block massiveFluxStorage;
    public static Block fluxController;
    public static CreativeTabs tab;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger.info("Initialising API");
        FluxAPI.init();
        logger.info("Loading Config");
        FluxConfig.startLoading();
        logger.info("Loading Network");
        network = NetworkRegistry.INSTANCE.newSimpleChannel("Flux-Networks");
        logger.info("Loading Blocks/Items");
        fluxBlock = SonarRegister.addBlock((String)modid, (CreativeTabs)tab, (String)"FluxBlock", (Block)new Block(Material.field_151576_e));
        flux = SonarRegister.addItem((String)modid, (CreativeTabs)tab, (String)"Flux", (Item)new FluxItem());
        fluxCore = SonarRegister.addItem((String)modid, (CreativeTabs)tab, (String)"FluxCore", (Item)new Item());
        fluxConfigurator = SonarRegister.addItem((String)modid, (CreativeTabs)tab, (String)"FluxConfigurator", (Item)new FluxConfigurator());
        adminConfigurator = SonarRegister.addItem((String)modid, (CreativeTabs)tab, (String)"AdminConfigurator", (Item)new AdminConfigurator());
        fluxPlug = SonarRegister.addBlock((String)modid, (CreativeTabs)tab, (String)"FluxPlug", (Block)new FluxPlug().func_149711_c(0.4f).func_149752_b(20.0f));
        GameRegistry.registerTileEntity(TileEntityPlug.class, (String)"FluxPlug");
        fluxPoint = SonarRegister.addBlock((String)modid, (CreativeTabs)tab, (String)"FluxPoint", (Block)new FluxPoint().func_149711_c(0.2f).func_149752_b(20.0f));
        GameRegistry.registerTileEntity(TileEntityPoint.class, (String)"FluxPoint");
        fluxController = SonarRegister.addBlock((String)modid, (CreativeTabs)tab, (String)"FluxController", (Block)new FluxController().func_149711_c(0.6f).func_149752_b(20.0f));
        GameRegistry.registerTileEntity(TileEntityController.class, (String)"FluxController");
        fluxStorage = SonarRegister.addBlock((String)modid, (CreativeTabs)tab, (String)"FluxStorage", (Block)new FluxStorage().func_149711_c(0.6f).func_149752_b(20.0f));
        GameRegistry.registerTileEntity(TileEntityStorage.Basic.class, (String)"FluxStorage");
        largeFluxStorage = SonarRegister.addBlock((String)modid, (CreativeTabs)tab, (String)"HerculeanFluxStorage", (Block)new FluxStorage.Herculean().func_149711_c(0.6f).func_149752_b(20.0f));
        GameRegistry.registerTileEntity(TileEntityStorage.Herculean.class, (String)"HerculeanFluxStorage");
        massiveFluxStorage = SonarRegister.addBlock((String)modid, (CreativeTabs)tab, (String)"GargantuanFluxStorage", (Block)new FluxStorage.Gargantuan().func_149711_c(0.6f).func_149752_b(20.0f));
        GameRegistry.registerTileEntity(TileEntityStorage.Gargantuan.class, (String)"GargantuanFluxStorage");
        logger.info("Loading Entities");
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(modid, "Flux"), EntityFireItem.class, (String)"Flux", (int)0, (Object)instance, (int)64, (int)10, (boolean)true);
        logger.info("Loading Recipes");
        FluxCrafting.addRecipes();
        logger.info("Loading Packets");
        FluxCommon.registerPackets();
        logger.info("Loading Renderers");
        proxy.registerRenderThings();
        logger.info("Finished Pre-Initialization");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        logger.info("Loading Handlers");
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new FluxCommon());
        logger.info("Loaded Handlers");
        logger.info("Loading Handlers");
        MinecraftForge.EVENT_BUS.register((Object)new FluxEvents());
        logger.info("Loaded Events");
        logger.info("Finished Initialization");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        FluxConfig.finishLoading();
        energyHandlers = FluxHelper.getEnergyHandlers();
        energyContainerHandlers = FluxHelper.getEnergyContainerHandlers();
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        MapStorage storage = DimensionManager.getWorld((int)0).func_175693_T();
        if (storage.func_75742_a(NetworkData.class, "sonar.flux.networks.configurations") == null) {
            storage.func_75745_a("sonar.flux.networks.configurations", (WorldSavedData)new NetworkData());
        }
    }

    @Mod.EventHandler
    public void onServerStopped(FMLServerStoppedEvent event) {
        this.serverCache.clearNetworks();
        this.clientCache.clearNetworks();
        logger.info("Cleared Network Caches");
    }

    public static ClientNetworkCache getClientCache() {
        return FluxNetworks.instance.clientCache;
    }

    public static FluxNetworkCache getServerCache() {
        return FluxNetworks.instance.serverCache;
    }

    static {
        logger = LogManager.getLogger((String)modid);
        tab = new CreativeTabs("Flux Networks"){

            public ItemStack func_78016_d() {
                return new ItemStack(Item.func_150898_a((Block)fluxPlug));
            }
        };
    }
}

