/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import sonar.core.SonarCore;
import sonar.flux.FluxConfig;
import sonar.flux.FluxNetworks;
import sonar.flux.api.FluxListener;
import sonar.flux.api.network.IFluxNetwork;
import sonar.flux.common.entity.EntityFireItem;
import sonar.flux.network.FluxNetworkCache;

public class FluxEvents {
    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.side == Side.CLIENT) {
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            FluxNetworkCache cache = FluxNetworks.getServerCache();
            List networks = cache.getAllNetworks();
            for (IFluxNetwork network : networks) {
                network.updateNetwork();
            }
            if (cache.getListenerList().hasListeners(FluxListener.ADMIN.ordinal())) {
                cache.updateAdminListeners();
            }
        }
    }

    @SubscribeEvent
    public void dropFluxEvent(BlockEvent.HarvestDropsEvent drops) {
        if (!FluxConfig.enableFluxRedstoneDrop || drops.getState().func_177230_c() != Blocks.field_150450_ax && drops.getState().func_177230_c() != Blocks.field_150439_ay || drops.getHarvester() instanceof FakePlayer || drops.isSilkTouching()) {
            return;
        }
        if (SonarCore.randInt((int)0, (int)FluxConfig.redstone_ore_chance) == 1) {
            drops.getDrops().add(new ItemStack(FluxNetworks.flux, Math.max(1, SonarCore.randInt((int)FluxConfig.redstone_ore_min_drop, (int)FluxConfig.redstone_ore_max_drop))));
        }
    }

    @SubscribeEvent
    public void onEntityAdded(EntityJoinWorldEvent event) {
        EntityItem entityItem;
        ItemStack stack;
        if (!FluxConfig.enableFluxRecipe || event.getWorld().field_72995_K) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof EntityItem && !(entity instanceof EntityFireItem) && !(stack = (entityItem = (EntityItem)entity).func_92059_d()).func_190926_b() && stack.func_77973_b() == Items.field_151137_ax) {
            EntityFireItem newEntity = new EntityFireItem(event.getWorld(), entityItem.field_70165_t, entityItem.field_70163_u, entityItem.field_70161_v, stack);
            newEntity.field_70159_w = entityItem.field_70159_w;
            newEntity.field_70181_x = entityItem.field_70181_x;
            newEntity.field_70179_y = entityItem.field_70179_y;
            newEntity.func_174869_p();
            if (newEntity != null) {
                event.getEntity().func_70106_y();
                event.getWorld().func_72838_d((Entity)newEntity);
            }
        }
    }

    public static void logNewNetwork(IFluxNetwork network) {
        FluxNetworks.logger.info("[NEW NETWORK] '" + network.getNetworkName() + "' with ID '" + network.getNetworkID() + "' was created by " + network.getCachedPlayerName());
    }

    public static void logRemoveNetwork(IFluxNetwork network) {
        FluxNetworks.logger.info("[DELETE NETWORK] '" + network.getNetworkName() + "' with ID '" + network.getNetworkID() + "' was removed by " + network.getCachedPlayerName());
    }

    public static void logLoadedNetwork(IFluxNetwork network) {
        FluxNetworks.logger.info("[LOADED NETWORK] '" + network.getNetworkName() + "' with ID '" + network.getNetworkID() + "' with owner " + network.getCachedPlayerName());
    }
}

