/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.transmitter;

import cofh.redstoneflux.api.IEnergyProvider;
import cofh.redstoneflux.api.IEnergyReceiver;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.List;
import mekanism.api.energy.EnergyStack;
import mekanism.api.energy.IStrictEnergyAcceptor;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.Tier;
import mekanism.common.base.EnergyAcceptorWrapper;
import mekanism.common.base.TileNetworkList;
import mekanism.common.block.states.BlockStateTransmitter;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.CapabilityWrapperManager;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.forgeenergy.ForgeEnergyCableIntegration;
import mekanism.common.integration.tesla.TeslaCableIntegration;
import mekanism.common.tile.transmitter.TileEntitySidedPipe;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.transmitters.grid.EnergyNetwork;
import mekanism.common.util.CableUtils;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.MekanismUtils;
import net.darkhax.tesla.api.ITeslaProducer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(iface="cofh.redstoneflux.api.IEnergyReceiver", modid="redstoneflux")})
public class TileEntityUniversalCable
extends TileEntityTransmitter<EnergyAcceptorWrapper, EnergyNetwork>
implements IStrictEnergyAcceptor,
IStrictEnergyStorage,
IEnergyReceiver {
    public Tier.CableTier tier = Tier.CableTier.BASIC;
    public double currentPower = 0.0;
    public double lastWrite = 0.0;
    public EnergyStack buffer = new EnergyStack(0.0);
    private CapabilityWrapperManager teslaManager = new CapabilityWrapperManager(this.getClass(), TeslaCableIntegration.class);
    private CapabilityWrapperManager forgeEnergyManager = new CapabilityWrapperManager(this.getClass(), ForgeEnergyCableIntegration.class);

    @Override
    public Tier.BaseTier getBaseTier() {
        return this.tier.getBaseTier();
    }

    @Override
    public void setBaseTier(Tier.BaseTier baseTier) {
        this.tier = Tier.CableTier.get(baseTier);
    }

    @Override
    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            double targetPower;
            double d = targetPower = this.getTransmitter().hasTransmitterNetwork() ? ((EnergyNetwork)this.getTransmitter().getTransmitterNetwork()).clientEnergyScale : 0.0;
            if (Math.abs(this.currentPower - targetPower) > 0.01) {
                this.currentPower = (9.0 * this.currentPower + targetPower) / 10.0;
            }
        } else {
            this.updateShare();
            List<EnumFacing> sides = this.getConnections(TileEntitySidedPipe.ConnectionType.PULL);
            if (!sides.isEmpty()) {
                TileEntity[] connectedOutputters = CableUtils.getConnectedOutputters(this.func_174877_v(), this.func_145831_w());
                double canDraw = this.tier.cableCapacity;
                for (EnumFacing side : sides) {
                    IEnergyTile tile;
                    double toDraw;
                    double toDraw2;
                    double received;
                    if (connectedOutputters[side.ordinal()] == null) continue;
                    TileEntity outputter = connectedOutputters[side.ordinal()];
                    if (CapabilityUtils.hasCapability((ICapabilityProvider)outputter, Capabilities.ENERGY_OUTPUTTER_CAPABILITY, side.func_176734_d()) && CapabilityUtils.hasCapability((ICapabilityProvider)outputter, Capabilities.ENERGY_STORAGE_CAPABILITY, side.func_176734_d())) {
                        IStrictEnergyStorage storage = CapabilityUtils.getCapability((ICapabilityProvider)outputter, Capabilities.ENERGY_STORAGE_CAPABILITY, side.func_176734_d());
                        toDraw2 = received = Math.min(storage.getEnergy(), canDraw);
                        if (received > 0.0) {
                            toDraw2 -= this.takeEnergy(received, true);
                        }
                        storage.setEnergy(storage.getEnergy() - toDraw2);
                        continue;
                    }
                    if (MekanismUtils.useTesla() && CapabilityUtils.hasCapability((ICapabilityProvider)outputter, Capabilities.TESLA_PRODUCER_CAPABILITY, side.func_176734_d())) {
                        ITeslaProducer producer = CapabilityUtils.getCapability((ICapabilityProvider)outputter, Capabilities.TESLA_PRODUCER_CAPABILITY, side.func_176734_d());
                        toDraw = (double)producer.takePower(Math.round(Math.min(2.147483647E9, canDraw * MekanismConfig.general.TO_TESLA)), true) * MekanismConfig.general.FROM_TESLA;
                        if (toDraw > 0.0) {
                            toDraw -= this.takeEnergy(toDraw, true);
                        }
                        producer.takePower(Math.round(toDraw * MekanismConfig.general.TO_TESLA), false);
                        continue;
                    }
                    if (MekanismUtils.useForge() && CapabilityUtils.hasCapability((ICapabilityProvider)outputter, CapabilityEnergy.ENERGY, side.func_176734_d())) {
                        IEnergyStorage storage = (IEnergyStorage)CapabilityUtils.getCapability((ICapabilityProvider)outputter, CapabilityEnergy.ENERGY, side.func_176734_d());
                        toDraw = (double)storage.extractEnergy((int)Math.round(canDraw * MekanismConfig.general.TO_FORGE), true) * MekanismConfig.general.FROM_FORGE;
                        if (toDraw > 0.0) {
                            toDraw -= this.takeEnergy(toDraw, true);
                        }
                        storage.extractEnergy((int)Math.round(toDraw * MekanismConfig.general.TO_TESLA), false);
                        continue;
                    }
                    if (MekanismUtils.useRF() && outputter instanceof IEnergyProvider) {
                        double toDraw3 = (double)((IEnergyProvider)outputter).extractEnergy(side.func_176734_d(), (int)Math.round(Math.min(2.147483647E9, canDraw * MekanismConfig.general.TO_RF)), true) * MekanismConfig.general.FROM_RF;
                        if (toDraw3 > 0.0) {
                            toDraw3 -= this.takeEnergy(toDraw3, true);
                        }
                        ((IEnergyProvider)outputter).extractEnergy(side.func_176734_d(), (int)Math.round(toDraw3 * MekanismConfig.general.TO_RF), false);
                        continue;
                    }
                    if (!MekanismUtils.useIC2() || !((tile = EnergyNet.instance.getSubTile(outputter.func_145831_w(), outputter.func_174877_v())) instanceof IEnergySource)) continue;
                    toDraw2 = received = Math.min(((IEnergySource)tile).getOfferedEnergy() * MekanismConfig.general.FROM_IC2, canDraw);
                    if (received > 0.0) {
                        toDraw2 -= this.takeEnergy(received, true);
                    }
                    ((IEnergySource)tile).drawEnergy(toDraw2 * MekanismConfig.general.TO_IC2);
                }
            }
        }
        super.func_73660_a();
    }

    @Override
    public void updateShare() {
        double last;
        if (this.getTransmitter().hasTransmitterNetwork() && this.getTransmitter().getTransmitterNetworkSize() > 0 && (last = this.getSaveShare()) != this.lastWrite) {
            this.lastWrite = last;
            this.func_70296_d();
        }
    }

    private double getSaveShare() {
        if (this.getTransmitter().hasTransmitterNetwork()) {
            return EnergyNetwork.round(((EnergyNetwork)this.getTransmitter().getTransmitterNetwork()).buffer.amount * (double)(1.0f / (float)((EnergyNetwork)this.getTransmitter().getTransmitterNetwork()).transmitters.size()));
        }
        return this.buffer.amount;
    }

    @Override
    public BlockStateTransmitter.TransmitterType getTransmitterType() {
        return BlockStateTransmitter.TransmitterType.UNIVERSAL_CABLE;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.buffer.amount = nbtTags.func_74769_h("cacheEnergy");
        if (this.buffer.amount < 0.0) {
            this.buffer.amount = 0.0;
        }
        if (nbtTags.func_74764_b("tier")) {
            this.tier = Tier.CableTier.values()[nbtTags.func_74762_e("tier")];
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74780_a("cacheEnergy", this.lastWrite);
        nbtTags.func_74768_a("tier", this.tier.ordinal());
        return nbtTags;
    }

    @Override
    public TransmissionType getTransmissionType() {
        return TransmissionType.ENERGY;
    }

    @Override
    public EnergyNetwork createNetworkByMerging(Collection<EnergyNetwork> networks) {
        return new EnergyNetwork(networks);
    }

    @Override
    public boolean isValidAcceptor(TileEntity acceptor, EnumFacing side) {
        return CableUtils.isValidAcceptorOnSide(this.func_145831_w().func_175625_s(this.func_174877_v()), acceptor, side);
    }

    @Override
    public EnergyNetwork createNewNetwork() {
        return new EnergyNetwork();
    }

    @Override
    public Object getBuffer() {
        return this.buffer;
    }

    @Override
    public void takeShare() {
        if (this.getTransmitter().hasTransmitterNetwork()) {
            ((EnergyNetwork)this.getTransmitter().getTransmitterNetwork()).buffer.amount -= this.lastWrite;
            this.buffer.amount = this.lastWrite;
        }
    }

    @Optional.Method(modid="redstoneflux")
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return maxReceive - (int)Math.round(Math.min(2.147483647E9, this.takeEnergy((double)maxReceive * MekanismConfig.general.FROM_RF, !simulate) * MekanismConfig.general.TO_RF));
    }

    @Optional.Method(modid="redstoneflux")
    public boolean canConnectEnergy(EnumFacing from) {
        return this.canConnect(from);
    }

    @Optional.Method(modid="redstoneflux")
    public int getEnergyStored(EnumFacing from) {
        return (int)Math.round(Math.min(2.147483647E9, this.getEnergy() * MekanismConfig.general.TO_RF));
    }

    @Optional.Method(modid="redstoneflux")
    public int getMaxEnergyStored(EnumFacing from) {
        return (int)Math.round(Math.min(2.147483647E9, this.getMaxEnergy() * MekanismConfig.general.TO_RF));
    }

    @Override
    public int getCapacity() {
        return this.tier.cableCapacity;
    }

    @Override
    public double acceptEnergy(EnumFacing side, double amount, boolean simulate) {
        double toUse = Math.min(this.getMaxEnergy() - this.getEnergy(), amount);
        if (toUse < 1.0E-4 || side != null && !this.canReceiveEnergy(side)) {
            return 0.0;
        }
        if (!simulate) {
            this.setEnergy(this.getEnergy() + toUse);
        }
        return toUse;
    }

    @Override
    public boolean canReceiveEnergy(EnumFacing side) {
        if (side == null) {
            return true;
        }
        return this.getConnectionType(side) == TileEntitySidedPipe.ConnectionType.NORMAL;
    }

    @Override
    public double getMaxEnergy() {
        if (this.getTransmitter().hasTransmitterNetwork()) {
            return ((EnergyNetwork)this.getTransmitter().getTransmitterNetwork()).getCapacity();
        }
        return this.getCapacity();
    }

    @Override
    public double getEnergy() {
        if (this.getTransmitter().hasTransmitterNetwork()) {
            return ((EnergyNetwork)this.getTransmitter().getTransmitterNetwork()).buffer.amount;
        }
        return this.buffer.amount;
    }

    @Override
    public void setEnergy(double energy) {
        if (this.getTransmitter().hasTransmitterNetwork()) {
            ((EnergyNetwork)this.getTransmitter().getTransmitterNetwork()).buffer.amount = energy;
        } else {
            this.buffer.amount = energy;
        }
    }

    public double takeEnergy(double energy, boolean doEmit) {
        if (this.getTransmitter().hasTransmitterNetwork()) {
            return ((EnergyNetwork)this.getTransmitter().getTransmitterNetwork()).emit(energy, doEmit);
        }
        double used = Math.min((double)this.getCapacity() - this.buffer.amount, energy);
        if (doEmit) {
            this.buffer.amount += used;
        }
        return energy - used;
    }

    @Override
    public EnergyAcceptorWrapper getCachedAcceptor(EnumFacing side) {
        return EnergyAcceptorWrapper.get(this.getCachedTile(side), side.func_176734_d());
    }

    @Override
    public boolean upgrade(int tierOrdinal) {
        if (this.tier.ordinal() < Tier.BaseTier.ULTIMATE.ordinal() && tierOrdinal == this.tier.ordinal() + 1) {
            this.tier = Tier.CableTier.values()[this.tier.ordinal() + 1];
            this.markDirtyTransmitters();
            this.sendDesc = true;
            return true;
        }
        return false;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) throws Exception {
        this.tier = Tier.CableTier.values()[dataStream.readInt()];
        super.handlePacketData(dataStream);
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        data.add(this.tier.ordinal());
        super.getNetworkedData(data);
        return data;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == Capabilities.ENERGY_STORAGE_CAPABILITY || capability == Capabilities.ENERGY_ACCEPTOR_CAPABILITY || capability == Capabilities.TESLA_CONSUMER_CAPABILITY || capability == CapabilityEnergy.ENERGY || super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == Capabilities.ENERGY_STORAGE_CAPABILITY || capability == Capabilities.ENERGY_ACCEPTOR_CAPABILITY) {
            return (T)this;
        }
        if (capability == Capabilities.TESLA_CONSUMER_CAPABILITY) {
            return (T)this.teslaManager.getWrapper(this, facing);
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)this.forgeEnergyManager.getWrapper(this, facing);
        }
        return super.getCapability(capability, facing);
    }
}

