/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.component;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mekanism.api.EnumColor;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.SideData;
import mekanism.common.base.ITileComponent;
import mekanism.common.base.TileNetworkList;
import mekanism.common.tile.component.SideConfig;
import mekanism.common.tile.prefab.TileEntityContainerBlock;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public class TileComponentConfig
implements ITileComponent {
    public static SideData EMPTY = new SideData("Empty", EnumColor.BLACK, InventoryUtils.EMPTY);
    public TileEntityContainerBlock tileEntity;
    private Map<TransmissionType, SideConfig> sideConfigs = new HashMap<TransmissionType, SideConfig>();
    private Map<TransmissionType, ArrayList<SideData>> sideOutputs = new HashMap<TransmissionType, ArrayList<SideData>>();
    private Map<TransmissionType, Boolean> ejecting = new HashMap<TransmissionType, Boolean>();
    private Map<TransmissionType, Boolean> canEject = new HashMap<TransmissionType, Boolean>();
    public List<TransmissionType> transmissions = new ArrayList<TransmissionType>();

    public TileComponentConfig(TileEntityContainerBlock tile, TransmissionType ... types) {
        this.tileEntity = tile;
        for (TransmissionType type : types) {
            this.addSupported(type);
        }
        tile.components.add(this);
    }

    public void readFrom(TileComponentConfig config) {
        this.sideConfigs = config.sideConfigs;
        this.ejecting = config.ejecting;
        this.canEject = config.canEject;
        this.transmissions = config.transmissions;
    }

    public void addSupported(TransmissionType type) {
        if (!this.transmissions.contains((Object)type)) {
            this.transmissions.add(type);
        }
        this.sideOutputs.put(type, new ArrayList());
        this.ejecting.put(type, false);
        this.canEject.put(type, true);
    }

    public EnumSet<EnumFacing> getSidesForData(TransmissionType type, EnumFacing facing, int dataIndex) {
        EnumSet<EnumFacing> ret = EnumSet.noneOf(EnumFacing.class);
        SideConfig config = this.getConfig(type);
        EnumFacing[] translatedFacings = MekanismUtils.getBaseOrientations(facing);
        for (EnumFacing sideToCheck : EnumFacing.values()) {
            if (config.get(translatedFacings[sideToCheck.ordinal()]) != dataIndex) continue;
            ret.add(sideToCheck);
        }
        return ret;
    }

    public boolean hasSideForData(TransmissionType type, EnumFacing facing, int dataIndex, EnumFacing sideToTest) {
        if (sideToTest == null) {
            return false;
        }
        EnumFacing[] translatedFacings = MekanismUtils.getBaseOrientations(facing);
        return this.getConfig(type).get(translatedFacings[sideToTest.ordinal()]) == dataIndex;
    }

    public void setCanEject(TransmissionType type, boolean eject) {
        this.canEject.put(type, eject);
    }

    public boolean canEject(TransmissionType type) {
        return this.canEject.get((Object)type);
    }

    public void fillConfig(TransmissionType type, int data) {
        byte sideData = (byte)data;
        this.setConfig(type, sideData, sideData, sideData, sideData, sideData, sideData);
    }

    public void setIOConfig(TransmissionType type) {
        this.addOutput(type, new SideData("None", EnumColor.GREY, SideData.IOState.OFF));
        this.addOutput(type, new SideData("Input", EnumColor.DARK_GREEN, SideData.IOState.INPUT));
        this.addOutput(type, new SideData("Output", EnumColor.DARK_RED, SideData.IOState.OUTPUT));
        this.setConfig(type, new byte[]{1, 1, 2, 1, 1, 1});
    }

    public void setInputConfig(TransmissionType type) {
        this.addOutput(type, new SideData("None", EnumColor.GREY, SideData.IOState.OFF));
        this.addOutput(type, new SideData("Input", EnumColor.DARK_GREEN, SideData.IOState.INPUT));
        this.fillConfig(type, 1);
        this.setCanEject(type, false);
    }

    public void setConfig(TransmissionType type, byte[] config) {
        assert (config.length == EnumFacing.field_82609_l.length);
        this.setConfig(type, config[0], config[1], config[2], config[3], config[4], config[5]);
    }

    public void setConfig(TransmissionType type, byte d, byte u, byte n, byte s, byte w, byte e) {
        this.sideConfigs.put(type, new SideConfig(d, u, n, s, w, e));
    }

    public void addOutput(TransmissionType type, SideData data) {
        this.sideOutputs.get((Object)type).add(data);
    }

    public ArrayList<SideData> getOutputs(TransmissionType type) {
        return this.sideOutputs.get((Object)type);
    }

    public SideConfig getConfig(TransmissionType type) {
        return this.sideConfigs.get((Object)type);
    }

    public SideData getOutput(TransmissionType type, EnumFacing side, EnumFacing facing) {
        if (side == null) {
            return EMPTY;
        }
        return this.getOutput(type, MekanismUtils.getBaseOrientation(side, facing));
    }

    public SideData getOutput(TransmissionType type, EnumFacing side) {
        if (side == null) {
            return EMPTY;
        }
        SideConfig sideConfig = this.getConfig(type);
        byte index = sideConfig.get(side);
        if (index == -1) {
            return EMPTY;
        }
        if (index > this.getOutputs(type).size() - 1) {
            sideConfig.set(side, (byte)0);
            index = 0;
        }
        return this.getOutputs(type).get(index);
    }

    public boolean supports(TransmissionType type) {
        return this.transmissions.contains((Object)type);
    }

    @Override
    public void tick() {
    }

    @Override
    public void read(NBTTagCompound nbtTags) {
        if (nbtTags.func_74767_n("sideDataStored")) {
            for (TransmissionType type : this.transmissions) {
                if (nbtTags.func_74770_j("config" + type.ordinal()).length <= 0) continue;
                this.sideConfigs.put(type, new SideConfig(nbtTags.func_74770_j("config" + type.ordinal())));
                this.ejecting.put(type, nbtTags.func_74767_n("ejecting" + type.ordinal()));
            }
        }
    }

    @Override
    public void read(ByteBuf dataStream) {
        this.transmissions.clear();
        int amount = dataStream.readInt();
        for (int i = 0; i < amount; ++i) {
            this.transmissions.add(TransmissionType.values()[dataStream.readInt()]);
        }
        for (TransmissionType type : this.transmissions) {
            byte[] array = new byte[6];
            dataStream.readBytes(array);
            this.sideConfigs.put(type, new SideConfig(array));
            this.ejecting.put(type, dataStream.readBoolean());
        }
    }

    @Override
    public void write(NBTTagCompound nbtTags) {
        for (TransmissionType type : this.transmissions) {
            nbtTags.func_74773_a("config" + type.ordinal(), this.sideConfigs.get((Object)type).asByteArray());
            nbtTags.func_74757_a("ejecting" + type.ordinal(), this.ejecting.get((Object)type).booleanValue());
        }
        nbtTags.func_74757_a("sideDataStored", true);
    }

    @Override
    public void write(TileNetworkList data) {
        data.add(this.transmissions.size());
        for (TransmissionType type : this.transmissions) {
            data.add(type.ordinal());
        }
        for (TransmissionType type : this.transmissions) {
            data.add(this.sideConfigs.get((Object)type).asByteArray());
            data.add(this.ejecting.get((Object)type));
        }
    }

    @Override
    public void invalidate() {
    }

    public boolean isEjecting(TransmissionType type) {
        return this.ejecting.get((Object)type);
    }

    public void setEjecting(TransmissionType type, boolean eject) {
        this.ejecting.put(type, eject);
        MekanismUtils.saveChunk(this.tileEntity);
    }
}

