/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import mekanism.api.Coord4D;
import mekanism.api.Range4D;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.common.Mekanism;
import mekanism.common.base.TileNetworkList;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.content.matrix.MatrixCache;
import mekanism.common.content.matrix.MatrixUpdateProtocol;
import mekanism.common.content.matrix.SynchronizedMatrixData;
import mekanism.common.integration.computer.IComputerIntegration;
import mekanism.common.multiblock.MultiblockManager;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityMultiblock;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TileEntityInductionCasing
extends TileEntityMultiblock<SynchronizedMatrixData>
implements IStrictEnergyStorage,
IComputerIntegration {
    public int clientCells;
    public int clientProviders;
    public static final String[] methods = new String[]{"getEnergy", "getMaxEnergy", "getInput", "getOutput", "getTransferCap"};

    public TileEntityInductionCasing() {
        this("InductionCasing");
    }

    public TileEntityInductionCasing(String name) {
        super(name);
        this.inventory = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K && this.structure != null && this.isRendering) {
            ((SynchronizedMatrixData)this.structure).lastInput = ((SynchronizedMatrixData)this.structure).transferCap - ((SynchronizedMatrixData)this.structure).remainingInput;
            ((SynchronizedMatrixData)this.structure).remainingInput = ((SynchronizedMatrixData)this.structure).transferCap;
            ((SynchronizedMatrixData)this.structure).lastOutput = ((SynchronizedMatrixData)this.structure).transferCap - ((SynchronizedMatrixData)this.structure).remainingOutput;
            ((SynchronizedMatrixData)this.structure).remainingOutput = ((SynchronizedMatrixData)this.structure).transferCap;
            ChargeUtils.charge(0, this);
            ChargeUtils.discharge(1, this);
        }
    }

    @Override
    public boolean onActivate(EntityPlayer player, EnumHand hand, ItemStack stack) {
        if (!player.func_70093_af() && this.structure != null) {
            Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new TileNetworkList())), new Range4D(Coord4D.get(this)));
            player.openGui((Object)Mekanism.instance, 49, this.field_145850_b, this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p());
            return true;
        }
        return false;
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        if (this.structure != null) {
            data.add(((SynchronizedMatrixData)this.structure).getEnergy(this.field_145850_b));
            data.add(((SynchronizedMatrixData)this.structure).storageCap);
            data.add(((SynchronizedMatrixData)this.structure).transferCap);
            data.add(((SynchronizedMatrixData)this.structure).lastInput);
            data.add(((SynchronizedMatrixData)this.structure).lastOutput);
            data.add(((SynchronizedMatrixData)this.structure).volWidth);
            data.add(((SynchronizedMatrixData)this.structure).volHeight);
            data.add(((SynchronizedMatrixData)this.structure).volLength);
            data.add(((SynchronizedMatrixData)this.structure).cells.size());
            data.add(((SynchronizedMatrixData)this.structure).providers.size());
        }
        return data;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient() && this.clientHasStructure) {
            ((SynchronizedMatrixData)this.structure).clientEnergy = dataStream.readDouble();
            ((SynchronizedMatrixData)this.structure).storageCap = dataStream.readDouble();
            ((SynchronizedMatrixData)this.structure).transferCap = dataStream.readDouble();
            ((SynchronizedMatrixData)this.structure).lastInput = dataStream.readDouble();
            ((SynchronizedMatrixData)this.structure).lastOutput = dataStream.readDouble();
            ((SynchronizedMatrixData)this.structure).volWidth = dataStream.readInt();
            ((SynchronizedMatrixData)this.structure).volHeight = dataStream.readInt();
            ((SynchronizedMatrixData)this.structure).volLength = dataStream.readInt();
            this.clientCells = dataStream.readInt();
            this.clientProviders = dataStream.readInt();
        }
    }

    @Override
    protected SynchronizedMatrixData getNewStructure() {
        return new SynchronizedMatrixData();
    }

    public MatrixCache getNewCache() {
        return new MatrixCache();
    }

    protected MatrixUpdateProtocol getProtocol() {
        return new MatrixUpdateProtocol(this);
    }

    @Override
    public MultiblockManager<SynchronizedMatrixData> getManager() {
        return Mekanism.matrixManager;
    }

    @Override
    public String func_70005_c_() {
        return LangUtils.localize("gui.inductionMatrix");
    }

    public int getScaledEnergyLevel(int i) {
        return (int)(this.getEnergy() * (double)i / this.getMaxEnergy());
    }

    @Override
    public double getEnergy() {
        if (!this.field_145850_b.field_72995_K) {
            return this.structure != null ? ((SynchronizedMatrixData)this.structure).getEnergy(this.field_145850_b) : 0.0;
        }
        return this.structure != null ? ((SynchronizedMatrixData)this.structure).clientEnergy : 0.0;
    }

    @Override
    public void setEnergy(double energy) {
        if (this.structure != null) {
            ((SynchronizedMatrixData)this.structure).setEnergy(this.field_145850_b, Math.max(Math.min(energy, this.getMaxEnergy()), 0.0));
            MekanismUtils.saveChunk(this);
        }
    }

    @Override
    public double getMaxEnergy() {
        return this.structure != null ? ((SynchronizedMatrixData)this.structure).storageCap : 0.0;
    }

    @Override
    public String[] getMethods() {
        return methods;
    }

    @Override
    public Object[] invoke(int method, Object[] arguments) throws Exception {
        if (this.structure == null) {
            return new Object[]{"Unformed."};
        }
        switch (method) {
            case 0: {
                return new Object[]{this.getEnergy()};
            }
            case 1: {
                return new Object[]{this.getMaxEnergy()};
            }
            case 2: {
                return new Object[]{((SynchronizedMatrixData)this.structure).lastInput};
            }
            case 3: {
                return new Object[]{((SynchronizedMatrixData)this.structure).lastOutput};
            }
            case 4: {
                return new Object[]{((SynchronizedMatrixData)this.structure).transferCap};
            }
        }
        throw new NoSuchMethodException();
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == Capabilities.ENERGY_STORAGE_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == Capabilities.ENERGY_STORAGE_CAPABILITY) {
            return (T)this;
        }
        return super.getCapability(capability, facing);
    }
}

