/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.IConfigCardAccess;
import mekanism.api.Range4D;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.GasTankInfo;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.IGasItem;
import mekanism.api.gas.ITubeConnection;
import mekanism.api.infuse.InfuseObject;
import mekanism.api.infuse.InfuseRegistry;
import mekanism.api.transmitters.TransmissionType;
import mekanism.client.HolidayManager;
import mekanism.common.InfuseStorage;
import mekanism.common.Mekanism;
import mekanism.common.MekanismBlocks;
import mekanism.common.MekanismItems;
import mekanism.common.PacketHandler;
import mekanism.common.SideData;
import mekanism.common.Tier;
import mekanism.common.Upgrade;
import mekanism.common.base.IFactory;
import mekanism.common.base.IRedstoneControl;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.base.ISustainedData;
import mekanism.common.base.ITierUpgradeable;
import mekanism.common.base.SoundWrapper;
import mekanism.common.base.TileNetworkList;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.integration.computer.IComputerIntegration;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.InfusionInput;
import mekanism.common.recipe.machines.AdvancedMachineRecipe;
import mekanism.common.recipe.machines.BasicMachineRecipe;
import mekanism.common.recipe.machines.DoubleMachineRecipe;
import mekanism.common.recipe.machines.MachineRecipe;
import mekanism.common.recipe.machines.MetallurgicInfuserRecipe;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.prefab.TileEntityAdvancedElectricMachine;
import mekanism.common.tile.prefab.TileEntityMachine;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.GasUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StackUtils;
import mekanism.common.util.StatUtils;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityFactory
extends TileEntityMachine
implements IComputerIntegration,
ISideConfiguration,
IGasHandler,
ITubeConnection,
IConfigCardAccess.ISpecialConfigData,
ITierUpgradeable,
ISustainedData {
    public Tier.FactoryTier tier;
    public int[] progress;
    public int BASE_MAX_INFUSE;
    public int maxInfuse;
    public int BASE_TICKS_REQUIRED;
    public int ticksRequired;
    public double secondaryEnergyPerTick;
    public int secondaryEnergyThisTick;
    public int RECIPE_TICKS_REQUIRED;
    public int recipeTicks;
    public IFactory.RecipeType recipeType;
    private final MachineRecipe[] cachedRecipe;
    public InfuseStorage infuseStored;
    public GasTank gasTank;
    public boolean sorting;
    public boolean upgraded;
    public double lastUsage;
    @SideOnly(value=Side.CLIENT)
    public SoundWrapper[] sounds;
    public IRedstoneControl.RedstoneControl controlType;
    public TileComponentEjector ejectorComponent;
    public TileComponentConfig configComponent;
    private static final String[] methods = new String[]{"getEnergy", "getProgress", "facing", "canOperate", "getMaxEnergy", "getEnergyNeeded"};

    public TileEntityFactory() {
        this(Tier.FactoryTier.BASIC, BlockStateMachine.MachineType.BASIC_FACTORY);
        this.configComponent = new TileComponentConfig(this, TransmissionType.ITEM, TransmissionType.ENERGY, TransmissionType.GAS);
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("None", EnumColor.GREY, InventoryUtils.EMPTY));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("Input", EnumColor.DARK_RED, new int[]{5, 6, 7}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("Output", EnumColor.DARK_BLUE, new int[]{8, 9, 10}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("Energy", EnumColor.DARK_GREEN, new int[]{1}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("Extra", EnumColor.PURPLE, new int[]{4}));
        this.configComponent.setConfig(TransmissionType.ITEM, new byte[]{4, 0, 0, 3, 1, 2});
        this.configComponent.addOutput(TransmissionType.GAS, new SideData("None", EnumColor.GREY, InventoryUtils.EMPTY));
        this.configComponent.addOutput(TransmissionType.GAS, new SideData("Gas", EnumColor.DARK_RED, new int[]{0}));
        this.configComponent.fillConfig(TransmissionType.GAS, 1);
        this.configComponent.setCanEject(TransmissionType.GAS, false);
        this.configComponent.setInputConfig(TransmissionType.ENERGY);
        this.ejectorComponent = new TileComponentEjector(this);
        this.ejectorComponent.setOutputData(TransmissionType.ITEM, this.configComponent.getOutputs(TransmissionType.ITEM).get(2));
    }

    public TileEntityFactory(Tier.FactoryTier type, BlockStateMachine.MachineType machine) {
        super("null", machine.blockName, 0.0, 0.0, 0);
        this.maxInfuse = this.BASE_MAX_INFUSE = 1000;
        this.BASE_TICKS_REQUIRED = 200;
        this.ticksRequired = 200;
        this.secondaryEnergyPerTick = 0.0;
        this.RECIPE_TICKS_REQUIRED = 40;
        this.recipeType = IFactory.RecipeType.SMELTING;
        this.infuseStored = new InfuseStorage();
        this.controlType = IRedstoneControl.RedstoneControl.DISABLED;
        this.tier = type;
        this.inventory = NonNullList.func_191197_a((int)(5 + type.processes * 2), (Object)ItemStack.field_190927_a);
        this.progress = new int[type.processes];
        this.isActive = false;
        this.cachedRecipe = new MachineRecipe[this.tier.processes];
        this.gasTank = new GasTank(TileEntityAdvancedElectricMachine.MAX_GAS * this.tier.processes);
        this.maxInfuse = this.BASE_MAX_INFUSE * this.tier.processes;
        this.setRecipeType(this.recipeType);
    }

    @Override
    public boolean upgrade(Tier.BaseTier upgradeTier) {
        int i;
        if (upgradeTier.ordinal() != this.tier.ordinal() + 1 || this.tier == Tier.FactoryTier.ELITE) {
            return false;
        }
        this.field_145850_b.func_175698_g(this.func_174877_v());
        this.field_145850_b.func_180501_a(this.func_174877_v(), MekanismBlocks.MachineBlock.func_176203_a(5 + this.tier.ordinal() + 1), 3);
        TileEntityFactory factory = (TileEntityFactory)this.field_145850_b.func_175625_s(this.func_174877_v());
        factory.facing = this.facing;
        factory.clientFacing = this.clientFacing;
        factory.ticker = this.ticker;
        factory.redstone = this.redstone;
        factory.redstoneLastTick = this.redstoneLastTick;
        factory.doAutoSync = this.doAutoSync;
        factory.electricityStored = this.electricityStored;
        factory.soundURL = this.soundURL;
        System.arraycopy(this.progress, 0, factory.progress, 0, this.tier.processes);
        factory.recipeTicks = this.recipeTicks;
        factory.clientActive = this.clientActive;
        factory.isActive = this.isActive;
        factory.updateDelay = this.updateDelay;
        factory.prevEnergy = this.prevEnergy;
        factory.gasTank.setGas(this.gasTank.getGas());
        factory.sorting = this.sorting;
        factory.controlType = this.controlType;
        factory.upgradeComponent.readFrom(this.upgradeComponent);
        factory.ejectorComponent.readFrom(this.ejectorComponent);
        factory.configComponent.readFrom(this.configComponent);
        factory.ejectorComponent.setOutputData(TransmissionType.ITEM, factory.configComponent.getOutputs(TransmissionType.ITEM).get(2));
        factory.setRecipeType(this.recipeType);
        factory.upgradeComponent.setSupported(Upgrade.GAS, this.recipeType.fuelEnergyUpgrades());
        factory.securityComponent.readFrom(this.securityComponent);
        factory.infuseStored = this.infuseStored;
        for (i = 0; i < this.tier.processes + 5; ++i) {
            factory.inventory.set(i, this.inventory.get(i));
        }
        for (i = 0; i < this.tier.processes; ++i) {
            int output = this.getOutputSlot(i);
            if (((ItemStack)this.inventory.get(output)).func_190926_b()) continue;
            int newOutput = 5 + factory.tier.processes + i;
            factory.inventory.set(newOutput, this.inventory.get(output));
        }
        for (Upgrade upgrade : factory.upgradeComponent.getSupportedTypes()) {
            factory.recalculateUpgradables(upgrade);
        }
        factory.upgraded = true;
        factory.func_70296_d();
        Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(factory), factory.getNetworkedData(new TileNetworkList())), new Range4D(Coord4D.get(factory)));
        return true;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            if (this.ticker == 1) {
                this.field_145850_b.func_175685_c(this.func_174877_v(), this.func_145838_q(), true);
            }
            ChargeUtils.discharge(1, this);
            this.handleSecondaryFuel();
            this.sortInventory();
            if (!((ItemStack)this.inventory.get(2)).func_190926_b() && ((ItemStack)this.inventory.get(3)).func_190926_b()) {
                IFactory.RecipeType toSet = null;
                for (IFactory.RecipeType type : IFactory.RecipeType.values()) {
                    if (!((ItemStack)this.inventory.get(2)).func_77969_a(type.getStack())) continue;
                    toSet = type;
                    break;
                }
                if (toSet != null && this.recipeType != toSet) {
                    if (this.recipeTicks < this.RECIPE_TICKS_REQUIRED) {
                        ++this.recipeTicks;
                    } else {
                        this.recipeTicks = 0;
                        ItemStack returnStack = this.getMachineStack();
                        this.upgradeComponent.write(ItemDataUtils.getDataMap(returnStack));
                        this.upgradeComponent.setSupported(Upgrade.GAS, toSet.fuelEnergyUpgrades());
                        this.upgradeComponent.read(ItemDataUtils.getDataMap((ItemStack)this.inventory.get(2)));
                        this.inventory.set(2, (Object)ItemStack.field_190927_a);
                        this.inventory.set(3, (Object)returnStack);
                        this.setRecipeType(toSet);
                        this.gasTank.setGas(null);
                        this.secondaryEnergyPerTick = this.getSecondaryEnergyPerTick(this.recipeType);
                        this.field_145850_b.func_175685_c(this.func_174877_v(), this.func_145838_q(), true);
                        MekanismUtils.saveChunk(this);
                    }
                } else {
                    this.recipeTicks = 0;
                }
            } else {
                this.recipeTicks = 0;
            }
            double prev = this.getEnergy();
            this.secondaryEnergyThisTick = this.recipeType.fuelEnergyUpgrades() ? StatUtils.inversePoisson(this.secondaryEnergyPerTick) : (int)Math.ceil(this.secondaryEnergyPerTick);
            for (int process = 0; process < this.tier.processes; ++process) {
                if (MekanismUtils.canFunction(this) && this.canOperate(this.getInputSlot(process), this.getOutputSlot(process)) && this.getEnergy() >= this.energyPerTick && this.gasTank.getStored() >= this.secondaryEnergyThisTick) {
                    if (this.progress[process] + 1 < this.ticksRequired) {
                        int n = process;
                        this.progress[n] = this.progress[n] + 1;
                        this.gasTank.draw(this.secondaryEnergyThisTick, true);
                        this.electricityStored -= this.energyPerTick;
                    } else if (this.progress[process] + 1 >= this.ticksRequired) {
                        this.operate(this.getInputSlot(process), this.getOutputSlot(process));
                        this.progress[process] = 0;
                        this.gasTank.draw(this.secondaryEnergyThisTick, true);
                        this.electricityStored -= this.energyPerTick;
                    }
                }
                if (this.canOperate(this.getInputSlot(process), this.getOutputSlot(process)) || this.recipeType.getFuelType() == IFactory.MachineFuelType.ADVANCED && this.recipeType.hasRecipe((ItemStack)this.inventory.get(this.getInputSlot(process)))) continue;
                this.progress[process] = 0;
            }
            boolean hasOperation = false;
            for (int i = 0; i < this.tier.processes; ++i) {
                if (!this.canOperate(this.getInputSlot(i), this.getOutputSlot(i))) continue;
                hasOperation = true;
                break;
            }
            if (MekanismUtils.canFunction(this) && hasOperation && this.getEnergy() >= this.energyPerTick && this.gasTank.getStored() >= this.secondaryEnergyThisTick) {
                this.setActive(true);
            } else if (this.prevEnergy >= this.getEnergy()) {
                this.setActive(false);
            }
            if (this.infuseStored.amount <= 0) {
                this.infuseStored.amount = 0;
                this.infuseStored.type = null;
            }
            this.lastUsage = prev - this.getEnergy();
            this.prevEnergy = this.getEnergy();
        }
    }

    public void setRecipeType(IFactory.RecipeType type) {
        this.recipeType = type;
        this.BASE_MAX_ENERGY = this.maxEnergy = (double)(200 * this.tier.processes) * this.recipeType.getEnergyUsage();
        this.BASE_ENERGY_PER_TICK = this.energyPerTick = this.recipeType.getEnergyUsage();
        this.upgradeComponent.setSupported(Upgrade.GAS, this.recipeType.fuelEnergyUpgrades());
        this.secondaryEnergyPerTick = this.getSecondaryEnergyPerTick(this.recipeType);
        for (Upgrade upgrade : this.upgradeComponent.getSupportedTypes()) {
            this.recalculateUpgradables(upgrade);
        }
    }

    @Override
    public boolean sideIsConsumer(EnumFacing side) {
        return this.configComponent.hasSideForData(TransmissionType.ENERGY, this.facing, 1, side);
    }

    public void sortInventory() {
        if (this.sorting) {
            boolean didOp = false;
            int[] inputSlots = null;
            ArrayList<InvID> invStacks = new ArrayList<InvID>();
            if (this.tier == Tier.FactoryTier.BASIC) {
                inputSlots = new int[]{5, 6, 7};
            } else if (this.tier == Tier.FactoryTier.ADVANCED) {
                inputSlots = new int[]{5, 6, 7, 8, 9};
            } else if (this.tier == Tier.FactoryTier.ELITE) {
                inputSlots = new int[]{5, 6, 7, 8, 9, 10, 11};
            }
            for (int id : inputSlots) {
                invStacks.add(InvID.get(id, (NonNullList<ItemStack>)this.inventory));
            }
            Object object = invStacks.iterator();
            while (object.hasNext()) {
                InvID invID1 = (InvID)object.next();
                for (InvID invID2 : invStacks) {
                    if (invID1.ID == invID2.ID || StackUtils.diffIgnoreNull(invID1.stack, invID2.stack) || Math.abs(invID1.size() - invID2.size()) < 2) continue;
                    List<ItemStack> evened = StackUtils.even((ItemStack)this.inventory.get(invID1.ID), (ItemStack)this.inventory.get(invID2.ID));
                    this.inventory.set(invID1.ID, (Object)evened.get(0));
                    this.inventory.set(invID2.ID, (Object)evened.get(1));
                    didOp = true;
                    break;
                }
                if (!didOp) continue;
                this.func_70296_d();
                break;
            }
        }
    }

    public double getSecondaryEnergyPerTick(IFactory.RecipeType type) {
        return MekanismUtils.getSecondaryEnergyPerTickMean(this, type.getSecondaryEnergyPerTick());
    }

    public void handleSecondaryFuel() {
        if (!((ItemStack)this.inventory.get(4)).func_190926_b()) {
            if (this.recipeType.getFuelType() == IFactory.MachineFuelType.ADVANCED && this.gasTank.getNeeded() > 0) {
                if (((ItemStack)this.inventory.get(4)).func_77973_b() instanceof IGasItem) {
                    GasStack gas = ((IGasItem)((ItemStack)this.inventory.get(4)).func_77973_b()).getGas((ItemStack)this.inventory.get(4));
                    if (gas != null && this.recipeType.isValidGas(gas.getGas())) {
                        GasStack removed = GasUtils.removeGas((ItemStack)this.inventory.get(4), this.gasTank.getGasType(), this.gasTank.getNeeded());
                        this.gasTank.receive(removed, true);
                    }
                    return;
                }
                GasStack stack = this.recipeType.getItemGas((ItemStack)this.inventory.get(4));
                int gasNeeded = this.gasTank.getNeeded();
                if (stack != null && stack.amount <= gasNeeded) {
                    this.gasTank.receive(stack, true);
                    ((ItemStack)this.inventory.get(4)).func_190918_g(1);
                }
            } else if (this.recipeType == IFactory.RecipeType.INFUSING && InfuseRegistry.getObject((ItemStack)this.inventory.get(4)) != null) {
                InfuseObject infuse = InfuseRegistry.getObject((ItemStack)this.inventory.get(4));
                if ((this.infuseStored.type == null || this.infuseStored.type == infuse.type) && this.infuseStored.amount + infuse.stored <= this.maxInfuse) {
                    this.infuseStored.amount += infuse.stored;
                    this.infuseStored.type = infuse.type;
                    ((ItemStack)this.inventory.get(4)).func_190918_g(1);
                }
            }
        }
    }

    public ItemStack getMachineStack() {
        return this.recipeType.getStack();
    }

    @Override
    public boolean func_180461_b(int slotID, ItemStack itemstack, EnumFacing side) {
        if (slotID == 1) {
            return ChargeUtils.canBeOutputted(itemstack, false);
        }
        if (this.tier == Tier.FactoryTier.BASIC && slotID >= 8 && slotID <= 10) {
            return true;
        }
        if (this.tier == Tier.FactoryTier.ADVANCED && slotID >= 10 && slotID <= 14) {
            return true;
        }
        return this.tier == Tier.FactoryTier.ELITE && slotID >= 12 && slotID <= 18;
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (this.tier == Tier.FactoryTier.BASIC) {
            if (slotID >= 8 && slotID <= 10) {
                return false;
            }
            if (slotID >= 5 && slotID <= 7) {
                return this.recipeType.getAnyRecipe(itemstack, (ItemStack)this.inventory.get(4), this.gasTank.getGasType(), this.infuseStored) != null;
            }
        } else if (this.tier == Tier.FactoryTier.ADVANCED) {
            if (slotID >= 10 && slotID <= 14) {
                return false;
            }
            if (slotID >= 5 && slotID <= 9) {
                return this.recipeType.getAnyRecipe(itemstack, (ItemStack)this.inventory.get(4), this.gasTank.getGasType(), this.infuseStored) != null;
            }
        } else if (this.tier == Tier.FactoryTier.ELITE) {
            if (slotID >= 12 && slotID <= 18) {
                return false;
            }
            if (slotID >= 5 && slotID <= 11) {
                return this.recipeType.getAnyRecipe(itemstack, (ItemStack)this.inventory.get(4), this.gasTank.getGasType(), this.infuseStored) != null;
            }
        }
        if (slotID == 0) {
            return itemstack.func_77973_b() == MekanismItems.SpeedUpgrade || itemstack.func_77973_b() == MekanismItems.EnergyUpgrade;
        }
        if (slotID == 1) {
            return ChargeUtils.canBeDischarged(itemstack);
        }
        if (slotID == 4) {
            if (this.recipeType.getFuelType() == IFactory.MachineFuelType.ADVANCED) {
                return this.recipeType.getItemGas(itemstack) != null;
            }
            if (this.recipeType.getFuelType() == IFactory.MachineFuelType.DOUBLE) {
                return this.recipeType.hasRecipeForExtra(itemstack);
            }
            if (this.recipeType == IFactory.RecipeType.INFUSING) {
                return InfuseRegistry.getObject(itemstack) != null && (this.infuseStored.type == null || this.infuseStored.type == InfuseRegistry.getObject((ItemStack)itemstack).type);
            }
        }
        return false;
    }

    public int getScaledProgress(int i, int process) {
        return this.progress[process] * i / this.ticksRequired;
    }

    public int getScaledInfuseLevel(int i) {
        return this.infuseStored.amount * i / this.maxInfuse;
    }

    public int getScaledGasLevel(int i) {
        return this.gasTank.getStored() * i / this.gasTank.getMaxGas();
    }

    public int getScaledRecipeProgress(int i) {
        return this.recipeTicks * i / this.RECIPE_TICKS_REQUIRED;
    }

    public boolean canOperate(int inputSlot, int outputSlot) {
        if (((ItemStack)this.inventory.get(inputSlot)).func_190926_b()) {
            return false;
        }
        int process = this.getOperation(inputSlot);
        if (this.recipeType.getFuelType() == IFactory.MachineFuelType.ADVANCED) {
            if (this.cachedRecipe[process] instanceof AdvancedMachineRecipe && ((AdvancedMachineRecipe)this.cachedRecipe[process]).inputMatches((NonNullList<ItemStack>)this.inventory, inputSlot, this.gasTank, this.secondaryEnergyThisTick)) {
                return ((AdvancedMachineRecipe)this.cachedRecipe[process]).canOperate((NonNullList<ItemStack>)this.inventory, inputSlot, outputSlot, this.gasTank, this.secondaryEnergyThisTick);
            }
            AdvancedMachineRecipe recipe = this.recipeType.getRecipe((ItemStack)this.inventory.get(inputSlot), this.gasTank.getGasType());
            this.cachedRecipe[process] = recipe;
            return recipe != null && recipe.canOperate((NonNullList<ItemStack>)this.inventory, inputSlot, outputSlot, this.gasTank, this.secondaryEnergyThisTick);
        }
        if (this.recipeType.getFuelType() == IFactory.MachineFuelType.DOUBLE) {
            if (this.cachedRecipe[process] instanceof DoubleMachineRecipe && ((DoubleMachineRecipe)this.cachedRecipe[process]).inputMatches((NonNullList<ItemStack>)this.inventory, inputSlot, 4)) {
                return ((DoubleMachineRecipe)this.cachedRecipe[process]).canOperate((NonNullList<ItemStack>)this.inventory, inputSlot, 4, outputSlot);
            }
            DoubleMachineRecipe recipe = this.recipeType.getRecipe((ItemStack)this.inventory.get(inputSlot), (ItemStack)this.inventory.get(4));
            this.cachedRecipe[process] = recipe;
            return recipe != null && recipe.canOperate((NonNullList<ItemStack>)this.inventory, inputSlot, 4, outputSlot);
        }
        if (this.recipeType == IFactory.RecipeType.INFUSING) {
            if (this.cachedRecipe[process] instanceof MetallurgicInfuserRecipe && ((MetallurgicInfuserRecipe)this.cachedRecipe[process]).inputMatches((NonNullList<ItemStack>)this.inventory, inputSlot, this.infuseStored)) {
                return ((MetallurgicInfuserRecipe)this.cachedRecipe[process]).canOperate((NonNullList<ItemStack>)this.inventory, inputSlot, outputSlot, this.infuseStored);
            }
            InfusionInput input = new InfusionInput(this.infuseStored, (ItemStack)this.inventory.get(inputSlot));
            MetallurgicInfuserRecipe recipe = RecipeHandler.getMetallurgicInfuserRecipe(input);
            this.cachedRecipe[process] = recipe;
            if (recipe == null) {
                return false;
            }
            return recipe.canOperate((NonNullList<ItemStack>)this.inventory, inputSlot, outputSlot, this.infuseStored);
        }
        if (this.cachedRecipe[process] instanceof BasicMachineRecipe && ((BasicMachineRecipe)this.cachedRecipe[process]).inputMatches((NonNullList<ItemStack>)this.inventory, inputSlot)) {
            return ((BasicMachineRecipe)this.cachedRecipe[process]).canOperate((NonNullList<ItemStack>)this.inventory, inputSlot, outputSlot);
        }
        BasicMachineRecipe recipe = this.recipeType.getRecipe((ItemStack)this.inventory.get(inputSlot));
        this.cachedRecipe[process] = recipe;
        return recipe != null && recipe.canOperate((NonNullList<ItemStack>)this.inventory, inputSlot, outputSlot);
    }

    public void operate(int inputSlot, int outputSlot) {
        if (!this.canOperate(inputSlot, outputSlot)) {
            return;
        }
        int process = this.getOperation(inputSlot);
        if (this.cachedRecipe[process] == null) {
            Mekanism.logger.debug("cachedRecipe was null, but we were asked to operate anyway?! {} @ {}", (Object)this, (Object)this.field_174879_c);
            return;
        }
        if (this.recipeType.getFuelType() == IFactory.MachineFuelType.ADVANCED && this.cachedRecipe[process] instanceof AdvancedMachineRecipe) {
            AdvancedMachineRecipe recipe = (AdvancedMachineRecipe)this.cachedRecipe[process];
            recipe.operate((NonNullList<ItemStack>)this.inventory, inputSlot, outputSlot, this.gasTank, this.secondaryEnergyThisTick);
        } else if (this.recipeType.getFuelType() == IFactory.MachineFuelType.DOUBLE && this.cachedRecipe[process] instanceof DoubleMachineRecipe) {
            DoubleMachineRecipe recipe = (DoubleMachineRecipe)this.cachedRecipe[process];
            recipe.operate((NonNullList<ItemStack>)this.inventory, inputSlot, 4, outputSlot);
        } else if (this.recipeType == IFactory.RecipeType.INFUSING && this.cachedRecipe[process] instanceof MetallurgicInfuserRecipe) {
            MetallurgicInfuserRecipe recipe = (MetallurgicInfuserRecipe)this.cachedRecipe[process];
            recipe.output((NonNullList<ItemStack>)this.inventory, inputSlot, outputSlot, this.infuseStored);
        } else {
            BasicMachineRecipe recipe = (BasicMachineRecipe)this.cachedRecipe[process];
            recipe.operate((NonNullList<ItemStack>)this.inventory, inputSlot, outputSlot);
        }
        this.func_70296_d();
        this.ejectorComponent.outputItems();
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            int type = dataStream.readInt();
            if (type == 0) {
                this.sorting = !this.sorting;
            } else if (type == 1) {
                this.gasTank.setGas(null);
                this.infuseStored.amount = 0;
                this.infuseStored.type = null;
            }
            return;
        }
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            IFactory.RecipeType oldRecipe = this.recipeType;
            this.recipeType = IFactory.RecipeType.values()[dataStream.readInt()];
            this.upgradeComponent.setSupported(Upgrade.GAS, this.recipeType.fuelEnergyUpgrades());
            this.recipeTicks = dataStream.readInt();
            this.sorting = dataStream.readBoolean();
            this.upgraded = dataStream.readBoolean();
            this.lastUsage = dataStream.readDouble();
            this.infuseStored.amount = dataStream.readInt();
            this.infuseStored.type = InfuseRegistry.get(PacketHandler.readString(dataStream));
            if (this.recipeType != oldRecipe) {
                this.setRecipeType(this.recipeType);
                if (!this.upgraded) {
                    MekanismUtils.updateBlock(this.field_145850_b, this.func_174877_v());
                }
            }
            for (int i = 0; i < this.tier.processes; ++i) {
                this.progress[i] = dataStream.readInt();
            }
            if (dataStream.readBoolean()) {
                this.gasTank.setGas(new GasStack(dataStream.readInt(), dataStream.readInt()));
            } else {
                this.gasTank.setGas(null);
            }
            if (this.upgraded) {
                this.func_70296_d();
                MekanismUtils.updateBlock(this.field_145850_b, this.func_174877_v());
                this.upgraded = false;
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.setRecipeType(IFactory.RecipeType.values()[nbtTags.func_74762_e("recipeType")]);
        this.upgradeComponent.setSupported(Upgrade.GAS, this.recipeType.fuelEnergyUpgrades());
        this.recipeTicks = nbtTags.func_74762_e("recipeTicks");
        this.sorting = nbtTags.func_74767_n("sorting");
        this.infuseStored.amount = nbtTags.func_74762_e("infuseStored");
        this.infuseStored.type = InfuseRegistry.get(nbtTags.func_74779_i("type"));
        for (int i = 0; i < this.tier.processes; ++i) {
            this.progress[i] = nbtTags.func_74762_e("progress" + i);
        }
        this.gasTank.read(nbtTags.func_74775_l("gasTank"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74768_a("recipeType", this.recipeType.ordinal());
        nbtTags.func_74768_a("recipeTicks", this.recipeTicks);
        nbtTags.func_74757_a("sorting", this.sorting);
        nbtTags.func_74768_a("infuseStored", this.infuseStored.amount);
        if (this.infuseStored.type != null) {
            nbtTags.func_74778_a("type", this.infuseStored.type.name);
        } else {
            nbtTags.func_74778_a("type", "null");
        }
        for (int i = 0; i < this.tier.processes; ++i) {
            nbtTags.func_74768_a("progress" + i, this.progress[i]);
        }
        nbtTags.func_74782_a("gasTank", (NBTBase)this.gasTank.write(new NBTTagCompound()));
        return nbtTags;
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        data.add(this.recipeType.ordinal());
        data.add(this.recipeTicks);
        data.add(this.sorting);
        data.add(this.upgraded);
        data.add(this.lastUsage);
        data.add(this.infuseStored.amount);
        if (this.infuseStored.type != null) {
            data.add(this.infuseStored.type.name);
        } else {
            data.add("null");
        }
        data.add(this.progress);
        if (this.gasTank.getGas() != null) {
            data.add(true);
            data.add(this.gasTank.getGas().getGas().getID());
            data.add(this.gasTank.getStored());
        } else {
            data.add(false);
        }
        this.upgraded = false;
        return data;
    }

    public int getInputSlot(int operation) {
        return 5 + operation;
    }

    private int getOperation(int inputSlot) {
        return inputSlot - 5;
    }

    public int getOutputSlot(int operation) {
        return 5 + this.tier.processes + operation;
    }

    @Override
    public String func_70005_c_() {
        if (I18n.func_94522_b((String)("tile." + this.tier.getBaseTier().func_176610_l() + this.recipeType.getUnlocalizedName() + "Factory"))) {
            return LangUtils.localize("tile." + this.tier.getBaseTier().func_176610_l() + this.recipeType.getUnlocalizedName() + "Factory");
        }
        return this.tier.getBaseTier().getLocalizedName() + " " + this.recipeType.getLocalizedName() + " " + super.func_70005_c_();
    }

    @Override
    public String[] getMethods() {
        return methods;
    }

    @Override
    public Object[] invoke(int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                return new Object[]{this.electricityStored};
            }
            case 1: {
                if (arguments[0] == null) {
                    return new Object[]{"Please provide a target operation."};
                }
                if (!(arguments[0] instanceof Double) && !(arguments[0] instanceof Integer)) {
                    return new Object[]{"Invalid characters."};
                }
                if ((Integer)arguments[0] < 0 || (Integer)arguments[0] > this.progress.length) {
                    return new Object[]{"No such operation found."};
                }
                return new Object[]{this.progress[(Integer)arguments[0]]};
            }
            case 2: {
                return new Object[]{this.facing};
            }
            case 3: {
                if (arguments[0] == null) {
                    return new Object[]{"Please provide a target operation."};
                }
                if (!(arguments[0] instanceof Double) && !(arguments[0] instanceof Integer)) {
                    return new Object[]{"Invalid characters."};
                }
                if ((Integer)arguments[0] < 0 || (Integer)arguments[0] > this.progress.length) {
                    return new Object[]{"No such operation found."};
                }
                return new Object[]{this.canOperate(this.getInputSlot((Integer)arguments[0]), this.getOutputSlot((Integer)arguments[0]))};
            }
            case 4: {
                return new Object[]{this.getMaxEnergy()};
            }
            case 5: {
                return new Object[]{this.getMaxEnergy() - this.getEnergy()};
            }
        }
        throw new NoSuchMethodException();
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return this.configComponent.getOutput((TransmissionType)TransmissionType.ITEM, (EnumFacing)side, (EnumFacing)this.facing).availableSlots;
    }

    @Override
    public boolean canSetFacing(int side) {
        return side != 0 && side != 1;
    }

    @Override
    public TileComponentConfig getConfig() {
        return this.configComponent;
    }

    @Override
    public EnumFacing getOrientation() {
        return this.facing;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public SoundWrapper getSound() {
        return this.sounds[this.recipeType.ordinal()];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initSounds() {
        this.sounds = new SoundWrapper[IFactory.RecipeType.values().length];
        for (IFactory.RecipeType type : IFactory.RecipeType.values()) {
            this.sounds[type.ordinal()] = new SoundWrapper(this, this, HolidayManager.filterSound(type.getSound()));
        }
    }

    @Override
    public TileComponentEjector getEjector() {
        return this.ejectorComponent;
    }

    @Override
    public int receiveGas(EnumFacing side, GasStack stack, boolean doTransfer) {
        if (this.canReceiveGas(side, stack.getGas())) {
            return this.gasTank.receive(stack, doTransfer);
        }
        return 0;
    }

    @Override
    public boolean canReceiveGas(EnumFacing side, Gas type) {
        if (this.configComponent.getOutput(TransmissionType.GAS, side, this.facing).hasSlot(0)) {
            return this.recipeType.canReceiveGas(side, type);
        }
        return false;
    }

    @Override
    public boolean canTubeConnect(EnumFacing side) {
        if (this.recipeType.canTubeConnect(side)) {
            return this.configComponent.getOutput(TransmissionType.GAS, side, this.facing).hasSlot(0);
        }
        return false;
    }

    @Override
    public GasStack drawGas(EnumFacing side, int amount, boolean doTransfer) {
        return null;
    }

    @Override
    public boolean canDrawGas(EnumFacing side, Gas type) {
        return false;
    }

    @Override
    @Nonnull
    public GasTankInfo[] getTankInfo() {
        return new GasTankInfo[]{this.gasTank};
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing side) {
        return capability == Capabilities.GAS_HANDLER_CAPABILITY || capability == Capabilities.TUBE_CONNECTION_CAPABILITY || capability == Capabilities.CONFIG_CARD_CAPABILITY || capability == Capabilities.SPECIAL_CONFIG_DATA_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == Capabilities.GAS_HANDLER_CAPABILITY || capability == Capabilities.TUBE_CONNECTION_CAPABILITY || capability == Capabilities.CONFIG_CARD_CAPABILITY || capability == Capabilities.SPECIAL_CONFIG_DATA_CAPABILITY) {
            return (T)this;
        }
        return super.getCapability(capability, side);
    }

    @Override
    public void recalculateUpgradables(Upgrade upgrade) {
        super.recalculateUpgradables(upgrade);
        switch (upgrade) {
            case ENERGY: {
                this.energyPerTick = MekanismUtils.getEnergyPerTick(this, this.BASE_ENERGY_PER_TICK);
                break;
            }
            case GAS: {
                this.secondaryEnergyPerTick = this.getSecondaryEnergyPerTick(this.recipeType);
                break;
            }
            case SPEED: {
                this.ticksRequired = MekanismUtils.getTicks(this, this.BASE_TICKS_REQUIRED);
                this.energyPerTick = MekanismUtils.getEnergyPerTick(this, this.BASE_ENERGY_PER_TICK);
                this.secondaryEnergyPerTick = this.getSecondaryEnergyPerTick(this.recipeType);
                break;
            }
        }
    }

    @Override
    public NBTTagCompound getConfigurationData(NBTTagCompound nbtTags) {
        nbtTags.func_74757_a("sorting", this.sorting);
        return nbtTags;
    }

    @Override
    public void setConfigurationData(NBTTagCompound nbtTags) {
        this.sorting = nbtTags.func_74767_n("sorting");
    }

    @Override
    public String getDataType() {
        return this.tier.getBaseTier().getLocalizedName() + " " + this.recipeType.getLocalizedName() + " " + super.func_70005_c_();
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        this.infuseStored.writeSustainedData(itemStack);
        GasUtils.writeSustainedData(this.gasTank, itemStack);
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        this.infuseStored.readSustainedData(itemStack);
        GasUtils.readSustainedData(this.gasTank, itemStack);
    }

    public static class InvID {
        public ItemStack stack;
        public int ID;

        public InvID(ItemStack s, int i) {
            this.stack = s;
            this.ID = i;
        }

        public int size() {
            return !this.stack.func_190926_b() ? this.stack.func_190916_E() : 0;
        }

        public Item item() {
            return !this.stack.func_190926_b() ? this.stack.func_77973_b() : null;
        }

        public static InvID get(int id, NonNullList<ItemStack> inv) {
            return new InvID((ItemStack)inv.get(id), id);
        }
    }
}

