/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import javax.annotation.Nonnull;
import mekanism.common.Mekanism;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.RecipeUtils;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class ShapelessMekanismRecipe
extends ShapelessOreRecipe {
    public ShapelessMekanismRecipe(ResourceLocation group, Block result, Object ... recipe) {
        this(group, new ItemStack(result), recipe);
    }

    public ShapelessMekanismRecipe(ResourceLocation group, Item result, Object ... recipe) {
        this(group, new ItemStack(result), recipe);
    }

    public ShapelessMekanismRecipe(ResourceLocation group, NonNullList<Ingredient> input, @Nonnull ItemStack result) {
        super(group, input, result);
    }

    public ShapelessMekanismRecipe(ResourceLocation group, @Nonnull ItemStack result, Object ... recipe) {
        super(group, result, recipe);
    }

    @Nonnull
    public ItemStack func_77572_b(@Nonnull InventoryCrafting inv) {
        return RecipeUtils.getCraftingResult(inv, this.output.func_77946_l());
    }

    public static ShapelessMekanismRecipe create(NBTTagCompound nbtTags) {
        if (!nbtTags.func_74764_b("result") || !nbtTags.func_74764_b("input")) {
            Mekanism.logger.error("[Mekanism] Shapeless recipe parse error: missing input or result compound tag.");
            return null;
        }
        ItemStack result = InventoryUtils.loadFromNBT(nbtTags.func_74775_l("result"));
        NBTTagList list = nbtTags.func_150295_c("input", 10);
        if (result.func_190926_b() || list.func_74745_c() == 0) {
            Mekanism.logger.error("[Mekanism] Shapeless recipe parse error: invalid result stack or input data list.");
            return null;
        }
        Object[] ret = new Object[list.func_74745_c()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound compound = list.func_150305_b(i);
            if (compound.func_74764_b("oredict")) {
                ret[i] = compound.func_74779_i("oredict");
                continue;
            }
            if (compound.func_74764_b("itemstack")) {
                ret[i] = InventoryUtils.loadFromNBT(compound.func_74775_l("itemstack"));
                continue;
            }
            Mekanism.logger.error("[Mekanism] Shapeless recipe parse error: invalid input tag data key.");
            return null;
        }
        return new ShapelessMekanismRecipe(null, result, ret);
    }

    public static ShapelessMekanismRecipe factory(JsonContext context, JsonObject json) {
        String group = JsonUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
        NonNullList ings = NonNullList.func_191196_a();
        for (JsonElement ele : JsonUtils.func_151214_t((JsonObject)json, (String)"ingredients")) {
            ings.add((Object)CraftingHelper.getIngredient((JsonElement)ele, (JsonContext)context));
        }
        if (ings.isEmpty()) {
            throw new JsonParseException("No ingredients for shapeless recipe");
        }
        ItemStack itemstack = ShapedRecipes.func_192405_a((JsonObject)JsonUtils.func_152754_s((JsonObject)json, (String)"result"), (boolean)true);
        return new ShapelessMekanismRecipe(group.isEmpty() ? null : new ResourceLocation(group), (NonNullList<Ingredient>)ings, itemstack);
    }

    public static class RecipeFactory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            return ShapelessMekanismRecipe.factory(context, json);
        }
    }
}

