/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import io.netty.buffer.ByteBuf;
import mekanism.api.Coord4D;
import mekanism.common.PacketHandler;
import mekanism.common.base.IRedstoneControl;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketRedstoneControl
implements IMessageHandler<RedstoneControlMessage, IMessage> {
    public IMessage onMessage(RedstoneControlMessage message, MessageContext context) {
        EntityPlayer player = PacketHandler.getPlayer(context);
        PacketHandler.handlePacket(() -> {
            TileEntity tileEntity = message.coord4D.getTileEntity((IBlockAccess)player.field_70170_p);
            if (tileEntity instanceof IRedstoneControl) {
                ((IRedstoneControl)tileEntity).setControlType(message.value);
            }
        }, player);
        return null;
    }

    public static class RedstoneControlMessage
    implements IMessage {
        public Coord4D coord4D;
        public IRedstoneControl.RedstoneControl value;

        public RedstoneControlMessage() {
        }

        public RedstoneControlMessage(Coord4D coord, IRedstoneControl.RedstoneControl control) {
            this.coord4D = coord;
            this.value = control;
        }

        public void toBytes(ByteBuf dataStream) {
            this.coord4D.write(dataStream);
            dataStream.writeInt(this.value.ordinal());
        }

        public void fromBytes(ByteBuf dataStream) {
            this.coord4D = Coord4D.read(dataStream);
            this.value = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
        }
    }
}

