/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.util;

import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.utils.BaseMapAddition;
import java.util.Map;
import mekanism.common.recipe.inputs.MachineInput;
import mekanism.common.recipe.machines.MachineRecipe;
import mekanism.common.recipe.outputs.ChanceOutput;
import mekanism.common.recipe.outputs.ChemicalPairOutput;
import mekanism.common.recipe.outputs.FluidOutput;
import mekanism.common.recipe.outputs.GasOutput;
import mekanism.common.recipe.outputs.ItemStackOutput;
import mekanism.common.recipe.outputs.PressurizedOutput;
import net.minecraftforge.fluids.FluidStack;

public class AddMekanismRecipe
extends BaseMapAddition<MachineInput, MachineRecipe> {
    private MachineRecipe recipe;

    public AddMekanismRecipe(String name, Map<MachineInput, MachineRecipe> map, MachineRecipe recipe) {
        super(name, map);
        this.recipe = recipe;
    }

    public void addRecipes() {
        this.recipes.put(this.recipe.getInput(), this.recipe);
    }

    public void apply() {
        this.addRecipes();
        super.apply();
    }

    protected String getRecipeInfo(Map.Entry<MachineInput, MachineRecipe> recipe) {
        Object output = recipe.getValue().recipeOutput;
        if (output instanceof ItemStackOutput) {
            return LogHelper.getStackDescription((Object)((ItemStackOutput)output).output);
        }
        if (output instanceof GasOutput) {
            return LogHelper.getStackDescription((Object)((GasOutput)output).output);
        }
        if (output instanceof FluidOutput) {
            return LogHelper.getStackDescription((FluidStack)((FluidOutput)output).output);
        }
        if (output instanceof ChemicalPairOutput) {
            return "[" + LogHelper.getStackDescription((Object)((ChemicalPairOutput)output).leftGas) + ", " + LogHelper.getStackDescription((Object)((ChemicalPairOutput)output).rightGas) + "]";
        }
        if (output instanceof ChanceOutput) {
            return LogHelper.getStackDescription((Object)((ChanceOutput)output).primaryOutput);
        }
        if (output instanceof PressurizedOutput) {
            return "[" + LogHelper.getStackDescription((Object)((PressurizedOutput)output).getItemOutput()) + ", " + LogHelper.getStackDescription((Object)((PressurizedOutput)output).getGasOutput()) + "]";
        }
        return null;
    }
}

