/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.helpers;

import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IngredientAny;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.common.integration.crafttweaker.gas.IGasStack;

public class GasHelper {
    private GasHelper() {
    }

    public static boolean matches(IIngredient ingredient, IGasStack gasStack) {
        if (ingredient == null) {
            return false;
        }
        if (ingredient == IngredientAny.INSTANCE) {
            return true;
        }
        if (ingredient instanceof IGasStack) {
            return GasHelper.toGas((IGasStack)ingredient).isGasEqual(GasHelper.toGas(gasStack));
        }
        return false;
    }

    public static GasStack toGas(IGasStack iStack) {
        if (iStack == null) {
            return null;
        }
        return new GasStack(GasRegistry.getGas(iStack.getName()), iStack.getAmount());
    }

    public static GasStack[] toGases(IGasStack[] iStack) {
        GasStack[] stack = new GasStack[iStack.length];
        for (int i = 0; i < stack.length; ++i) {
            stack[i] = GasHelper.toGas(iStack[i]);
        }
        return stack;
    }
}

