/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.handlers;

import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.helpers.StackHelper;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IngredientAny;
import crafttweaker.api.liquid.ILiquidStack;
import java.util.HashMap;
import java.util.Map;
import mekanism.common.integration.crafttweaker.CrafttweakerIntegration;
import mekanism.common.integration.crafttweaker.util.AddMekanismRecipe;
import mekanism.common.integration.crafttweaker.util.RemoveMekanismRecipe;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.FluidInput;
import mekanism.common.recipe.inputs.MachineInput;
import mekanism.common.recipe.machines.MachineRecipe;
import mekanism.common.recipe.machines.ThermalEvaporationRecipe;
import mekanism.common.recipe.outputs.FluidOutput;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.mekanism.thermalevaporation")
@ModOnly(value="mtlib")
@ZenRegister
public class ThermalEvaporation {
    public static final String NAME = "Mekanism Solar Evaporation";

    @ZenMethod
    public static void addRecipe(ILiquidStack liquidInput, ILiquidStack liquidOutput) {
        if (liquidInput == null || liquidOutput == null) {
            LogHelper.logError((String)String.format("Required parameters missing for %s Recipe.", NAME));
            return;
        }
        ThermalEvaporationRecipe recipe = new ThermalEvaporationRecipe(InputHelper.toFluid((ILiquidStack)liquidInput), InputHelper.toFluid((ILiquidStack)liquidOutput));
        CrafttweakerIntegration.LATE_ADDITIONS.add((IAction)new AddMekanismRecipe(NAME, RecipeHandler.Recipe.THERMAL_EVAPORATION_PLANT.get(), recipe));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient liquidInput, @Optional IIngredient liquidOutput) {
        if (liquidInput == null) {
            LogHelper.logError((String)String.format("Required parameters missing for %s Recipe.", NAME));
            return;
        }
        if (liquidOutput == null) {
            liquidOutput = IngredientAny.INSTANCE;
        }
        CrafttweakerIntegration.LATE_REMOVALS.add((IAction)new Remove(NAME, RecipeHandler.Recipe.THERMAL_EVAPORATION_PLANT.get(), liquidInput, liquidOutput));
    }

    private static class Remove
    extends RemoveMekanismRecipe {
        private IIngredient liquidInput;
        private IIngredient liquidOutput;

        public Remove(String name, Map<MachineInput, MachineRecipe> map, IIngredient liquidInput, IIngredient liquidOutput) {
            super(name, map);
            this.liquidInput = liquidInput;
            this.liquidOutput = liquidOutput;
        }

        @Override
        public void addRecipes() {
            HashMap recipesToRemove = new HashMap();
            for (Map.Entry entry : RecipeHandler.Recipe.THERMAL_EVAPORATION_PLANT.get().entrySet()) {
                ILiquidStack inputLiquid = InputHelper.toILiquidStack((FluidStack)((FluidInput)entry.getKey()).ingredient);
                ILiquidStack outputLiquid = InputHelper.toILiquidStack((FluidStack)((FluidOutput)((ThermalEvaporationRecipe)entry.getValue()).recipeOutput).output);
                if (!StackHelper.matches((IIngredient)this.liquidInput, (ILiquidStack)inputLiquid) || !StackHelper.matches((IIngredient)this.liquidOutput, (ILiquidStack)outputLiquid)) continue;
                recipesToRemove.put(entry.getKey(), entry.getValue());
            }
            if (!recipesToRemove.isEmpty()) {
                this.recipes.putAll(recipesToRemove);
            } else {
                LogHelper.logWarning((String)String.format("No %s recipe found for %s and %s. Command ignored!", ThermalEvaporation.NAME, this.liquidInput.toString(), this.liquidOutput.toString()));
            }
        }
    }
}

