/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.handlers;

import com.blamejared.mtlib.helpers.LogHelper;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IngredientAny;
import java.util.HashMap;
import java.util.Map;
import mekanism.common.integration.crafttweaker.CrafttweakerIntegration;
import mekanism.common.integration.crafttweaker.gas.CraftTweakerGasStack;
import mekanism.common.integration.crafttweaker.gas.IGasStack;
import mekanism.common.integration.crafttweaker.helpers.GasHelper;
import mekanism.common.integration.crafttweaker.util.AddMekanismRecipe;
import mekanism.common.integration.crafttweaker.util.RemoveMekanismRecipe;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.ChemicalPairInput;
import mekanism.common.recipe.inputs.MachineInput;
import mekanism.common.recipe.machines.ChemicalInfuserRecipe;
import mekanism.common.recipe.machines.MachineRecipe;
import mekanism.common.recipe.outputs.GasOutput;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.mekanism.chemical.infuser")
@ModOnly(value="mtlib")
@ZenRegister
public class ChemicalInfuser {
    public static final String NAME = "Mekanism Chemical Infuser";

    @ZenMethod
    public static void addRecipe(IGasStack leftGasInput, IGasStack rightGasInput, IGasStack gasOutput) {
        if (leftGasInput == null || rightGasInput == null || gasOutput == null) {
            LogHelper.logError((String)String.format("Required parameters missing for %s Recipe.", NAME));
            return;
        }
        ChemicalInfuserRecipe recipe = new ChemicalInfuserRecipe(GasHelper.toGas(leftGasInput), GasHelper.toGas(rightGasInput), GasHelper.toGas(gasOutput));
        CrafttweakerIntegration.LATE_ADDITIONS.add((IAction)new AddMekanismRecipe(NAME, RecipeHandler.Recipe.CHEMICAL_INFUSER.get(), recipe));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient gasOutput, @Optional IIngredient leftGasInput, @Optional IIngredient rightGasInput) {
        if (gasOutput == null) {
            LogHelper.logError((String)String.format("Required parameters missing for %s Recipe.", NAME));
            return;
        }
        if (leftGasInput == null) {
            leftGasInput = IngredientAny.INSTANCE;
        }
        if (rightGasInput == null) {
            rightGasInput = IngredientAny.INSTANCE;
        }
        CrafttweakerIntegration.LATE_REMOVALS.add((IAction)new Remove(NAME, RecipeHandler.Recipe.CHEMICAL_INFUSER.get(), gasOutput, leftGasInput, rightGasInput));
    }

    private static class Remove
    extends RemoveMekanismRecipe {
        private IIngredient gasOutput;
        private IIngredient leftGasInput;
        private IIngredient rightGasInput;

        public Remove(String name, Map<MachineInput, MachineRecipe> map, IIngredient gasOutput, IIngredient leftGasInput, IIngredient rightGasInput) {
            super(name, map);
            this.gasOutput = gasOutput;
            this.leftGasInput = leftGasInput;
            this.rightGasInput = rightGasInput;
        }

        @Override
        public void addRecipes() {
            HashMap recipesToRemove = new HashMap();
            for (Map.Entry entry : RecipeHandler.Recipe.CHEMICAL_INFUSER.get().entrySet()) {
                CraftTweakerGasStack inputGasLeft = new CraftTweakerGasStack(((ChemicalPairInput)entry.getKey()).leftGas);
                CraftTweakerGasStack inputGasRight = new CraftTweakerGasStack(((ChemicalPairInput)entry.getKey()).rightGas);
                CraftTweakerGasStack outputGas = new CraftTweakerGasStack(((GasOutput)((ChemicalInfuserRecipe)entry.getValue()).recipeOutput).output);
                if (!GasHelper.matches(this.gasOutput, outputGas) || !GasHelper.matches(this.leftGasInput, inputGasLeft) || !GasHelper.matches(this.rightGasInput, inputGasRight)) continue;
                recipesToRemove.put(entry.getKey(), entry.getValue());
            }
            if (!recipesToRemove.isEmpty()) {
                this.recipes.putAll(recipesToRemove);
            } else {
                LogHelper.logWarning((String)String.format("No %s recipe found for %s, %s and %s. Command ignored!", ChemicalInfuser.NAME, this.gasOutput.toString(), this.leftGasInput.toString(), this.rightGasInput.toString()));
            }
        }
    }
}

