/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.transporter;

import io.netty.buffer.ByteBuf;
import mekanism.common.PacketHandler;
import mekanism.common.base.TileNetworkList;
import mekanism.common.content.transporter.Finder;
import mekanism.common.content.transporter.TransporterFilter;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TModIDFilter
extends TransporterFilter {
    public String modID;

    @Override
    public boolean canFilter(ItemStack itemStack, boolean strict) {
        if (itemStack.func_190926_b()) {
            return false;
        }
        return new Finder.ModIDFinder(this.modID).modifies(itemStack);
    }

    @Override
    public Finder getFinder() {
        return new Finder.ModIDFinder(this.modID);
    }

    @Override
    public void write(NBTTagCompound nbtTags) {
        super.write(nbtTags);
        nbtTags.func_74768_a("type", 3);
        nbtTags.func_74778_a("modID", this.modID);
    }

    @Override
    protected void read(NBTTagCompound nbtTags) {
        super.read(nbtTags);
        this.modID = nbtTags.func_74779_i("modID");
    }

    @Override
    public void write(TileNetworkList data) {
        data.add(3);
        super.write(data);
        data.add(this.modID);
    }

    @Override
    protected void read(ByteBuf dataStream) {
        super.read(dataStream);
        this.modID = PacketHandler.readString(dataStream);
    }

    @Override
    public int hashCode() {
        int code = 1;
        code = 31 * code + super.hashCode();
        code = 31 * code + this.modID.hashCode();
        return code;
    }

    @Override
    public boolean equals(Object filter) {
        return super.equals(filter) && filter instanceof TModIDFilter && ((TModIDFilter)filter).modID.equals(this.modID);
    }

    public TModIDFilter clone() {
        TModIDFilter filter = new TModIDFilter();
        filter.allowDefault = this.allowDefault;
        filter.color = this.color;
        filter.modID = this.modID;
        return filter;
    }
}

